/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.project;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.pull.PullRequestMergeConfigRestrictionEnricher;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeConfig;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeStrategy;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestSettings;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.DeletePullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.SetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionAction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.atlassian.stash.internal.rest.pull.RestRestrictedPullRequestMergeConfig;
import com.atlassian.stash.internal.rest.util.RestMergeConfigUtils;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/settings")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Project")
public class ProjectSettingsResource
extends AbstractPullRequestResource {
    private final PullRequestMergeConfigRestrictionEnricher configEnricher;
    private final ProjectSettingsRestrictionService restrictionService;

    @Inject
    public ProjectSettingsResource(I18nService i18nService, DmzPullRequestService pullRequestService, PullRequestMergeConfigRestrictionEnricher configEnricher, ProjectSettingsRestrictionService restrictionService) {
        super(i18nService, pullRequestService);
        this.configEnricher = configEnricher;
        this.restrictionService = restrictionService;
    }

    @Operation(description="Retrieve the merge strategy configuration for this project and SCM. \n\nThe authenticated user must have <strong>PROJECT_READ</strong> permission for the context repository to call this resource.", summary="Get merge strategy")
    @Parameters(value={@Parameter(description="The SCM to get strategies for.", in=ParameterIn.PATH, name="scmId"), @Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY)", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The merge configuration of the request project.", representation=RestPullRequestSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the request repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The request repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/pull-requests/{scmId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequestSettings(@BeanParam ProjectResolver projectResolver, @PathParam(value="scmId") String scmId, @QueryParam(value="enrich") boolean enrich) {
        try {
            return ResponseFactory.ok((Object)this.readPullRequestSettings(projectResolver.getProject(), scmId, enrich)).build();
        }
        catch (FeatureUnsupportedScmException e) {
            return ResponseFactory.noContent().build();
        }
    }

    @Operation(description="Update the pull request merge strategy configuration for this project and SCM. \n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the context repository to call this resource. \n\nOnly the strategies provided will be enabled, the default must be set and included in the set of strategies. \n\nAn explicitly set pull request merge strategy configuration can be deleted by POSTing a document with an empty \"mergeConfig\" attribute. i.e: \n<pre>{ \n    \"mergeConfig\": {} \n} \n</pre>\n\nUpon completion of this request, the effective configuration will be the configuration explicitly set for the SCM, or if no such explicit configuration is set then the default configuration will be used.", summary="Update merge strategy")
    @Parameters(value={@Parameter(description="The SCM to get strategies for.", in=ParameterIn.PATH, name="scmId"), @Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY)", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestPullRequestSettings.class))}, description="The settings.")
    @ResponseDocs(value={@ResponseDoc(documentation="The merge configuration of the request project.", representation=RestPullRequestSettings.class, responseCode=200), @ResponseDoc(documentation="The repository pull request merge strategies were not updated due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to administrate the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="/pull-requests/{scmId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updatePullRequestSettings(@BeanParam ProjectResolver projectResolver, @PathParam(value="scmId") String scmId, @QueryParam(value="enrich") boolean enrich, RestPullRequestSettings settings) {
        Project project = projectResolver.getProject();
        RestRestrictedPullRequestMergeConfig mergeConfig = RestRestrictedPullRequestMergeConfig.valueOf(settings.getMergeConfig());
        if (mergeConfig != null && mergeConfig.isEmpty()) {
            this.pullRequestService.deleteMergeConfig(new DeletePullRequestMergeConfigRequest.Builder(project, scmId).build());
        } else {
            RestPullRequestMergeStrategy defaultStrategy = RestMergeConfigUtils.verifyDefaultStrategy(mergeConfig, this.i18nService);
            Set<String> mergeStrategyIds = RestMergeConfigUtils.getMergeStrategyIds(mergeConfig.getStrategies());
            RestPullRequestCommitMessageTemplate template = RestMergeConfigUtils.verifyCommitMessageTemplate(mergeConfig, this.i18nService);
            this.restrictionService.withRestriction(project, ProjectSettingsRestrictionKeys.MERGE_STRATEGIES, (ProjectSettingsRestrictionAction)MoreObjects.firstNonNull((Object)mergeConfig.getRestrictionAction(), (Object)ProjectSettingsRestrictionAction.NONE), () -> {
                SetPullRequestMergeConfigRequest.Builder builder = new SetPullRequestMergeConfigRequest.Builder(project, scmId).commitSummaries(mergeConfig.getCommitSummaries()).defaultStrategyId(defaultStrategy.getId()).enabledStrategyIds((Iterable)mergeStrategyIds);
                if (template != null) {
                    if (template.isEmpty()) {
                        builder.commitMessageTemplate(null);
                    } else {
                        builder.commitMessageTemplate((PullRequestCommitMessageTemplate)template);
                    }
                }
                this.pullRequestService.setMergeConfig(builder.build());
                return null;
            });
        }
        return ResponseFactory.ok((Object)this.readPullRequestSettings(project, scmId, enrich)).build();
    }

    private RestPullRequestSettings readPullRequestSettings(Project project, String scmId, boolean enrich) {
        PullRequestMergeConfig mergeConfig = this.pullRequestService.getMergeConfig(new GetPullRequestMergeConfigRequest.Builder(project, scmId).build());
        RestPullRequestMergeConfig restMergeConfig = enrich ? new RestRestrictedPullRequestMergeConfig(this.configEnricher.enrich(mergeConfig, project)) : new RestPullRequestMergeConfig(mergeConfig);
        return new RestPullRequestSettings(restMergeConfig);
    }
}

