/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.comment.AddCommentReplyRequest;
import com.atlassian.bitbucket.comment.AddCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.AddLineCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.CommentUpdateRequest;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.dmz.comment.AddMultilineCommentRequest;
import com.atlassian.bitbucket.dmz.comment.DmzCommentService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.NotFoundException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.v2.api.resolver.CommentResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.atlassian.stash.internal.rest.util.CommentUtils;
import com.atlassian.stash.internal.rest.util.MultilineCommentValidator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPullRequestCommentResource
extends AbstractPullRequestResource {
    protected final DmzCommentService commentService;
    private final MultilineCommentValidator multilineCommentValidator;

    protected AbstractPullRequestCommentResource(DmzCommentService commentService, I18nService i18nService, DmzPullRequestService pullRequestService, MultilineCommentValidator multilineCommentValidator) {
        super(i18nService, pullRequestService);
        this.commentService = commentService;
        this.multilineCommentValidator = multilineCommentValidator;
    }

    protected Response createComment(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver, @Context UriInfo uriInfo, RestComment comment) {
        Comment created;
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        String commentText = comment.getText();
        if (StringUtils.isBlank((CharSequence)commentText)) {
            String message = this.i18nService.getMessage("bitbucket.rest.comment.addrequirestext", new Object[0]);
            throw new BadRequestException(message);
        }
        if (comment.isReply()) {
            Comment parent = this.doGetComment(pullRequest, comment.getParent().getId());
            created = this.commentService.addReply(new AddCommentReplyRequest.Builder(parent.getId(), commentText).pending(comment.isPending()).severity(this.toSeverity(comment.getSeverity())).build());
        } else if (comment.isAnchored()) {
            RestCommentThreadDiffAnchor anchor = comment.getAnchor();
            CommentThreadDiffAnchorType diffType = this.getDiffType(anchor);
            if (anchor.isLineComment()) {
                this.validateLineAnchor(anchor);
                if (anchor.isMultilineComment() || anchor.getMultilineSpan() != null) {
                    List<RestErrorMessage> errors = this.multilineCommentValidator.validateMultilineAnchor(anchor);
                    if (!errors.isEmpty()) {
                        return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(errors)).build();
                    }
                    AddMultilineCommentRequest multilineCommentRequest = CommentUtils.createMultilineCommentRequest(anchor.getFromHash(), anchor.getToHash(), comment, diffType, this.toSeverity(comment.getSeverity()), (Commentable)pullRequest, anchor);
                    created = this.commentService.addComment(multilineCommentRequest);
                } else {
                    created = this.commentService.addComment(((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)new AddLineCommentRequest.Builder((Commentable)pullRequest, commentText, diffType, anchor.getPath().toString()).fileType(Optional.ofNullable(anchor.getFileType()).orElse(DiffFileType.forSegmentType((DiffSegmentType)anchor.getLineType())))).fromHash(anchor.getFromHash())).line(anchor.getLine())).lineType(anchor.getLineType())).pending(comment.isPending())).severity(this.toSeverity(comment.getSeverity()))).srcPath((String)Optional.ofNullable(anchor.getSrcPath()).map(Object::toString).orElse(null))).toHash(anchor.getToHash())).build());
                }
            } else {
                created = this.commentService.addComment(((AddFileCommentRequest.Builder)((AddFileCommentRequest.Builder)((AddFileCommentRequest.Builder)((AddFileCommentRequest.Builder)((AddFileCommentRequest.Builder)new AddFileCommentRequest.Builder((Commentable)pullRequest, commentText, diffType, anchor.getPath().toString()).fromHash(anchor.getFromHash())).pending(comment.isPending())).severity(this.toSeverity(comment.getSeverity()))).srcPath((String)Optional.ofNullable(anchor.getSrcPath()).map(Object::toString).orElse(null))).toHash(anchor.getToHash())).build());
            }
        } else {
            created = this.commentService.addComment(((AddCommentRequest.Builder)((AddCommentRequest.Builder)new AddCommentRequest.Builder((Commentable)pullRequest, commentText).severity(this.toSeverity(comment.getSeverity()))).pending(comment.isPending())).build());
        }
        URI uri = uriInfo.getRequestUriBuilder().path(String.valueOf(created.getId())).build(new Object[0]);
        return ResponseFactory.created((URI)uri).entity((Object)new RestComment(created)).build();
    }

    protected Response deleteComment(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam CommentResolver commentResolver, @QueryParam(value="version") @DefaultValue(value="-1") int version) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        Comment comment = commentResolver.getComment();
        if (!comment.getThread().getCommentable().equals((Object)pullRequest)) {
            throw this.noSuchCommentException(comment.getId());
        }
        this.commentService.deleteComment(comment.getId(), version);
        return ResponseFactory.noContent().build();
    }

    protected Response getComment(@BeanParam PullRequestResolver pullRequestResolver, @PathParam(value="commentId") long commentId) {
        Comment comment = this.doGetComment(pullRequestResolver.getPullRequest(), commentId);
        return ResponseFactory.ok((Object)new RestComment(comment)).build();
    }

    @Nullable
    protected CommentState toCommentState(@Nonnull String commentState, CommentState ... validStates) {
        try {
            return StringUtils.isEmpty((CharSequence)commentState) ? null : CommentState.valueOf((String)commentState.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comment.invalidstate", new Object[]{commentState, this.toUppercaseNames((Enum[])validStates)}));
        }
    }

    protected Response updateComment(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam CommentResolver commentResolver, RestComment restComment) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        Comment comment = commentResolver.getComment();
        if (!comment.getThread().getCommentable().equals((Object)pullRequest)) {
            throw this.noSuchCommentException(comment.getId());
        }
        Comment updated = this.commentService.updateComment(new CommentUpdateRequest.Builder(comment.getId()).severity(this.toSeverity(restComment.getSeverity())).state(this.toCommentState(restComment.getState(), CommentState.OPEN, CommentState.RESOLVED)).text(restComment.getText()).version(restComment.getVersion()).threadResolved(restComment.hasThreadResolved() ? Boolean.valueOf(restComment.isThreadResolved()) : null).build());
        return ResponseFactory.ok((Object)new RestComment(updated)).build();
    }

    private Comment doGetComment(PullRequest pullRequest, long commentId) {
        Optional comment = this.commentService.getComment(commentId);
        if (comment.isPresent() && Objects.equals(pullRequest, ((Comment)comment.get()).getThread().getCommentable())) {
            return (Comment)comment.get();
        }
        throw this.noSuchCommentException(commentId);
    }

    private CommentThreadDiffAnchorType getDiffType(RestCommentThreadDiffAnchor anchor) {
        CommentThreadDiffAnchorType diffType = anchor.getDiffType();
        if (diffType == null) {
            if (anchor.getToHash() == null && anchor.getFromHash() == null) {
                return CommentThreadDiffAnchorType.EFFECTIVE;
            }
            throw new BadRequestException("anchor.diffType", this.i18nService.getMessage("bitbucket.rest.comment.anchor.missingdifftype", new Object[0]));
        }
        return diffType;
    }

    private NotFoundException noSuchCommentException(long comment) {
        return new NotFoundException(this.i18nService.getMessage("bitbucket.rest.nosuchcomment", new Object[]{String.valueOf(comment)}));
    }

    @Nullable
    private CommentSeverity toSeverity(@Nonnull String severity) {
        try {
            return StringUtils.isEmpty((CharSequence)severity) ? null : CommentSeverity.valueOf((String)severity.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comment.invalidseverity", new Object[]{severity, this.toUppercaseNames((Enum[])CommentSeverity.values())}));
        }
    }

    private void validateLineAnchor(RestCommentThreadDiffAnchor anchor) {
        if (anchor.getLine() < 1) {
            throw new BadRequestException("anchor.line", this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidline", new Object[]{anchor.getLine()}));
        }
        try {
            if (anchor.getLineType() == null) {
                throw new BadRequestException("anchor.lineType", this.i18nService.getMessage("bitbucket.rest.comment.anchor.emptylinetype", new Object[0]));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("anchor.lineType", this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidlinetype", new Object[]{anchor.get((Object)"lineType")}));
        }
        try {
            anchor.getFileType();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("anchor.fileType", this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidfiletype", new Object[]{anchor.get((Object)"fileType")}));
        }
    }
}

