/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestDiffRequest;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.MoreCollectors;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPullRequestResource {
    protected final I18nService i18nService;
    protected final DmzPullRequestService pullRequestService;

    protected AbstractPullRequestResource(I18nService i18nService, DmzPullRequestService pullRequestService) {
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
    }

    @Nonnull
    protected <T> T ensureHasProperty(@Nonnull String propertyName, @Nullable T value) {
        if (value == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.property.notsupplied", new Object[]{propertyName}));
        }
        return value;
    }

    protected void ensurePropertySupplied(@Nonnull String fieldName, boolean supplied) {
        if (!supplied) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.property.notsupplied", new Object[]{fieldName}));
        }
    }

    protected void ensurePropertyNotSupplied(@Nonnull String fieldName, boolean supplied) {
        if (supplied) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.property.supplied", new Object[]{fieldName}));
        }
    }

    protected Response streamRawDiff(int contextLines, String path, PullRequest pullRequest, String sinceId, String srcPath, String untilId, String whitespace) {
        PullRequestDiffRequest diffRequest = new PullRequestDiffRequest.Builder(pullRequest, path).contextLines(contextLines).sinceId(sinceId).srcPath(srcPath).untilId(untilId).whitespace(DiffWhitespace.fromString((String)whitespace)).build();
        CacheControl cache = StringUtils.isBlank((CharSequence)untilId) ? CachePolicies.noCache() : (StringUtils.isBlank((CharSequence)sinceId) ? CachePolicies.getCacheControlForObjectId((String)untilId) : CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId));
        return ResponseFactory.ok((headers, output) -> this.pullRequestService.streamDiff(diffRequest, contentType -> {
            headers.putSingle((Object)"Content-Type", (Object)contentType);
            return output;
        }), (CacheControl)cache).build();
    }

    @Nonnull
    protected CommentThreadDiffAnchorType toDiffType(@Nonnull String diffType) {
        try {
            return StringUtils.isEmpty((CharSequence)diffType) ? CommentThreadDiffAnchorType.EFFECTIVE : CommentThreadDiffAnchorType.valueOf((String)diffType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.difftype.invalid", new Object[]{this.toUppercaseNames((Enum[])CommentThreadDiffAnchorType.values())}));
        }
    }

    protected PullRequestDirection toDirection(@Nonnull String direction) {
        try {
            return StringUtils.isEmpty((CharSequence)direction) ? PullRequestDirection.INCOMING : PullRequestDirection.valueOf((String)direction.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.direction.invalid", new Object[]{this.toUppercaseNames((Enum[])PullRequestDirection.values())}));
        }
    }

    @Nonnull
    protected List<String> toUppercaseNames(@Nonnull Enum[] values) {
        return (List)Arrays.stream(values).map(value -> value.name().toUpperCase(Locale.ROOT)).collect(MoreCollectors.toImmutableList());
    }
}

