/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PagedCallback;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class JsonCommitCallback
extends AbstractCommitCallback
implements PagedCallback {
    private final Set<String> authors;
    private final Function<Commit, RestCommit> commitTransformer;
    private final PageRequest pageRequest;
    private final boolean withCounts;
    private final StatefulJsonWriter writer;
    private int commitCount;
    private int pageSize;

    public JsonCommitCallback(StatefulJsonWriter writer, Function<Commit, RestCommit> commitTransformer, boolean withCounts, PageRequest pageRequest) {
        this.commitTransformer = commitTransformer;
        this.pageRequest = Objects.requireNonNull(pageRequest, "pageRequest");
        this.withCounts = withCounts && pageRequest.getStart() == 0;
        this.writer = writer;
        this.authors = Sets.newHashSet();
    }

    @Nonnull
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public void paged() {
        this.commitCount = this.pageRequest.getStart();
    }

    public boolean onCommit(@Nonnull Commit commit) throws IOException {
        boolean requestNext;
        ++this.commitCount;
        if (this.commitCount >= this.pageRequest.getStart() + 1 && this.commitCount <= this.pageRequest.getStart() + this.pageRequest.getLimit()) {
            this.writer.value((Object)this.commitTransformer.apply(commit));
            ++this.pageSize;
        }
        boolean bl = requestNext = this.withCounts || this.commitCount <= this.pageRequest.getStart() + this.pageRequest.getLimit() + 1;
        if (this.withCounts) {
            this.authors.add(commit.getAuthor().getName());
        }
        return requestNext;
    }

    public void onEnd(@Nonnull CommitSummary summary) throws IOException {
        boolean lastPage = this.commitCount <= this.pageRequest.getStart() + this.pageRequest.getLimit();
        this.writer.endArray().name("size").value((long)this.pageSize).name("isLastPage").value(lastPage).name("start").value((long)this.pageRequest.getStart()).name("limit").value((long)this.pageRequest.getLimit()).name("nextPageStart");
        if (lastPage) {
            this.writer.nullValue();
        } else {
            this.writer.value((long)(this.pageRequest.getStart() + this.pageRequest.getLimit()));
        }
        if (this.withCounts) {
            this.writer.name("authorCount").value((long)this.authors.size()).name("totalCount").value((long)this.commitCount);
        }
        this.writer.endObject();
    }

    public void onStart(@Nonnull CommitContext context) throws IOException {
        this.writer.beginObject().name("values").beginArray();
    }
}

