/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestDeclineRequest;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeRequest;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestReopenRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalBodyBeanParam {
    private static final Logger log = LoggerFactory.getLogger(OptionalBodyBeanParam.class);
    private final ContainerRequestContext request;

    @Inject
    public OptionalBodyBeanParam(ContainerRequestContext request) {
        this.request = request;
    }

    public RestPullRequestDeclineRequest getPullRequestDeclineRequest(ObjectMapper objectMapper) {
        if (this.request.hasEntity()) {
            try {
                return (RestPullRequestDeclineRequest)objectMapper.readValue(this.request.getEntityStream(), RestPullRequestDeclineRequest.class);
            }
            catch (IOException e) {
                log.debug("Error reading the RestPullRequestDeclineRequest", (Throwable)e);
                throw new BadRequestException("There was an error reading the request body");
            }
        }
        return null;
    }

    public RestPullRequestMergeRequest getPullRequestMergeRequest(ObjectMapper objectMapper) {
        if (this.request.hasEntity()) {
            try {
                return (RestPullRequestMergeRequest)objectMapper.readValue(this.request.getEntityStream(), RestPullRequestMergeRequest.class);
            }
            catch (IOException e) {
                log.debug("Error reading the RestPullRequestMergeRequest", (Throwable)e);
                throw new BadRequestException("There was an error reading the request body");
            }
        }
        return null;
    }

    public RestPullRequestReopenRequest getPullRequestReopenRequest(ObjectMapper objectMapper) {
        if (this.request.hasEntity()) {
            try {
                return (RestPullRequestReopenRequest)objectMapper.readValue(this.request.getEntityStream(), RestPullRequestReopenRequest.class);
            }
            catch (IOException e) {
                log.debug("Error reading the RestPullRequestReopenRequest", (Throwable)e);
                throw new BadRequestException("There was an error reading the request body");
            }
        }
        return null;
    }
}

