/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatusRequest;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/approve")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestApproveResource
extends AbstractPullRequestResource {
    @Inject
    public PullRequestApproveResource(I18nService i18nService, DmzPullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @Operation(deprecated=true, description="Approve a pull request as the current user. Implicitly adds the user as a participant if they are not already. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource. \n\n<strong>Deprecated since 4.2</strong>. Use /rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} instead", summary="Approve pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Details of the new participant.", representation=RestPullRequestParticipant.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The pull request is not open.", responseCode=409, restError=true)})
    @Tag(name="Deprecated")
    @POST
    @Deprecated
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response approve(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId) {
        PullRequestParticipantStatusRequest request = new PullRequestParticipantStatusRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId).status(PullRequestParticipantStatus.APPROVED).build();
        return ResponseFactory.ok((Object)new RestPullRequestParticipant(this.pullRequestService.setReviewerStatus(request))).build();
    }

    @Operation(deprecated=true, description="Remove approval from a pull request as the current user. This does not remove the user as a participant. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource. \n\n<strong>Deprecated since 4.2</strong>. Use /rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} instead", summary="Unapprove pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Details of the updated participant.", representation=RestPullRequestParticipant.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist or the current user is not a participant on the pull request.", responseCode=404, restError=true), @ResponseDoc(documentation="The pull request is not open.", responseCode=409, restError=true)})
    @Tag(name="Deprecated")
    @DELETE
    @Deprecated
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response withdrawApproval(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId) {
        PullRequestParticipantStatusRequest request = new PullRequestParticipantStatusRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId).status(PullRequestParticipantStatus.UNAPPROVED).build();
        return ResponseFactory.ok((Object)new RestPullRequestParticipant(this.pullRequestService.setReviewerStatus(request))).build();
    }
}

