/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.dmz.comment.DmzCommentService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.rest.v2.comment.RestCommentCount;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.v2.api.resolver.CommentResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestCommentResource;
import com.atlassian.stash.internal.rest.util.MultilineCommentValidator;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/blocker-comments")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The pull request ID.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestBlockerCommentResource
extends AbstractPullRequestCommentResource {
    @Inject
    public PullRequestBlockerCommentResource(DmzCommentService commentService, I18nService i18nService, DmzPullRequestService pullRequestService, MultilineCommentValidator multilineCommentValidator) {
        super(commentService, i18nService, pullRequestService, multilineCommentValidator);
    }

    @Override
    @Operation(description="Add a new blocker comment. \n\nComments can be added in a few places by setting different attributes: \n\nGeneral pull request blocker comment: \n```\n\n{ \n     \"text\": \"A task on a pull request.\" \n}\n```\n\nBlocker reply to a comment: \n\n```\n\n{\n     \"text\": \"This reply is a task.\", \n     \"parent\": { \n         \"id\": 1 \n     } \n} \n```\n\nGeneral blocker file comment:\n\n```\n\n{\n     \"text\": \"A blocker comment on a file.\", \n     \"anchor\": { \n         \"diffType\": \"RANGE\", \n         \"fromHash\": \"6df3858eeb9a53a911cd17e66a9174d44ffb02cd\", \n         \"path\": \"path/to/file\", \n         \"srcPath\": \"path/to/file\", \n         \"toHash\": \"04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\" \n     } \n } \n```\n\nBlocker file line comment: \n\n```\n\n{ \n     \"text\": \"A task on a particular line within a file.\", \n     \"anchor\": { \n         \"diffType\": \"COMMIT\", \n         \"line\": 1, \n         \"lineType\": \"CONTEXT\", \n         \"fileType\": \"FROM\", \n         \"fromHash\": \"6df3858eeb9a53a911cd17e66a9174d44ffb02cd\", \n         \"path\": \"path/to/file\", \n         \"srcPath\": \"path/to/file\", \n         \"toHash\": \"04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\" \n     } \n } \n```\n\nFor file and line comments, 'path' refers to the path of the file to which the comment should be applied and 'srcPath' refers to the path the that file used to have (only required for copies and moves). Also, fromHash and toHash refer to the sinceId / untilId (respectively) used to produce the diff on which the comment was added. Finally diffType refers to the type of diff the comment was added on. For backwards compatibility purposes if no diffType is provided and no fromHash/toHash pair is provided the diffType will be resolved to 'EFFECTIVE'. In any other cases the diffType is REQUIRED. \n\nFor line comments, 'line' refers to the line in the diff that the comment should apply to. 'lineType' refers to the type of diff hunk, which can be: \n\n- 'ADDED' - for an added line;\n- 'REMOVED' - for a removed line; or\n- 'CONTEXT' - for a line that was unmodified but is in the vicinity of the diff.\n \n\n'fileType' refers to the file of the diff to which the anchor should be attached - which is of relevance when displaying the diff in a side-by-side way. Currently the supported values are: \n\n- 'FROM' - the source file of the diff\n - 'TO' - the destination file of the diff\n\n\nIf the current user is not a participant the user is added as a watcher of the pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Add new blocker comment")
    @RequestBody(description="The comment to add.", content={@Content(schema=@Schema(implementation=RestComment.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created comment.", representation=RestComment.class, responseCode=201), @ResponseDoc(documentation="The comment was not created due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request, create a comment or watch the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository, pull request or parent comment.", responseCode=404, restError=true), @ResponseDoc(documentation="The new created name already exists or adding, deleting, or editing comments isn't supported on archived repositories.", responseCode=409, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createComment(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver, @Context UriInfo uriInfo, RestComment comment) {
        comment.putIfAbsent((Object)"severity", (Object)CommentSeverity.BLOCKER.name());
        return super.createComment(repositoryResolver, pullRequestResolver, uriInfo, comment);
    }

    @Override
    @Operation(description="Delete a pull request comment. Anyone can delete their own comment. Only users with <strong>REPO_ADMIN</strong> and above may delete comments created by other users.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Delete pull request comment")
    @Parameters(value={@Parameter(name="commentId", description="The ID of the comment to retrieve.", in=ParameterIn.PATH), @Parameter(name="version", description="The expected version of the comment. This must match the server's version of the comment or the delete will fail. To determine the current version of the comment, the comment should be fetched from the server prior to the delete. Look for the 'version' attribute in the returned JSON structure.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The operation was successful.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the comment.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository or pull request.", responseCode=404, restError=true), @ResponseDoc(documentation="The comment has replies, the version supplied does not match the current version or the repository is archived.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteComment(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam CommentResolver commentResolver, @QueryParam(value="version") @DefaultValue(value="-1") int version) {
        return super.deleteComment(pullRequestResolver, commentResolver, version);
    }

    @Override
    @Operation(description="Retrieves a pull request comment.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get pull request comment")
    @Parameters(value={@Parameter(name="commentId", description="The ID of the comment to retrieve", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested comment.", representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the comment.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository, pull request or comment.", responseCode=404, restError=true)})
    @GET
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getComment(@BeanParam PullRequestResolver pullRequestResolver, @PathParam(value="commentId") long commentId) {
        return super.getComment(pullRequestResolver, commentId);
    }

    @Operation(description="Gets comments matching the given set of field values for the specified pull request. (Note this does <b>not</b> perform any kind of searching for comments by their text). \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Search pull request comments")
    @Parameters(value={@Parameter(name="count", description="If true only the count of the comments by state will be returned (and not the body of the comments).", in=ParameterIn.QUERY), @Parameter(name="states", description="(optional). If supplied, only comments with a state in the given list will be returned. The state can be OPEN or RESOLVED.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of Comments from the supplied pull request.", representation=RestComment.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository or pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getComments(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="count") @DefaultValue(value="false") boolean count, @QueryParam(value="state") List<String> states, @BeanParam PageRequestResolver pageRequestResolver) {
        CommentSearchRequest request = new CommentSearchRequest.Builder((Commentable)pullRequestResolver.getPullRequest()).anchorState(CommentThreadDiffAnchorState.ALL).severity(CommentSeverity.BLOCKER).states(this.toCommentStates(states, CommentState.values())).build();
        if (count) {
            Map commentCounts = this.commentService.countCommentsByState(request);
            return ResponseFactory.ok().entity(RestCommentCount.REST_TRANSFORM.apply(commentCounts)).build();
        }
        Page comments = this.commentService.search(request, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(comments, comment -> {
            RestCommentThreadDiffAnchor restAnchor = comment.getAnchor().isPresent() ? new RestCommentThreadDiffAnchor((CommentThreadDiffAnchor)comment.getAnchor().get()) : null;
            return new RestComment(comment, restAnchor, null, null, comment.getThread().isResolved());
        })).build();
    }

    @Override
    @Operation(description="Update a comment, with the following restrictions: \n\n- only the author of the comment may update the <i>text</i> of the comment\n- only the author of the comment, the author of the pull request or repository admins and above may update   the other fields of a comment\n\n\nConvert a comment to a task or vice versa. \n\nComments can be converted to tasks by setting the 'severity' attribute to 'BLOCKER': \n```\n\n{ \n\"severity\": \"BLOCKER\" \n}\n\n```\n\nTasks can be converted to comments by setting the 'severity' attribute to 'NORMAL': ```\n\n{ \n\"severity\": \"NORMAL\" \n}\n\n```\n\nResolve a blocker comment. \n\nBlocker comments can be resolved by setting the 'state' attribute to 'RESOLVED': ```\n\n{ \n\"state\": \"RESOLVED\" \n} \n```\n\n<strong>Note:</strong> the supplied JSON object must contain a <code>version</code> that must match the server's version of the comment or the update will fail. To determine the current version of the comment, the comment should be fetched from the server prior to the update. Look for the 'version' attribute in the returned JSON structure. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Update pull request comment")
    @Parameters(value={@Parameter(name="commentId", description="The ID of the comment to retrieve.", in=ParameterIn.PATH)})
    @RequestBody(description="The comment to add.", content={@Content(schema=@Schema(implementation=RestComment.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly updated comment.", representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The comment was not updated due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request, update a comment or watch the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository, pull request or comment.", responseCode=404, restError=true), @ResponseDoc(documentation="The comment version supplied does not match the current version or the repository is archived.", responseCode=409, restError=true)})
    @PUT
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateComment(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam CommentResolver commentResolver, RestComment restComment) {
        return super.updateComment(pullRequestResolver, commentResolver, restComment);
    }

    @Nonnull
    private List<CommentState> toCommentStates(List<String> commentStates, CommentState ... validStates) {
        return CollectionUtils.isEmpty(commentStates) ? ImmutableList.of() : commentStates.stream().map(validState -> this.toCommentState((String)validState, validStates)).collect(Collectors.toList());
    }
}

