/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestChangeScope;
import com.atlassian.bitbucket.pull.PullRequestChangesRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.content.RestChange;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonChangeCallback;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/changes")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The pull request ID.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestChangeResource
extends AbstractPullRequestResource {
    @Inject
    public PullRequestChangeResource(I18nService i18nService, DmzPullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @Operation(description="Gets changes for the specified PullRequest.\n\nIf the changeScope query parameter is set to 'UNREVIEWED', the application will attempt to stream unreviewed changes based on the lastReviewedCommit of the current user, which are the changes between the lastReviewedCommit and the latest commit of the source branch. The current user is considered to <i>not</i> have any unreviewed changes for the pull request when the lastReviewedCommit is either null (everything is unreviewed, so all changes are streamed), equal to the latest commit of the source branch (everything is reviewed), or no longer on the source branch (the source branch has been rebased). In these cases, the application will fall back to streaming all changes (the default), which is the effective diff for the pull request. The type of changes streamed can be determined by the changeScope parameter included in the properties map of the response. \n\nNote: This resource is currently <i>not paged</i>. The server will return at most one page. The server will truncate the number of changes to either the request's page limit or an internal maximum, whichever is smaller. The start parameter of the page request is also ignored. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Gets pull request changes")
    @Parameters(value={@Parameter(name="changeScope", description="UNREVIEWED to stream the unreviewed changes for the current user (if they exist); RANGE to stream changes between two arbitrary commits (requires 'sinceId' and 'untilId'); otherwise ALL to stream all changes (the default)", in=ParameterIn.QUERY), @Parameter(name="sinceId", description="The since commit hash to stream changes for a RANGE arbitrary change scope", in=ParameterIn.QUERY), @Parameter(name="untilId", description="The until commit hash to stream changes for a RANGE arbitrary change scope", in=ParameterIn.QUERY), @Parameter(name="withComments", description="true to apply comment counts in the changes (the default); otherwise, false to stream changes without comment counts", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of Changes from the supplied pull request.", paged=true, representation=RestChange.class, responseCode=200), @ResponseDoc(documentation="A page of unreviewed Changes for the current user from the supplied pull request, including the unreviewedCommits in the properties map.", representation=RestChange.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository or pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamChanges(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="changeScope") @DefaultValue(value="ALL") String changeScope, @QueryParam(value="sinceId") String sinceId, @QueryParam(value="untilId") String untilId, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, final @BeanParam PageRequestResolver pageRequestResolver) {
        final PullRequestChangesRequest request = new PullRequestChangesRequest.Builder(pullRequestResolver.getPullRequest()).changeScope(this.toChangeScope(changeScope)).sinceId(sinceId).untilId(untilId).withComments(withComments).build();
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                PullRequestChangeResource.this.pullRequestService.streamChanges(request, (ChangeCallback)new JsonChangeCallback(writer, pageRequestResolver.getPageRequest()));
            }
        }, (CacheControl)CachePolicies.noCache()).build();
    }

    private PullRequestChangeScope toChangeScope(String changeScope) {
        try {
            return StringUtils.isEmpty((CharSequence)changeScope) ? PullRequestChangeScope.ALL : PullRequestChangeScope.valueOf((String)changeScope.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.change.scope.invalid", new Object[]{this.toUppercaseNames((Enum[])PullRequestChangeScope.values())}));
        }
    }
}

