/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.dmz.comment.DmzCommentService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.rest.v2.suggestion.RestApplySuggestionRequest;
import com.atlassian.bitbucket.dmz.suggestion.ApplySuggestionRequest;
import com.atlassian.bitbucket.dmz.suggestion.DmzSuggestionService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.resolver.CommentResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestCommentResource;
import com.atlassian.stash.internal.rest.util.MultilineCommentValidator;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The pull request ID.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestCommentResource
extends AbstractPullRequestCommentResource {
    private static final int APPLY_RESCOPE_POLL_DELAY_MS = 500;
    private static final int APPLY_RESCOPE_MAX_WAIT_DEFAULT = 15000;
    private static final String APPLY_RESCOPE_MAX_WAIT_PROPERTY = "plugin.rest.pullrequest.suggestions.apply.rescopeMaxWait";
    private final int applyRescopeMaxWaitMs;
    private final DmzSuggestionService suggestionService;

    @Inject
    public PullRequestCommentResource(DmzCommentService commentService, I18nService i18nService, ApplicationPropertiesService propertiesService, DmzPullRequestService pullRequestService, DmzSuggestionService suggestionService, MultilineCommentValidator multilineCommentValidator) {
        super(commentService, i18nService, pullRequestService, multilineCommentValidator);
        this.suggestionService = suggestionService;
        this.applyRescopeMaxWaitMs = propertiesService.getPluginProperty(APPLY_RESCOPE_MAX_WAIT_PROPERTY, 15000);
    }

    @Operation(description="Apply a suggestion contained within a comment.", summary="Apply pull request suggestion")
    @Parameters(value={@Parameter(name="commentId", description="The ID of the comment to retrieve.", in=ParameterIn.PATH)})
    @RequestBody(description="A request containing other parameters required to apply a suggestion - The given versions/hashes must match the server's version/hashes or the suggestion application will fail (in order to avoid applying the suggestion to the wrong place", content={@Content(schema=@Schema(implementation=RestApplySuggestionRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating the suggestion has been applied.", responseCode=204), @ResponseDoc(documentation="The suggestion was not applied due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to apply the suggestion.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository, pull request or parent comment.", responseCode=404, restError=true), @ResponseDoc(documentation="There was an error applying the suggestion to the source branch. It must be applied manually.", responseCode=409, restError=true)})
    @POST
    @Path(value="{commentId}/apply-suggestion")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response applySuggestion(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver, @BeanParam CommentResolver commentResolver, RestApplySuggestionRequest request) {
        int commentVersion = this.requireInteger(request.getCommentVersion(), "commentVersion");
        String commitMessage = this.requireNotBlank(request.getCommitMessage(), "message");
        int pullRequestVersion = this.requireInteger(request.getPullRequestVersion(), "pullRequestVersion");
        int suggestionIndex = this.requireInteger(request.getSuggestionIndex(), "suggestionIndex");
        this.suggestionService.apply(new ApplySuggestionRequest.Builder(commentResolver.getComment().getId(), pullRequestResolver.getPullRequest()).commentVersion(commentVersion).commitMessage(commitMessage).pullRequestVersion(pullRequestVersion).suggestionIndex(suggestionIndex).build());
        this.waitForPullRequestVersionToUpdate(repositoryResolver.getRepository().getId(), pullRequestResolver.getPullRequest().getId(), pullRequestVersion);
        return ResponseFactory.noContent().build();
    }

    @Override
    @Operation(description="Add a new comment. \n\nComments can be added in a few places by setting different attributes: </p>General pull request comment: \n <pre> { \n   \"text\": \"An insightful general comment on a pull request.\" \n } \n </pre> Reply to a comment:  <pre> { \n   \"text\": \"A measured reply.\", \n   \"parent\": { \n      \"id\": 1 \n    } \n } \n </pre> General file comment:  <pre> { \n   \"text\": \"An insightful general comment on a file.\", \n   \"anchor\": { \n      \"diffType\": \"RANGE\", \n      \"fromHash\": \"6df3858eeb9a53a911cd17e66a9174d44ffb02cd\", \n      \"path\": \"path/to/file\", \n      \"srcPath\": \"path/to/file\", \n      \"toHash\": \"04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\" \n   } \n } \n </pre> File line comment:  <pre> { \n   \"text\": \"A pithy comment on a particular line within a file.\", \n   \"anchor\": { \n      \"diffType\": \"COMMIT\", \n      \"line\": 1, \n      \"lineType\": \"CONTEXT\", \n      \"fileType\": \"FROM\", \n      \"fromHash\": \"6df3858eeb9a53a911cd17e66a9174d44ffb02cd\", \n      \"path\": \"path/to/file\", \n      \"srcPath\": \"path/to/file\", \n      \"toHash\": \"04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\" \n    } \n } \n </pre> \n\n Add a new task. \n\nTasks are just comments with the attribute 'severity' set to 'BLOCKER': \n\nGeneral pull request task:  <pre> { \n   \"text\": \"A task on a pull request.\", \n   \"severity\": \"BLOCKER\" \n } \n </pre> \n\n Add a pending comment.  \n\nPending comments are just comments with the attribute 'state' set to 'PENDING': \n\nPending comment: <pre> { \n   \"text\": \"This is a pending comment\", \n   \"state\": \"PENDING\" \n } \n </pre> \n\nFor file and line comments, 'path' refers to the path of the file to which the comment should be applied and 'srcPath' refers to the path the that file used to have (only required for copies and moves).\n\nfromHash and toHash refer to the sinceId / untilId (respectively) used to produce the diff on which the comment was added.\n\nFor diffType 'COMMIT' or 'RANGE', you must specify both the fromHash and toHash. Note that this behaviour differs from `/commits/comments`\n\nFinally diffType refers to the type of diff the comment was added on. For backwards compatibility purposes if no diffType is provided and no fromHash/toHash pair is provided the diffType will be resolved to 'EFFECTIVE'. In any other cases the diffType is REQUIRED.\n\nFor line comments, 'line' refers to the line in the diff that the comment should apply to. 'lineType' refers to the type of diff hunk, which can be: \n\n- 'ADDED' - for an added line;\n- 'REMOVED' - for a removed line; or\n- 'CONTEXT' - for a line that was unmodified but is in the vicinity of the diff.\n</ul>'fileType' refers to the file of the diff to which the anchor should be attached - which is of relevance when displaying the diff in a side-by-side way. Currently the supported values are: \n\n- 'FROM' - the source file of the diff\n- 'TO' - the destination file of the diff\n</ul>If the current user is not a participant the user is added as a watcher of the pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Add pull request comment")
    @RequestBody(description="The comment to add", content={@Content(schema=@Schema(implementation=RestComment.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created comment.", representation=RestComment.class, responseCode=201), @ResponseDoc(documentation="The comment was not created due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request, create a comment or watch the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository, pull request or parent comment.", responseCode=404, restError=true), @ResponseDoc(documentation="Adding, deleting, or editing comments isn't supported on archived repositories.", responseCode=409, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createComment(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver, @Context UriInfo uriInfo, RestComment comment) {
        return super.createComment(repositoryResolver, pullRequestResolver, uriInfo, comment);
    }

    @Override
    @Operation(description="Delete a pull request comment. Anyone can delete their own comment. Only users with <strong>REPO_ADMIN</strong> and above may delete comments created by other users. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Delete a pull request comment")
    @Parameters(value={@Parameter(name="commentId", description="The ID of the comment to retrieve.", in=ParameterIn.PATH), @Parameter(name="version", description="The expected version of the comment. This must match the server's version of the comment or the delete will fail. To determine the current version of the comment, the comment should be fetched from the server prior to the delete. Look for the 'version' attribute in the returned JSON structure.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The operation was successful.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the comment.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository or pull request.", responseCode=404, restError=true), @ResponseDoc(documentation="The comment has replies, the version supplied does not match the current version or the repository is archived.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteComment(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam CommentResolver commentResolver, @QueryParam(value="version") @DefaultValue(value="-1") int version) {
        return super.deleteComment(pullRequestResolver, commentResolver, version);
    }

    @Override
    @Operation(description="Retrieves a pull request comment. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get a pull request comment")
    @Parameters(value={@Parameter(name="commentId", description="The ID of the comment to retrieve.", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested comment.", representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the comment.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository, pull request or comment.", responseCode=404, restError=true)})
    @GET
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getComment(@BeanParam PullRequestResolver pullRequestResolver, @PathParam(value="commentId") long commentId) {
        return super.getComment(pullRequestResolver, commentId);
    }

    @Operation(description="Gets comments for the specified pull request and path. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get pull request comments for path")
    @Parameters(value={@Parameter(name="anchorState", description="ACTIVE to stream the active comments; ORPHANED to stream the orphaned comments; ALL to stream both the active and the orphaned comments;", in=ParameterIn.QUERY), @Parameter(name="diffTypes", description="EFFECTIVE to stream the comments related to the effective diff of the pull request; RANGE to stream comments related to a commit range between two arbitrary commits (requires 'fromHash' and 'toHash'); COMMIT to stream comments related to a commit between two arbitrary commits (requires 'fromHash' and 'toHash')", in=ParameterIn.QUERY), @Parameter(name="fromHash", description="The from commit hash to stream comments for a RANGE or COMMIT arbitrary change scope", in=ParameterIn.QUERY), @Parameter(name="path", description="The path to stream comments for a given path", in=ParameterIn.QUERY, required=true), @Parameter(name="toHash", description="The to commit hash to stream comments for a RANGE or COMMIT arbitrary change scope", in=ParameterIn.QUERY), @Parameter(name="states", description="(optional). If supplied, only comments with a state in the given list will be returned. The state can be OPEN or RESOLVED.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of Comments from the supplied pull request.", paged=true, representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository or pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getComments(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="anchorState") @DefaultValue(value="ACTIVE") String anchorState, @QueryParam(value="diffType") List<String> diffTypes, @QueryParam(value="fromHash") String fromHash, @QueryParam(value="path") String path, @QueryParam(value="state") List<String> states, @QueryParam(value="toHash") String toHash, @BeanParam PageRequestResolver pageRequestResolver) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comments.findrequirespath", new Object[0]));
        }
        Page threads = this.commentService.searchThreads(new CommentSearchRequest.Builder((Commentable)pullRequestResolver.getPullRequest()).anchorState(this.toAnchorState(anchorState)).diffTypes(this.toDiffTypes(diffTypes)).fromHash(fromHash).path(path).states(this.toCommentStates(states, CommentState.values())).toHash(toHash).build(), pageRequestResolver.getPageRequest());
        Page page = PageUtils.createPage((Iterable)((Iterable)threads.stream().map(RestComment::new).collect(MoreCollectors.toImmutableList())), (boolean)threads.getIsLastPage(), (PageRequest)pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page)).build();
    }

    @Override
    @Operation(description="Update a comment, with the following restrictions: \n\n- only the author of the comment may update the <i>text</i> of the comment\n- only the author of the comment, the author of the pull request or repository admins and above may update the other fields of a comment\n</ul> \n\nConvert a comment to a task or vice versa. \n\nComments can be converted to tasks by setting the 'severity' attribute to 'BLOCKER': \n <pre> { \n \"severity\": \"BLOCKER\" \n } \n </pre>\n\nTasks can be converted to comments by setting the 'severity' attribute to 'NORMAL':  <pre> { \n \"severity\": \"NORMAL\" \n } \n </pre>\n\nResolve a task. \n\nTasks can be resolved by setting the 'state' attribute to 'RESOLVED':  <pre> { \n \"state\": \"RESOLVED\" \n } \n </pre>\n\n<strong>Note:</strong> the supplied JSON object must contain a <code>version</code> that must match the server's version of the comment or the update will fail. To determine the current version of the comment, the comment should be fetched from the server prior to the update. Look for the 'version' attribute in the returned JSON structure. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Update pull request comment")
    @Parameters(value={@Parameter(name="commentId", description="The ID of the comment to retrieve.", in=ParameterIn.PATH)})
    @RequestBody(description="The updated comment", content={@Content(schema=@Schema(implementation=RestComment.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly updated comment.", representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The comment was not updated due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request, update a comment or watch the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied project, repository, pull request or comment.", responseCode=404, restError=true), @ResponseDoc(documentation="The comment version supplied does not match the current version or the repository is archived.", responseCode=409, restError=true)})
    @PUT
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateComment(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam CommentResolver commentResolver, RestComment restComment) {
        return super.updateComment(pullRequestResolver, commentResolver, restComment);
    }

    private int requireInteger(OptionalInt value, String paramName) {
        return value.orElseThrow(() -> new BadRequestException(this.i18nService.getMessage("bitbucket.rest.suggestion.apply.invalidintegerparam", new Object[]{paramName})));
    }

    @Nonnull
    private String requireNotBlank(String value, String paramName) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.suggestion.apply.missingbodyparam", new Object[]{paramName}));
        }
        return value;
    }

    @Nonnull
    private CommentThreadDiffAnchorState toAnchorState(@Nonnull String anchorState) {
        try {
            return StringUtils.isEmpty((CharSequence)anchorState) ? CommentThreadDiffAnchorState.ACTIVE : CommentThreadDiffAnchorState.valueOf((String)anchorState.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidstate", new Object[]{anchorState, this.toUppercaseNames((Enum[])CommentThreadDiffAnchorState.values())}));
        }
    }

    @Nonnull
    private List<CommentState> toCommentStates(List<String> commentStates, CommentState ... validStates) {
        return CollectionUtils.isEmpty(commentStates) ? ImmutableList.of() : commentStates.stream().map(validState -> this.toCommentState((String)validState, validStates)).collect(Collectors.toList());
    }

    @Nonnull
    private List<CommentThreadDiffAnchorType> toDiffTypes(List<String> diffTypes) {
        return CollectionUtils.isEmpty(diffTypes) ? ImmutableList.of((Object)CommentThreadDiffAnchorType.EFFECTIVE) : diffTypes.stream().map(this::toDiffType).collect(Collectors.toList());
    }

    private void waitForPullRequestVersionToUpdate(int repositoryId, long pullRequestId, int originalPullRequestVersion) {
        PullRequest maybeUpdatedPullRequest;
        long startTimeMs = System.currentTimeMillis();
        while ((maybeUpdatedPullRequest = this.pullRequestService.getById(repositoryId, pullRequestId)) != null && maybeUpdatedPullRequest.getVersion() <= originalPullRequestVersion && startTimeMs + (long)this.applyRescopeMaxWaitMs >= System.currentTimeMillis()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

