/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestCommitsRequest;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.atlassian.stash.internal.rest.pull.JsonCommitCallback;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/commits")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestCommitResource
extends AbstractPullRequestResource {
    private final AvatarEnricher avatarEnricher;

    @Inject
    public PullRequestCommitResource(I18nService i18nService, DmzPullRequestService pullRequestService, AvatarEnricher avatarEnricher) {
        super(i18nService, pullRequestService);
        this.avatarEnricher = avatarEnricher;
    }

    @Operation(description="Retrieve commits for the specified pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get pull request commits")
    @Parameters(value={@Parameter(name="pullRequestId", description="ID of the pullrequest, part of the path", in=ParameterIn.PATH), @Parameter(name="avatarSize", description="If present the service adds avatar URLs for commit authors. Should be an integer specifying the desired size in pixels. If the parameter is not present, avatar URLs will not be setCOMMIT to stream comments related to a commit between two arbitrary commits (requires 'fromHash' and 'toHash')", in=ParameterIn.QUERY), @Parameter(name="avatarScheme", description="The desired scheme for the avatar URL. If the parameter is not present URLs will use the same scheme as this request", in=ParameterIn.QUERY), @Parameter(name="withCounts", description="If set to true, the service will add \"authorCount\" and \"totalCount\" at the end of the page. \"authorCount\" is the number of different authors and \"totalCount\" is the total number of commits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of commits from the supplied pull request.", paged=true, representation=RestCommit.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository or pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCommits(final @BeanParam RepositoryResolver repositoryResolver, final @PathParam(value="pullRequestId") long pullRequestId, final @QueryParam(value="withCounts") boolean withCounts, @QueryParam(value="avatarSize") String avatarSize, @QueryParam(value="avatarScheme") String avatarScheme, final @BeanParam PageRequestResolver pageRequestResolver, final @Context ContainerRequestContext request) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                JsonCommitCallback callback = new JsonCommitCallback(writer, RestCommit.createTransformer((ContainerRequestContext)request, (AvatarEnricher)PullRequestCommitResource.this.avatarEnricher, (I18nService)PullRequestCommitResource.this.i18nService), withCounts, pageRequestResolver.getPageRequest());
                PullRequestCommitResource.this.pullRequestService.streamCommits(new PullRequestCommitsRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId).build(), (CommitCallback)callback);
            }
        }).build();
    }
}

