/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestDiffRequest;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiff;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.resolver.DiffContentFilterResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The pull request ID.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestDiffResource
extends AbstractPullRequestResource {
    private final AvatarEnricher avatarEnricher;

    @Inject
    public PullRequestDiffResource(I18nService i18nService, DmzPullRequestService pullRequestService, AvatarEnricher avatarEnricher) {
        super(i18nService, pullRequestService);
        this.avatarEnricher = avatarEnricher;
    }

    @Operation(description="Streams a diff within a pull request. \n\nIf the specified file has been copied, moved or renamed, the <code>srcPath</code> must also be specified to produce the correct diff. \n\nTo stream a raw text representation of the diff, this endpoint can be called with the request header 'Accept: text/plain'. \n\nNote: This RESTful endpoint is currently <i>not paged</i>. The server will internally apply a hard cap to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Stream a diff within a pull request")
    @Parameters(value={@Parameter(name="path", description="The path to the file which should be diffed (optional)", in=ParameterIn.PATH), @Parameter(name="avatarSize", description="If present the service adds avatar URLs for comment authors where the provided value specifies the desired avatar size in pixels. Not applicable if streaming raw diff", in=ParameterIn.QUERY), @Parameter(name="avatarScheme", description="The security scheme for avatar URLs. If the scheme is not present then it is inherited from the request. It can be set to \"https\" to force the use of secure URLs. Not applicable if streaming raw diff", in=ParameterIn.QUERY), @Parameter(name="contextLines", description="The number of context lines to include around added/removed lines in the diff", in=ParameterIn.QUERY), @Parameter(name="diffType", description="The type of diff being requested. When withComments is true this works as a hint to the system to attach the correct set of comments to the diff. Not applicable if streaming raw diff", in=ParameterIn.QUERY), @Parameter(name="sinceId", description="The since commit hash to stream a diff between two arbitrary hashes", in=ParameterIn.QUERY), @Parameter(name="srcPath", description="The previous path to the file, if the file has been copied, moved or renamed", in=ParameterIn.QUERY), @Parameter(name="untilId", description="The until commit hash to stream a diff between two arbitrary hashes", in=ParameterIn.QUERY), @Parameter(name="whitespace", description="Optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY), @Parameter(name="withComments", description="<code>true</code> to embed comments in the diff (the default); otherwise, <code>false</code> to stream the diff without comments. Not applicable if streaming raw diff", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of differences from a pull request.", representation=RestDiff.class, responseCode=200), @ResponseDoc(documentation="If the request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository or pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamDiff(@BeanParam PullRequestResolver pullRequestResolver, @PathParam(value="path") String path, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="diffType") @DefaultValue(value="EFFECTIVE") String diffType, @QueryParam(value="sinceId") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="untilId") String untilId, @QueryParam(value="whitespace") String whitespace, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @QueryParam(value="avatarSize") String avatarSize, @QueryParam(value="avatarScheme") String avatarScheme, @BeanParam DiffContentFilterResolver filterResolver, @Context ContainerRequestContext request) {
        DiffContentFilter filter = filterResolver.getDiffContentFilter();
        final PullRequestDiffRequest diffRequest = new PullRequestDiffRequest.Builder(pullRequestResolver.getPullRequest(), path).contextLines(contextLines).diffType(this.toDiffType(diffType)).sinceId(sinceId).filter(filter).srcPath(srcPath).untilId(untilId).whitespace(DiffWhitespace.fromString((String)whitespace)).withComments(withComments).build();
        final Function<Comment, RestComment> commentTransformer = this.createAvatarCommentTransformer(request);
        CacheControl cache = withComments || StringUtils.isBlank((CharSequence)untilId) ? CachePolicies.noCache() : (StringUtils.isBlank((CharSequence)sinceId) ? CachePolicies.getCacheControlForObjectId((String)untilId) : CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId));
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                PullRequestDiffResource.this.pullRequestService.streamDiff(diffRequest, (DiffContentCallback)new JsonDiffContentCallback(writer, commentTransformer));
            }
        }, (CacheControl)cache).build();
    }

    @GET
    @Hidden
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamDiff(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="diffType") @DefaultValue(value="EFFECTIVE") String diffType, @QueryParam(value="sinceId") String sinceId, @QueryParam(value="srcPath") String sourcePath, @QueryParam(value="untilId") String untilId, @QueryParam(value="whitespace") String whitespace, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @BeanParam DiffContentFilterResolver filterResolver, @Context ContainerRequestContext request) {
        return this.streamDiff(pullRequestResolver, null, contextLines, diffType, sinceId, sourcePath, untilId, whitespace, withComments, null, null, filterResolver, request);
    }

    @GET
    @Hidden
    @Path(value="{path:.*}")
    @Produces(value={"text/plain; qs=0.1"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRawDiff(@BeanParam PullRequestResolver pullRequestResolver, @PathParam(value="path") String path, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="sinceId") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="untilId") String untilId, @QueryParam(value="whitespace") String whitespace) {
        return super.streamRawDiff(contextLines, path, pullRequestResolver.getPullRequest(), sinceId, srcPath, untilId, whitespace);
    }

    @GET
    @Hidden
    @Produces(value={"text/plain; qs=0.1"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRawDiff(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="sinceId") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="untilId") String untilId, @QueryParam(value="whitespace") String whitespace) {
        return super.streamRawDiff(contextLines, null, pullRequestResolver.getPullRequest(), sinceId, srcPath, untilId, whitespace);
    }

    private Function<Comment, RestComment> createAvatarCommentTransformer(ContainerRequestContext request) {
        final AvatarRequest avatarRequest = AvatarRequestHelper.makeAvatarRequest((ContainerRequestContext)request, (I18nService)this.i18nService);
        if (avatarRequest == null) {
            return RestComment.REST_TRANSFORM;
        }
        return new Function<Comment, RestComment>(){

            @Override
            public RestComment apply(Comment comment) {
                RestComment restComment = new RestComment(comment, (Function)this);
                PullRequestDiffResource.this.avatarEnricher.enrich((Object)restComment, avatarRequest);
                return restComment;
            }
        };
    }
}

