/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge-base")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The pull request ID.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestMergeBaseResource
extends AbstractPullRequestResource {
    @Inject
    public PullRequestMergeBaseResource(I18nService i18nService, DmzPullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @Operation(description="Returns the best common ancestor between the latest commits of the source and target branches of the pull request.\n\nIf more than one best common ancestor exists, only one will be returned. It is unspecified which will be returned.", summary="Get the common ancestor between the latest commits of the source and target branches of the pull request")
    @Parameters(value={@Parameter(description="The pull request id to calculate the merge-base on", in=ParameterIn.PATH, name="pullRequestId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The common ancestor of the latest commits in the source and target branches of this pull request", representation=RestCommit.class, responseCode=200), @ResponseDoc(documentation="No common parent between exist", responseCode=204), @ResponseDoc(documentation="The project, repository, or pull request does not exist", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMergeBase(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId) {
        return this.pullRequestService.getMergeBase(repositoryResolver.getRepository().getId(), pullRequestId).map(commit -> ResponseFactory.ok((Object)new RestCommit(commit))).orElse(ResponseFactory.noContent()).build();
    }
}

