/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestAssignParticipantRoleRequest;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestAssignStatusRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.InvalidPullRequestRoleException;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatusRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.UserResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.google.common.base.Joiner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Locale;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestParticipantResource
extends AbstractPullRequestResource {
    private final AuthenticationContext authenticationContext;

    @Inject
    public PullRequestParticipantResource(I18nService i18nService, DmzPullRequestService pullRequestService, AuthenticationContext authenticationContext) {
        super(i18nService, pullRequestService);
        this.authenticationContext = authenticationContext;
    }

    @Operation(description="Retrieves a page of the participants for a given pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get pull request participants")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Details of the participants in this pull request.", paged=true, representation=RestPullRequestParticipant.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response listParticipants(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.pullRequestService.getParticipants(repositoryResolver.getRepository().getId(), pullRequestId, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestPullRequestParticipant::new)).build();
    }

    @Operation(description="Assigns a participant to an explicit role in pull request. Currently only the REVIEWER role may be assigned. \n\nIf the user is not yet a participant in the pull request, they are made one and assigned the supplied role. \n\nIf the user is already a participant in the pull request, their previous role is replaced with the supplied role unless they are already assigned the AUTHOR role which cannot be changed and will result in a Bad Request (400) response code. \n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the repository that this pull request targets to call this resource.", summary="Assign pull request participant role")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @RequestBody(description="The participant to be added to the pull request, includes the user and their role", content={@Content(schema=@Schema(implementation=RestPullRequestAssignParticipantRoleRequest.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="Details of the participants in this pull request.", representation=RestPullRequestParticipant.class, responseCode=200), @ResponseDoc(documentation="The request does not have the username and role, or is attempting an invalid assignment.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Adding reviewers isn't supported on archived repositories", responseCode=409, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response assignParticipantRole(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, RestPullRequestAssignParticipantRoleRequest request) {
        RestApplicationUser user = this.ensureHasProperty("user", request.getUser());
        String userName = this.ensureHasProperty("user.name", user.getName());
        if (this.ensureHasProperty("role", request.getRole()) != PullRequestRole.REVIEWER) {
            throw new InvalidPullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.rest.pullrequests.role.assign.restriction", new Object[]{PullRequestRole.REVIEWER.name().toLowerCase(Locale.ROOT)}));
        }
        PullRequestParticipant created = this.pullRequestService.addReviewer(repositoryResolver.getRepository().getId(), pullRequestId, userName);
        return ResponseFactory.ok((Object)new RestPullRequestParticipant(created)).build();
    }

    @Operation(deprecated=true, description="Unassigns a participant from the REVIEWER role they may have been given in a pull request. \n\nIf the participant has no explicit role this method has no effect. \n\nAfterwards, the user will still remain a participant in the pull request but their role will be reduced to PARTICIPANT. This is because once made a participant of a pull request, a user will forever remain a participant. Only their role may be altered. \n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the repository that this pull request targets to call this resource. \n\n<strong>Deprecated since 4.2</strong>. Use /rest/api/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants/{userSlug} instead.", summary="Unassign pull request participant")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The update completed.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Removing reviewers isn't supported on archived repositories.", responseCode=409, restError=true)})
    @Tag(name="Deprecated")
    @DELETE
    @Deprecated
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response unassignParticipantRole(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="username") String username) {
        this.pullRequestService.removeReviewer(repositoryResolver.getRepository().getId(), pullRequestId, this.ensureHasProperty("username", username));
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Unassigns a participant from the REVIEWER role they may have been given in a pull request. \n\nIf the participant has no explicit role this method has no effect. \n\nAfterwards, the user will still remain a participant in the pull request but their role will be reduced to PARTICIPANT. This is because once made a participant of a pull request, a user will forever remain a participant. Only their role may be altered. \n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the repository that this pull request targets to call this resource.", summary="Unassign pull request participant")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="userSlug", description="The slug for the user being unassigned", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The update completed.", responseCode=204), @ResponseDoc(documentation="The request does not have the username.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Removing reviewers isn't supported on archived repositories.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="{userSlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response unassignParticipantRole(@BeanParam RepositoryResolver repositoryResolver, @BeanParam UserResolver userResolver, @PathParam(value="pullRequestId") long pullRequestId) {
        this.pullRequestService.removeReviewer(repositoryResolver.getRepository().getId(), pullRequestId, userResolver.getUser().getName());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Change the current user's status for a pull request. Implicitly adds the user as a participant if they are not already. If the current user is the author, this method will fail. \n\nThe possible values for {@code status} are <strong>UNAPPROVED</strong>, <strong>NEEDS_WORK</strong> (which is referred to as \"Requested changes\" in the frontend from 8.10 onward), or <strong>APPROVED</strong>. \n\nIf the new {@code status} is <strong>NEEDS_WORK</strong> or <strong>APPROVED</strong> then the {@code lastReviewedCommit} for the participant will be updated to the latest commit of the source branch of the pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Change pull request status")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="userSlug", description="The slug for the user changing their status", in=ParameterIn.PATH), @Parameter(name="version", description="The current version of the pull request. If the server's version isn't the same as the specified version the operation will fail. To determine the current version of the pull request it should be fetched from the server prior to this operation. Look for the 'version' attribute in the returned JSON structure. Note: This parameter is deprecated. Use last reviewed commit in request body instead", deprecated=true, in=ParameterIn.QUERY)})
    @RequestBody(description="The participant representing the status to set, includes the status of the participant and last reviewed commit. If last reviewed commit is provided, it will be used to update the participant status. The operation will fail if the latest commit of the pull request does not match the provided last reviewed commit. If last reviewed commit is not provided, the latest commit of the pull request will be used for the update by default.", content={@Content(schema=@Schema(implementation=RestPullRequestAssignStatusRequest.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="Details of the new participant.", representation=RestPullRequestParticipant.class, responseCode=200), @ResponseDoc(documentation="The specified status was invalid or the currently authenticated user is the author of the PR and cannot have its status updated.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The pull request is not open, or has been updated since the last reviewed commit specified by the request.", responseCode=409, restError=true)})
    @PUT
    @Path(value="{userSlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateStatus(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @PathParam(value="userSlug") String userSlug, RestPullRequestAssignStatusRequest request) {
        this.ensureIsValidUser(userSlug);
        PullRequestParticipantStatusRequest statusRequest = new PullRequestParticipantStatusRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId).lastReviewedCommit(request.getLastReviewedCommit()).status(this.getStatus(request)).build();
        return ResponseFactory.ok((Object)new RestPullRequestParticipant(this.pullRequestService.setReviewerStatus(statusRequest))).build();
    }

    private void ensureIsValidUser(String userSlug) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null || IdentifierUtils.equalsInLowerCase((String)currentUser.getSlug(), (String)userSlug)) {
            return;
        }
        throw new ForbiddenException(this.i18nService.getMessage("bitbucket.service.pullrequest.update.permissions.wronguser", new Object[0]));
    }

    private PullRequestParticipantStatus getStatus(RestPullRequestAssignStatusRequest request) {
        try {
            PullRequestParticipantStatus status = request.getStatus();
            if (status == null) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.service.pullrequest.update.permissions.statusrequired", new Object[0]));
            }
            return status;
        }
        catch (IllegalArgumentException ignored) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.service.pullrequest.update.permissions.invalidstatus", new Object[]{Joiner.on((char)',').join((Object[])PullRequestParticipantStatus.values())}));
        }
    }
}

