/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/participants")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestParticipantSearchResource
extends AbstractPullRequestResource {
    @Inject
    public PullRequestParticipantSearchResource(I18nService i18nService, DmzPullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @Operation(description="Retrieve a page of participant users for all the pull requests to or from the specified repository. \n\nOptionally clients can specify following filters.", summary="Search pull request participants")
    @Parameters(value={@Parameter(name="direction", description="(optional), Defaults to <strong>INCOMING</strong>) the direction relative to the specified repository. Either <strong>INCOMING</strong> or <strong>OUTGOING</strong>.", in=ParameterIn.QUERY), @Parameter(name="filter", description="(optional) Return only users, whose username, name or email address <i>contain</i> the filter value", in=ParameterIn.QUERY), @Parameter(name="role", description="(optional) The role associated with the pull request participant. This must be one of AUTHOR, REVIEWER, or PARTICIPANT", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users that match the search criteria.", paged=true, representation=RestApplicationUser.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response search(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="direction") @DefaultValue(value="incoming") String direction, @QueryParam(value="filter") String filter, @QueryParam(value="role") String role, @BeanParam PageRequestResolver pageRequestResolver) {
        PullRequestParticipantSearchRequest.Builder builder = new PullRequestParticipantSearchRequest.Builder();
        if (PullRequestDirection.OUTGOING.equals((Object)this.toDirection(direction))) {
            builder.fromRepository(repositoryResolver.getRepository());
        } else {
            builder.toRepository(repositoryResolver.getRepository());
        }
        builder.filter(filter);
        if (StringUtils.isNotBlank((CharSequence)role)) {
            builder.role(this.toRole(role));
        }
        Page page = this.pullRequestService.searchUsers(builder.build(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestApplicationUser::new)).build();
    }

    private PullRequestRole toRole(String role) {
        try {
            return PullRequestRole.valueOf((String)role.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.participants.role.invalid", new Object[]{role, this.toUppercaseNames((Enum[])PullRequestRole.values())}));
        }
    }
}

