/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.content.PatchRequest;
import com.atlassian.bitbucket.dmz.mergequeue.PullRequestMergeService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestCommitMessageTemplateRenderer;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestCommitMessageSuggestion;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestActivity;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestActivityPage;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestDeclineRequest;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestDeleteRequest;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeRequest;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeability;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestReopenRequest;
import com.atlassian.bitbucket.event.repository.PullRequestFilterEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivityPage;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.pull.PullRequestCreateRequest;
import com.atlassian.bitbucket.pull.PullRequestDeclineRequest;
import com.atlassian.bitbucket.pull.PullRequestDeleteRequest;
import com.atlassian.bitbucket.pull.PullRequestDiffStatsSummaryRequest;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestEntityType;
import com.atlassian.bitbucket.pull.PullRequestGetRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.PullRequestUpdateRequest;
import com.atlassian.bitbucket.pull.automerge.AutoMergeService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiffStatsSummary;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequestRef;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.NumberParser;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.atlassian.stash.internal.rest.pull.OptionalBodyBeanParam;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestResource
extends AbstractPullRequestResource {
    private static final String APPROVED = "approved.";
    private static final String DEFAULT_ENTITY_VERSION = "-1";
    private static final int MAX_PARTICIPANTS = 10;
    private static final String ROLE = "role.";
    private static final String USERNAME = "username.";
    private final AutoMergeService autoMergeService;
    private final ContentService contentService;
    private final EventPublisher eventPublisher;
    private final ObjectMapper objectMapper;
    private final PullRequestMergeService pullRequestMergeService;
    private final RepositoryService repositoryService;
    private final DmzPullRequestCommitMessageTemplateRenderer templateRenderer;

    @Inject
    public PullRequestResource(AutoMergeService autoMergeService, ContentService contentService, EventPublisher eventPublisher, I18nService i18nService, DmzPullRequestService pullRequestService, PullRequestMergeService pullRequestMergeService, DmzPullRequestCommitMessageTemplateRenderer templateRenderer, RepositoryService repositoryService) {
        super(i18nService, pullRequestService);
        this.autoMergeService = autoMergeService;
        this.contentService = contentService;
        this.eventPublisher = eventPublisher;
        this.pullRequestMergeService = pullRequestMergeService;
        this.repositoryService = repositoryService;
        this.templateRenderer = templateRenderer;
        this.objectMapper = new ObjectMapper();
    }

    @Operation(description="Decline a pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Decline pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The pullrequest ID provided by the path", in=ParameterIn.PATH), @Parameter(name="version", description="The current version of the pull request. If the server's version isn't the same as the specified version the operation will fail. To determine the current version of the pull request it should be fetched from the server prior to this operation. Look for the 'version' attribute in the returned JSON structure.", in=ParameterIn.QUERY)})
    @RequestBody(description="Optional body", content={@Content(schema=@Schema(implementation=RestPullRequestDeclineRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request was declined.", representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The pull request is not OPEN or has been updated since the version specified by the request.", responseCode=409, restError=true)})
    @POST
    @Path(value="{pullRequestId}/decline")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response decline(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="version") @DefaultValue(value="-1") int version, @BeanParam OptionalBodyBeanParam request) {
        String comment = null;
        RestPullRequestDeclineRequest declineRequest = request.getPullRequestDeclineRequest(this.objectMapper);
        if (declineRequest != null) {
            comment = declineRequest.getComment();
            if (declineRequest.hasVersion()) {
                version = declineRequest.getVersion();
            }
        }
        PullRequest declined = this.pullRequestService.decline(new PullRequestDeclineRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId, version).comment(comment).build());
        return ResponseFactory.ok((Object)new RestPullRequest(declined)).build();
    }

    @Operation(description="Deletes a pull request. \n\nTo call this resource, users must be authenticated and have permission to view the pull request. Additionally, they must: \n\n- be the pull request author, if the system is configured to allow authors to delete their own   pull requests (this is the default) OR \n- have repository administrator permission for the repository the pull request is targeting\n\n\nA body containing the version of the pull request must be provided with this request. \n\n`{ \"version\": 1 }`", summary="Delete pull request")
    @RequestBody(description="A body containing the version of the pull request", content={@Content(schema=@Schema(implementation=RestPullRequestDeleteRequest.class))})
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request was deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Deleting pull requests isn't supported on archived repositories.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="{pullRequestId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, RestPullRequestDeleteRequest request) {
        this.ensurePropertySupplied("version", request.hasVersion());
        this.pullRequestService.delete(new PullRequestDeleteRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId, request.getVersion()).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Create a new pull request from a source branch or tag to a target branch. The source and target may be in the same repository, or different ones. (Note that different repositories must belong to the same <code>Repository#getHierarchyId()</code> hierarchy.) \n\nThe <code>fromRef</code> may be a branch or a tag. The <code>toRef</code> is required to be a branch. Tags are not allowed as targets because tags are intended to be immutable and should not be changed after they are created. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the <code>fromRef</code> and <code>toRef</code> repositories to call this resource.", summary="Create pull request")
    @RequestBody(description="The pull request data", content={@Content(schema=@Schema(implementation=RestPullRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created pull request.", representation=RestPullRequest.class, responseCode=201), @ResponseDoc(documentation="The pull request entity supplied in the request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a pull request between the two specified repositories.", responseCode=401, restError=true), @ResponseDoc(documentation="One of the specified repositories or branches does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details): \n\n- There was a problem resolving one or more reviewers.\n- The specified branches were the same.\n- The <em>to</em> branch is already up-to-date with all the commits on the     <em>from</em> branch.\n- A pull request between the two branches already exists.\n- The <em>to</em> repository is archived.\n", responseCode=409, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response create(@BeanParam RepositoryResolver toRepositoryResolver, @Context UriInfo uriInfo, RestPullRequest pullRequest) {
        Repository from;
        RestRepository fromRefRepository;
        String title = this.ensureHasProperty("title", pullRequest.getTitle());
        RestPullRequestRef fromRef = this.ensureHasProperty("fromRef", pullRequest.getFromRef());
        String fromRefId = this.ensureHasProperty("fromRef.id", fromRef.getId());
        RestPullRequestRef toRef = this.ensureHasProperty("toRef", pullRequest.getToRef());
        String toBranchId = this.ensureHasProperty("toRef.id", toRef.getId());
        this.ensurePropertyNotSupplied("author", pullRequest.hasAuthor());
        this.ensurePropertyNotSupplied("participants", pullRequest.hasParticipants());
        Collection<RestPullRequestParticipant> reviewers = this.validateReviewers(pullRequest);
        Repository to = toRepositoryResolver.getRepository();
        RestRepository toRefRepository = toRef.getRepository();
        if (toRefRepository != null) {
            RestProject toProject = this.ensureHasProperty("toRef.repository.project", toRefRepository.getProject());
            String projectKey = this.ensureHasProperty("toRef.repository.project.key", toProject.getKey());
            String repositorySlug = this.ensureHasProperty("toRef.repository.slug", toRefRepository.getSlug());
            if (!projectKey.equalsIgnoreCase(to.getProject().getKey()) || !repositorySlug.equalsIgnoreCase(to.getSlug())) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.wrongurl", new Object[]{projectKey, repositorySlug, to.getProject().getKey(), to.getSlug()}));
            }
        }
        if ((fromRefRepository = fromRef.getRepository()) == null || fromRefRepository.isEmpty()) {
            from = to;
        } else {
            String repositorySlug;
            RestProject fromProject = this.ensureHasProperty("fromRef.repository.project", fromRefRepository.getProject());
            String projectKey = this.ensureHasProperty("fromRef.repository.project.key", fromProject.getKey());
            from = this.repositoryService.getBySlug(projectKey, repositorySlug = this.ensureHasProperty("fromRef.repository.slug", fromRefRepository.getSlug()));
            if (from == null) {
                throw new NotFoundException(this.i18nService.getMessage("bitbucket.rest.nosuchrepo", new Object[]{projectKey, repositorySlug}));
            }
        }
        PullRequestCreateRequest createRequest = ((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)((PullRequestCreateRequest.Builder)new PullRequestCreateRequest.Builder().title(title)).description(pullRequest.getDescription())).draft(pullRequest.isDraft())).reviewers(this.extractParticipantUsernames(reviewers))).fromRepository(from)).fromRefId(fromRefId)).toRepository(to)).toBranchId(toBranchId)).build();
        PullRequest created = this.pullRequestService.create(createRequest);
        return ResponseFactory.created((URI)uriInfo.getRequestUriBuilder().path(String.valueOf(created.getId())).build(new Object[0])).entity((Object)new RestPullRequest(created)).build();
    }

    @Operation(description="Retrieve a page of activity associated with a pull request. \n\nActivity items include comments, approvals, rescopes (i.e. adding and removing of commits), merges and more. \n\nDifferent types of activity items may be introduced in newer versions of Stash or by user installed plugins, so clients should be flexible enough to handle unexpected entity shapes in the returned page. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get pull request activity")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="fromId", description="(optional) the ID of the activity item to use as the first item in the returned page", in=ParameterIn.QUERY), @Parameter(name="fromType", description="(required if <strong>fromId</strong> is present) the type of the activity item specified by <strong>fromId</strong> (either <strong>COMMENT</strong> or <strong>ACTIVITY</strong>)", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of activity relating to the specified pull request.", paged=true, representation=RestPullRequestActivity.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{pullRequestId}/activities")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getActivities(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="fromId") Long fromId, @QueryParam(value="fromType") String fromType, @BeanParam PageRequestResolver pageRequestResolver) {
        if (fromId == null) {
            Page page = this.pullRequestService.getActivities(repositoryResolver.getRepository().getId(), pullRequestId, pageRequestResolver.getPageRequest());
            return ResponseFactory.ok((Object)new RestPage(page, RestPullRequestActivity.REST_TRANSFORM)).build();
        }
        PullRequestActivityPage page = this.pullRequestService.getActivitiesStartingAt(repositoryResolver.getRepository().getId(), pullRequestId, this.toEntityType(fromType), fromId.longValue(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPullRequestActivityPage(page, RestPullRequestActivity.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a suggested commit message for the given Pull Request.", summary="Get commit message suggestion")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request to generate the suggestion for", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The suggested commit message", representation=RestCommitMessageSuggestion.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{pullRequestId}/commit-message-suggestion")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCommitMessageSuggestion(@BeanParam PullRequestResolver pullRequestResolver) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        PullRequestMergeConfig mergeConfig = this.pullRequestService.getMergeConfig(new GetPullRequestMergeConfigRequest.Builder(pullRequest.getToRef().getRepository()).build());
        PullRequestCommitMessageTemplate pullRequestCommitMessageTemplate = mergeConfig.getCommitMessageTemplate().orElse(this.templateRenderer.getDefaultCommitMessageTemplate());
        return ResponseFactory.ok((Object)new RestCommitMessageSuggestion(this.templateRenderer.renderBody(pullRequestCommitMessageTemplate, pullRequest), this.templateRenderer.renderTitle(pullRequestCommitMessageTemplate, pullRequest))).build();
    }

    @Operation(description="Retrieve the diff stats summary for the given Pull Request. \n\nThe stats summary include the total number of modified files, added lines, and deleted lines. \n\nNote: The authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get diff stats summary for pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="path", description="Optional path to the file which should be diffed", in=ParameterIn.PATH), @Parameter(name="sinceId", description="The since commit hash to stream a diff between two arbitrary hashes", in=ParameterIn.QUERY), @Parameter(name="srcPath", description="The previous path to the file, if the file has been copied, moved or renamed", in=ParameterIn.QUERY), @Parameter(name="untilId", description="The until commit hash to stream a diff between two arbitrary hashes", in=ParameterIn.QUERY), @Parameter(name="whitespace", description="Optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The diff stats summary", representation=RestDiffStatsSummary.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{pullRequestId}/diff-stats-summary/{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDiffStatsSummary(@BeanParam PullRequestResolver pullRequestResolver, @PathParam(value="path") String path, @QueryParam(value="sinceId") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="untilId") String untilId, @QueryParam(value="whitespace") String whitespace) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        PullRequestDiffStatsSummaryRequest request = new PullRequestDiffStatsSummaryRequest.Builder(pullRequest).path(path).sinceId(sinceId).srcPath(srcPath).untilId(untilId).whitespace(DiffWhitespace.fromString((String)whitespace)).build();
        CacheControl cache = StringUtils.isBlank((CharSequence)untilId) ? CachePolicies.noCache() : (StringUtils.isBlank((CharSequence)sinceId) ? CachePolicies.getCacheControlForObjectId((String)untilId) : CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId));
        DiffStatsSummary diffStatsSummary = this.pullRequestService.getDiffStatsSummary(request);
        return ResponseFactory.ok((Object)new RestDiffStatsSummary(diffStatsSummary), (CacheControl)cache).build();
    }

    @GET
    @Hidden
    @Path(value="{pullRequestId}/diff-stats-summary")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDiffStatsSummary(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="sinceId") String sinceId, @QueryParam(value="untilId") String untilId, @QueryParam(value="whitespace") String whitespace) {
        return this.getDiffStatsSummary(pullRequestResolver, null, sinceId, null, untilId, whitespace);
    }

    @Operation(description="Retrieve a pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="withProperties", description="(optional) defaults to false, whether to return additional pull request properties", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The specified pull request.", representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{pullRequestId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") String pullRequestId, @QueryParam(value="withProperties") @DefaultValue(value="false") boolean withProperties) {
        try {
            long parsedPullRequestId = NumberParser.parseLong((I18nService)this.i18nService, (String)"pullRequestId", (String)pullRequestId);
            PullRequest pullRequest = this.pullRequestService.get(new PullRequestGetRequest.Builder(repositoryResolver.getRepository().getId(), parsedPullRequestId).withProperties(withProperties).build());
            if (pullRequest != null) {
                return ResponseFactory.ok((Object)new RestPullRequest(pullRequest)).build();
            }
        }
        catch (com.atlassian.bitbucket.rest.v2.api.BadRequestException badRequestException) {
            // empty catch block
        }
        throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchpullrequest", new Object[]{pullRequestId, repositoryResolver.getRepository().getProject().getKey(), repositoryResolver.getRepository().getSlug()}));
    }

    @Operation(description="Retrieve a page of pull requests to or from the specified repository. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.  Optionally clients can specify PR participant filters. Each filter has a mandatory username.N parameter, and the optional role.N and approved.N parameters. \n\n- username.N - the \"root\" of a single participant filter, where \"N\" is a natural number   starting from 1. This allows clients to specify multiple participant filters, by providing consecutive   filters as username.1, username.2 etc. Note that the filters numbering has to start   with 1 and be continuous for all filters to be processed. The total allowed number of participant   filters is 10 and all filters exceeding that limit will be dropped.\n- role.N(optional) the role associated with username.N.   This must be one of AUTHOR, REVIEWER, or PARTICIPANT\n- approved.N (optional) the approved status associated with username.N.   That is whether username.N has approved the PR. Either true, or false\n", summary="Get pull requests for repository")
    @Parameters(value={@Parameter(name="direction", description="(optional, defaults to <strong>INCOMING</strong>) the direction relative to the specified repository. Either <strong>INCOMING</strong> or <strong>OUTGOING</strong>.", in=ParameterIn.QUERY), @Parameter(name="draft", description="(optional) If specified, only pull requests matching the supplied draft status will be returned.", in=ParameterIn.QUERY), @Parameter(name="at", description="(optional) a <i>fully-qualified</i> branch ID to find pull requests to or from, such as refs/heads/master", in=ParameterIn.QUERY), @Parameter(name="state", description="(optional, defaults to <strong>OPEN</strong>). Supply <strong>ALL</strong> to return pull request in any state. If a state is supplied only pull requests in the specified state will be returned. Either <strong>OPEN</strong>, <strong>DECLINED</strong> or <strong>MERGED</strong>.", in=ParameterIn.QUERY), @Parameter(name="order", description="(optional, defaults to <strong>NEWEST</strong>) the order to return pull requests in, either <strong>OLDEST</strong> (as in: \"oldest first\") or <strong>NEWEST</strong>.", in=ParameterIn.QUERY), @Parameter(name="withAttributes", description="(optional) defaults to true, whether to return additional pull request attributes", in=ParameterIn.QUERY), @Parameter(name="withProperties", description="(optional) defaults to true, whether to return additional pull request properties", in=ParameterIn.QUERY), @Parameter(name="filterText", description="(optional) If specified, only pull requests where the title or description contains the supplied string will be returned.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of pull requests that match the search criteria.", paged=true, representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @EscalateAnonymous2LO(value={Permission.LICENSED_USER, Permission.PROJECT_VIEW, Permission.REPO_READ})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPage(@Context UriInfo uriInfo, @BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="direction") @DefaultValue(value="incoming") String direction, @QueryParam(value="draft") Boolean draft, @QueryParam(value="at") String at, @QueryParam(value="state") String state, @QueryParam(value="order") String order, @QueryParam(value="withAttributes") @DefaultValue(value="true") Boolean withAttributes, @QueryParam(value="withProperties") @DefaultValue(value="true") Boolean withProperties, @QueryParam(value="filterText") String filterText, @BeanParam PageRequestResolver pageRequestResolver) {
        PullRequestDirection prDirection = this.toDirection(direction);
        Iterable<PullRequestParticipantRequest> prParticipants = this.toParticipantSearchRequests((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        PullRequestState prState = this.toPullRequestState(state);
        PullRequestOrder resultOrder = PullRequestOrder.fromString((String)order, (PullRequestOrder)PullRequestOrder.getDefaultOrder());
        Page pullRequestPage = this.pullRequestService.search(new PullRequestSearchRequest.Builder().draft(draft).filterText(filterText).repositoryAndBranch(prDirection, Integer.valueOf(repositoryResolver.getRepository().getId()), at).state(prState).order(resultOrder).participants(prParticipants).withProperties(withProperties.booleanValue()).build(), pageRequestResolver.getPageRequest());
        this.eventPublisher.publish((Object)new PullRequestFilterEvent((Object)this, repositoryResolver.getRepository(), prState, prParticipants, at, filterText));
        return ResponseFactory.ok((Object)new RestPage(pullRequestPage, RestPullRequest::new)).build();
    }

    @Operation(description="Test whether a pull request can be merged. \n\nA pull request may not be merged if: \n\n- there are conflicts that need to be manually resolved before merging; and/or\n- one or more merge checks have vetoed the merge.\n\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Test if pull request can be merged")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The mergeability status of the pull request.", representation=RestPullRequestMergeability.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The specified pull request is not open.", responseCode=409, restError=true)})
    @GET
    @Path(value="{pullRequestId}/merge")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response canMerge(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId) {
        PullRequestMergeability mergeability = this.pullRequestService.canMerge(repositoryResolver.getRepository().getId(), pullRequestId);
        return ResponseFactory.ok((Object)new RestPullRequestMergeability(mergeability)).build();
    }

    @Operation(description="Merge the specified pull request immediately or set the pull request to auto-merge when all the merge checks pass by setting <strong>autoMerge</strong> field in the request body.\n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the repository that this pull request targets to call this resource.", summary="Merge pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="version", description="The current version of the pull request. If the server's version isn't the same as the specified version the operation will fail. To determine the current version of the pull request it should be fetched from the server prior to this operation. Look for the 'version' attribute in the returned JSON structure.", in=ParameterIn.QUERY)})
    @RequestBody(description="The body holder", content={@Content(schema=@Schema(implementation=RestPullRequestMergeRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The merged pull request.", representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to merge the specified pull request", responseCode=401, restError=true), @ResponseDoc(documentation="The auto-merge setting is not enabled for the repository that this pull request targets.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details): \n\n- The pull request has conflicts.\n- A merge check vetoed the merge.\n- The specified version is out of date.\n- The specified pull request is not open.\n- The <em>to</em> repository is archived.\n", responseCode=409, restError=true)})
    @POST
    @Path(value="{pullRequestId}/merge")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response merge(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="version") @DefaultValue(value="-1") int version, @BeanParam OptionalBodyBeanParam optionalBodyProvider) {
        RestPullRequestMergeRequest mergeRequest = optionalBodyProvider.getPullRequestMergeRequest(this.objectMapper);
        if (mergeRequest != null && mergeRequest.hasVersion()) {
            version = mergeRequest.getVersion();
        }
        PullRequestMergeRequest.Builder builder = new PullRequestMergeRequest.Builder(repositoryResolver.getRepository().getId(), pullRequestId, version);
        if (mergeRequest != null) {
            builder.autoSubject(mergeRequest.isAutoSubject()).message(mergeRequest.getMessage()).strategyId(mergeRequest.getStrategyId());
            if (mergeRequest.isAutoMerge()) {
                return ResponseFactory.ok((Object)new RestPullRequest(this.autoMergeService.submitAutoMergeRequest(builder.build()))).build();
            }
        }
        return ResponseFactory.ok((Object)new RestPullRequest(this.pullRequestMergeService.merge(builder.build(), false))).build();
    }

    @Operation(description="Re-open a declined pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Re-open pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="version", description="The current version of the pull request. If the server's version isn't the same as the specified version the operation will fail. To determine the current version of the pull request it should be fetched from the server prior to this operation. Look for the 'version' attribute in the returned JSON structure.", in=ParameterIn.QUERY)})
    @RequestBody(description="The body holder", content={@Content(schema=@Schema(implementation=RestPullRequestReopenRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The merged pull request.", representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to reopen the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details): \n\n- The pull request is not in a declined state.\n- The specified version is out of date.\n- The <em>to</em> repository is archived.\n", responseCode=409, restError=true)})
    @POST
    @Path(value="{pullRequestId}/reopen")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response reopen(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="version") @DefaultValue(value="-1") int version, @BeanParam OptionalBodyBeanParam optionalBodyProvider) throws NoContentException {
        RestPullRequestReopenRequest reopenRequest = optionalBodyProvider.getPullRequestReopenRequest(this.objectMapper);
        if (reopenRequest != null && reopenRequest.hasVersion()) {
            version = reopenRequest.getVersion();
        }
        PullRequest pullRequest = this.pullRequestService.reopen(repositoryResolver.getRepository().getId(), pullRequestId, version);
        return ResponseFactory.ok((Object)new RestPullRequest(pullRequest)).build();
    }

    @Operation(description="Streams a patch representing a pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Stream pull request as patch")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="A patch representing the specified pull request.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to access the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{pullRequestId}.patch")
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamPatch(@BeanParam PullRequestResolver pullRequestResolver) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        String sinceId = pullRequest.getToRef().getLatestCommit();
        String untilId = pullRequest.getFromRef().getLatestCommit();
        PatchRequest request = new PatchRequest.Builder(pullRequest.getToRef().getRepository(), untilId).secondaryRepository(pullRequest.getFromRef().getRepository()).sinceId(sinceId).build();
        return ResponseFactory.ok((headers, output) -> this.contentService.streamPatch(request, contentType -> {
            headers.putSingle((Object)"Content-Type", (Object)contentType);
            return output;
        }), (CacheControl)CachePolicies.noCache()).build();
    }

    @Operation(description="Streams the raw diff for a pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Stream raw pull request diff")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH), @Parameter(name="contextLines", description="The number of context lines to include around added/removed lines in the diff", in=ParameterIn.QUERY), @Parameter(name="whitespace", description="optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY)})
    @ApiResponses(value={@ApiResponse(description="A raw diff for the specified pull request.", responseCode="200", content={@Content(mediaType="text/plain")}), @ApiResponse(description="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode="400", content={@Content(mediaType="text/html")}), @ApiResponse(description="The pull request does not exist.", responseCode="404", content={@Content(mediaType="text/html")})})
    @GET
    @Path(value="{pullRequestId}.diff")
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRawDiff(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="whitespace") String whitespace) {
        return super.streamRawDiff(contextLines, null, pullRequestResolver.getPullRequest(), null, null, null, whitespace);
    }

    @Operation(description="Update the title, description, reviewers, destination branch or draft status of an existing pull request. \n\n**Note:** the <em>reviewers</em> list may be updated using this resource. However the <em>author</em> and <em>participants</em> list may not. \n\nThe authenticated user must either: \n\n- be the author of the pull request and have the <strong>REPO_READ</strong> permission for the repository that this pull request targets; or\n- have the <strong>REPO_WRITE</strong> permission for the repository that this pull request targets\n\n\nto call this resource.", summary="Update pull request metadata")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @RequestBody(description="The updated pull request", content={@Content(schema=@Schema(implementation=RestPullRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The updated pull request.", representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details): \n\n- The request tried to modify the <em>author</em> or <em>participants</em>.\n- The pull request's version attribute was not specified.\n- A reviewer's username was not specified.\n- The toRef ID value was incorrectly left blank\n", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="One of the specified repositories or branches does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details): \n\n- The specified version is out of date.\n- One of the reviewers could not be added to the pull request.\n- If updating the destination branch:    - There is already an open pull request with an identical to branch\n   - The from and new to branch <i>are</i> the same\n   - The new destination branch up-to-date is up-to-date with all of                 changes from the from branch, resulting in a pull request with                 nothing to merge            \n- The <em>to</em> repository is archived.\n", responseCode=409, restError=true)})
    @PUT
    @Path(value="{pullRequestId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response update(@BeanParam PullRequestResolver pullRequestResolver, RestPullRequest restPullRequest) {
        this.ensurePropertySupplied("version", restPullRequest.hasVersion());
        this.ensurePropertyNotSupplied("author", restPullRequest.hasAuthor());
        this.ensurePropertyNotSupplied("participants", restPullRequest.hasParticipants());
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        Collection<RestPullRequestParticipant> reviewers = this.validateReviewers(restPullRequest);
        if (restPullRequest.getToRef() != null && StringUtils.isBlank((CharSequence)restPullRequest.getToRef().getId())) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.update.toref.blank", new Object[0]));
        }
        if (restPullRequest.hasTitle() || restPullRequest.hasDescription() || restPullRequest.hasReviewers() || restPullRequest.hasDraft() || restPullRequest.getToRef() != null) {
            String newDescription = restPullRequest.hasDescription() ? StringUtils.trimToNull((String)restPullRequest.getDescription()) : pullRequest.getDescription();
            PullRequestUpdateRequest.Builder builder = new PullRequestUpdateRequest.Builder(pullRequest, restPullRequest.getVersion()).title((String)StringUtils.defaultIfBlank((CharSequence)restPullRequest.getTitle(), (CharSequence)pullRequest.getTitle())).description(newDescription).draft(Boolean.valueOf(restPullRequest.hasDraft() ? restPullRequest.isDraft() : pullRequest.isDraft())).reviewers(this.extractParticipantUsernames(reviewers)).toBranchId(restPullRequest.getToRef() != null ? restPullRequest.getToRef().getId() : null);
            return ResponseFactory.ok().entity((Object)new RestPullRequest(this.pullRequestService.update(builder.build()))).build();
        }
        throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.invalidupdateproperties", new Object[0]));
    }

    private Set<String> extractParticipantUsernames(Collection<RestPullRequestParticipant> participants) {
        return participants.stream().map(participant -> participant.getUser().getName()).collect(Collectors.toSet());
    }

    private PullRequestEntityType toEntityType(String entityType) {
        try {
            return StringUtils.isEmpty((CharSequence)entityType) ? PullRequestEntityType.ACTIVITY : PullRequestEntityType.valueOf((String)entityType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.activity.entity.invalid", new Object[]{this.toUppercaseNames((Enum[])PullRequestEntityType.values())}));
        }
    }

    private PullRequestState toPullRequestState(String state) {
        try {
            if (StringUtils.isEmpty((CharSequence)state)) {
                return PullRequestState.OPEN;
            }
            if (state.equalsIgnoreCase("all")) {
                return null;
            }
            return PullRequestState.valueOf((String)state.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.state.invalid", new Object[]{this.toUppercaseNames((Enum[])PullRequestState.values())}));
        }
    }

    private Iterable<PullRequestParticipantRequest> toParticipantSearchRequests(@Nonnull MultivaluedMap<String, String> parameters) {
        ImmutableList.Builder participants = ImmutableList.builder();
        for (int i = 1; i <= 10 && parameters.containsKey((Object)(USERNAME + i)); ++i) {
            PullRequestRole role;
            try {
                role = parameters.containsKey((Object)(ROLE + i)) ? PullRequestRole.valueOf((String)((String)parameters.getFirst((Object)(ROLE + i)))) : null;
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.invalidrole", new Object[]{parameters.getFirst((Object)(ROLE + i)), parameters.getFirst((Object)(USERNAME + i))}));
            }
            PullRequestParticipantStatus status = null;
            if (parameters.containsKey((Object)(APPROVED + i))) {
                status = Boolean.parseBoolean((String)parameters.getFirst((Object)(APPROVED + i))) ? PullRequestParticipantStatus.APPROVED : PullRequestParticipantStatus.UNAPPROVED;
            }
            participants.add((Object)new PullRequestParticipantRequest.Builder((String)parameters.getFirst((Object)(USERNAME + i))).status(status).role(role).build());
        }
        return participants.build();
    }

    private Collection<RestPullRequestParticipant> validateReviewers(RestPullRequest restPullRequest) {
        Set reviewers = restPullRequest.getReviewers();
        if (!reviewers.isEmpty()) {
            int i = 0;
            for (RestPullRequestParticipant participant : reviewers) {
                this.ensureHasProperty("reviewers[" + i + "].user", participant.getUser());
                this.ensureHasProperty("reviewers[" + i + "].user.name", participant.getUser().getName());
                ++i;
            }
        }
        return reviewers;
    }
}

