/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestFinishReviewRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestDiscardReviewRequest;
import com.atlassian.bitbucket.pull.PullRequestFinishReviewRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/review")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The pull request ID.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestReviewResource {
    private final I18nService i18nService;
    private final PullRequestService pullRequestService;

    @Inject
    public PullRequestReviewResource(I18nService i18nService, PullRequestService pullRequestService) {
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
    }

    @Operation(description="Discard a pull request review for the authenticated user. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository to call this resource.", summary="Discard pull request review")
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request review has been discarded.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to discard the the pull request review", responseCode=401, restError=true), @ResponseDoc(documentation="The specified pull request or repository does not exist.", responseCode=404, restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response discardReview(@BeanParam PullRequestResolver pullRequestResolver) {
        this.pullRequestService.discardReview(new PullRequestDiscardReviewRequest.Builder(pullRequestResolver.getPullRequest()).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Get the <code>CommentThread</code> threads which have <code>Comment</code> comments that have a <code>CommentState#PENDING</code> pending state and are part of the pull request review for the authenticated user.", summary="Get pull request comment thread")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of Comments from the supplied pull request.", paged=true, representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository or pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getReview(@BeanParam PullRequestResolver pullRequestResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page threads = this.pullRequestService.getReviewThreads(pullRequestResolver.getPullRequest().getToRef().getRepository().getId(), pullRequestResolver.getPullRequest().getId(), pageRequestResolver.getPageRequest());
        Page page = PageUtils.createPage((Iterable)((Iterable)threads.stream().map(RestComment::new).collect(MoreCollectors.toImmutableList())), (boolean)threads.getIsLastPage(), (PageRequest)pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page)).build();
    }

    @Operation(description="Complete a review on a pull request.", summary="Complete pull request review")
    @Parameters(value={@Parameter(name="version", description="The current version of the pull request. If the server's version isn't the same as the specified version the operation will fail. To determine the current version of the pull request it should be fetched from the server prior to this operation. Look for the 'version' attribute in the returned JSON structure. Note: This parameter is deprecated. Use last reviewed commit in request body instead", deprecated=true, in=ParameterIn.QUERY)})
    @RequestBody(description="The REST request which contains comment text, last reviewed commit and participant status. If last reviewed commit is provided, it will be used to update the participant status. The operation will fail if the latest commit of the pull request does not match the provided last reviewed commit. If last reviewed commit is not provided, the latest commit of the pull request will be used for the update by default.", content={@Content(schema=@Schema(implementation=RestPullRequestFinishReviewRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Getting back the number of published comments and completing the review on a pull request.", responseCode=200), @ResponseDoc(documentation="The request is invalid when there is no request body provided, or the participant status in the request is invalid.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request, update a comment or watch the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="There is no pull request review for the user to finish.", responseCode=404, restError=true), @ResponseDoc(documentation="The pull request has been updated since the last reviewed commit specified by the request, or reviews cannot be made on pull requests in archived repositories.", responseCode=409, restError=true)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response finishReview(@BeanParam PullRequestResolver pullRequestResolver, @Nonnull RestPullRequestFinishReviewRequest restRequest) {
        Objects.requireNonNull(restRequest, "restRequest");
        PullRequestFinishReviewRequest reviewRequest = new PullRequestFinishReviewRequest.Builder(pullRequestResolver.getPullRequest()).lastReviewedCommit(restRequest.getLastReviewedCommit()).commentText(restRequest.getCommentText()).participantStatus(this.toParticipantStatus(restRequest.getParticipantStatus())).build();
        int result = this.pullRequestService.finishReview(reviewRequest);
        return ResponseFactory.ok(Collections.singletonMap("publishedCommentCount", result)).build();
    }

    private PullRequestParticipantStatus toParticipantStatus(String participantStatus) {
        try {
            return StringUtils.isEmpty((CharSequence)participantStatus) ? null : PullRequestParticipantStatus.valueOf((String)participantStatus.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.participant.status.invalid", new Object[]{Arrays.stream(PullRequestParticipantStatus.values()).collect(MoreCollectors.toImmutableList())}));
        }
    }
}

