/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.watcher.UnwatchRequest;
import com.atlassian.bitbucket.watcher.WatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="pullRequestId", documentation="The pull request ID.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestWatchResource {
    private final WatcherService watcherService;

    @Inject
    public PullRequestWatchResource(WatcherService watcherService) {
        this.watcherService = watcherService;
    }

    @Operation(description="Add the authenticated user as a watcher for the specified pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Watch pull request")
    @ResponseDocs(value={@ResponseDoc(documentation="The user is now watching the pull request.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response watch(@BeanParam PullRequestResolver pullRequestResolver) {
        this.watcherService.watch(new WatchRequest.Builder((Watchable)pullRequestResolver.getPullRequest()).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Remove the authenticated user as a watcher for the specified pull request. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Stop watching pull request")
    @ResponseDocs(value={@ResponseDoc(documentation="The user is no longer watching the pull request.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response unwatch(@BeanParam PullRequestResolver pullRequestResolver) {
        this.watcherService.unwatch(new UnwatchRequest.Builder((Watchable)pullRequestResolver.getPullRequest()).build());
        return ResponseFactory.noContent().build();
    }
}

