/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull.automerge;

import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeRestrictedSettings;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeSettingsRequest;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettings;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

public abstract class AbstractAutoMergeSettingsResource {
    protected final AutoMergeSettingsService autoMergeSettingsService;
    protected final I18nService i18nService;
    protected final DmzProjectSettingsRestrictionService projectSettingsRestrictionService;

    protected AbstractAutoMergeSettingsResource(AutoMergeSettingsService autoMergeSettingsService, I18nService i18nService, DmzProjectSettingsRestrictionService projectSettingsRestrictionService) {
        this.autoMergeSettingsService = autoMergeSettingsService;
        this.i18nService = i18nService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
    }

    protected Response deleteSettings(Scope scope) {
        this.autoMergeSettingsService.delete(scope);
        return ResponseFactory.noContent().build();
    }

    protected Optional<RestErrorMessage> getEnabledError(RestAutoMergeSettingsRequest request) {
        if (request.isEnabled() == null) {
            return Optional.of(new RestErrorMessage("enabled", this.i18nService.getMessage("bitbucket.rest.pull.automerge.error.settings.enabled.invalid", new Object[0])));
        }
        return Optional.empty();
    }

    protected ProjectSettingsRestrictionState getRestrictionState(Scope scope) {
        return (ProjectSettingsRestrictionState)scope.accept((ScopeVisitor)new ScopeVisitor<ProjectSettingsRestrictionState>(){

            public ProjectSettingsRestrictionState visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException("Global scope has no restriction state.");
            }

            public ProjectSettingsRestrictionState visit(@Nonnull ProjectScope projectScope) {
                return AbstractAutoMergeSettingsResource.this.projectSettingsRestrictionService.get(projectScope.getProject(), ProjectSettingsRestrictionKeys.AUTO_MERGE).map(ProjectSettingsRestriction::getProcessedState).map(ProjectSettingsRestrictionState::fromProcessedState).orElse(ProjectSettingsRestrictionState.NONE);
            }

            public ProjectSettingsRestrictionState visit(@Nonnull RepositoryScope repositoryScope) {
                return AbstractAutoMergeSettingsResource.this.projectSettingsRestrictionService.get(repositoryScope.getProject(), ProjectSettingsRestrictionKeys.AUTO_MERGE).map(ProjectSettingsRestriction::getProcessedState).map(ProjectSettingsRestrictionState::fromProcessedState).orElse(ProjectSettingsRestrictionState.NONE);
            }
        });
    }

    protected Response getSettings(Scope scope) {
        AutoMergeSettings settings = this.autoMergeSettingsService.getOrDefault(scope);
        return ResponseFactory.ok((Object)new RestAutoMergeRestrictedSettings(this.getRestrictionState(scope), settings)).build();
    }
}

