/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull.automerge;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeProjectSettingsRequest;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeRestrictedSettings;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeSettingsRequest;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettings;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsCreateRequest;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.automerge.AbstractAutoMergeSettingsResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/settings/auto-merge")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Project")
public class AutoMergeSettingsProjectResource
extends AbstractAutoMergeSettingsResource {
    @Inject
    public AutoMergeSettingsProjectResource(AutoMergeSettingsService autoMergeSettingsService, I18nService i18nService, DmzProjectSettingsRestrictionService projectSettingsRestrictionService) {
        super(autoMergeSettingsService, i18nService, projectSettingsRestrictionService);
    }

    @Operation(description="Deletes pull request auto-merge settings for the supplied project.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for this project to call the resource.", summary="Delete pull request auto-merge settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request auto-merge settings", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the pull request auto-merge settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam ScopeResolver scopeResolver) {
        return this.deleteSettings(scopeResolver.getScope());
    }

    @Operation(description="Retrieves the pull request auto-merge settings for the supplied project. Default settings will be returned if no explicit settings have been set for the project\n\nThe authenticated user must have <strong>PROJECT_VIEW</strong> permission for this project to call the resource.", summary="Get pull request auto-merge settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request auto-merge settings", representation=RestAutoMergeRestrictedSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the pull request auto-merge settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam ScopeResolver scopeResolver) {
        return this.getSettings(scopeResolver.getScope());
    }

    @Operation(description="Creates or updates the pull request auto-merge settings for the supplied project, and applies the restriction action specified in the request.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for this project to call the resource.", summary="Create or update the pull request auto-merge settings")
    @RequestBody(description="The settings to create or update", content={@Content(schema=@Schema(implementation=RestAutoMergeProjectSettingsRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request auto-merge settings", representation=RestAutoMergeRestrictedSettings.class, responseCode=200), @ResponseDoc(documentation="The 'enabled' and 'restrictionAction' fields were not provided correctly.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create or update the pull request auto-merge settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response set(@BeanParam ProjectResolver projectResolver, RestAutoMergeProjectSettingsRequest request) {
        Project project = projectResolver.getProject();
        List<RestErrorMessage> errors = this.getProjectRequestErrors(request);
        if (!errors.isEmpty()) {
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(errors)).build();
        }
        ProjectScope scope = Scopes.project((Project)project);
        AutoMergeSettingsCreateRequest createRequest = new AutoMergeSettingsCreateRequest.Builder(scope, request.isEnabled().booleanValue()).build();
        AutoMergeSettings newSettings = (AutoMergeSettings)this.projectSettingsRestrictionService.withRestriction(project, ProjectSettingsRestrictionKeys.AUTO_MERGE, request.getRestrictionAction(), () -> this.autoMergeSettingsService.set(createRequest));
        return ResponseFactory.ok((Object)new RestAutoMergeRestrictedSettings(this.getRestrictionState((Scope)scope), newSettings)).build();
    }

    private List<RestErrorMessage> getProjectRequestErrors(RestAutoMergeProjectSettingsRequest request) {
        ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
        this.getEnabledError((RestAutoMergeSettingsRequest)request).ifPresent(errors::add);
        if (request.getRestrictionAction() == null) {
            errors.add(new RestErrorMessage("restrictionAction", this.i18nService.getMessage("bitbucket.rest.pull.automerge.error.settings.restrictionaction.invalid", new Object[0])));
        }
        return errors;
    }
}

