/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull.automerge;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeRestrictedSettings;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeSettingsRequest;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettings;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsCreateRequest;
import com.atlassian.bitbucket.pull.automerge.AutoMergeSettingsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.automerge.AbstractAutoMergeSettingsResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/settings/auto-merge")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class AutoMergeSettingsRepositoryResource
extends AbstractAutoMergeSettingsResource {
    @Inject
    public AutoMergeSettingsRepositoryResource(AutoMergeSettingsService autoMergeSettingsService, I18nService i18nService, DmzProjectSettingsRestrictionService projectSettingsRestrictionService) {
        super(autoMergeSettingsService, i18nService, projectSettingsRestrictionService);
    }

    @Operation(description="Deletes pull request auto-merge settings for the supplied repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for this repository to call the resource.", summary="Delete pull request auto-merge settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request auto-merge settings", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the pull request auto-merge settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The pull request auto-merge settings cannot be modified due to a restriction enforced by the supplied repository's project.", restError=true, responseCode=403)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam ScopeResolver scopeResolver) {
        return this.deleteSettings(scopeResolver.getScope());
    }

    @Operation(description="Retrieves the pull request auto-merge settings for the supplied repository. Project settings will be returned if no explicit settings have been set for the repository. In the case that there are no project settings, the default settings will be returned. If the repository's project has restricted its auto-merge settings, then the settings of the project will be returned.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for this repository to call the resource.", summary="Get pull request auto-merge settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request auto-merge settings", representation=RestAutoMergeRestrictedSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the pull request auto-merge settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam ScopeResolver scopeResolver) {
        return this.getSettings(scopeResolver.getScope());
    }

    @Operation(description="Creates or updates the pull request auto-merge settings for the supplied repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for this repository to call the resource.", summary="Create or update the pull request auto-merge settings")
    @RequestBody(description="The settings to create or update", content={@Content(schema=@Schema(implementation=RestAutoMergeSettingsRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The pull request auto-merge settings", representation=RestAutoMergeRestrictedSettings.class, responseCode=200), @ResponseDoc(documentation="The 'enabled' field was not provided correctly.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create or update the pull request auto-merge settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The pull request auto-merge settings cannot be modified due to a restriction enforced by the supplied repository's project.", restError=true, responseCode=403)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response set(@BeanParam RepositoryResolver repositoryResolver, RestAutoMergeSettingsRequest request) {
        Repository repository = repositoryResolver.getRepository();
        Optional<RestErrorMessage> enabledError = this.getEnabledError(request);
        if (enabledError.isPresent()) {
            return ResponseFactory.badRequest((String)enabledError.get().getContext(), (String)enabledError.get().getMessage()).build();
        }
        RepositoryScope scope = Scopes.repository((Repository)repository);
        AutoMergeSettingsCreateRequest createRequest = new AutoMergeSettingsCreateRequest.Builder(scope, request.isEnabled().booleanValue()).build();
        AutoMergeSettings newSettings = this.autoMergeSettingsService.set(createRequest);
        ProjectSettingsRestrictionState restrictionState = this.getRestrictionState((Scope)scope);
        return ResponseFactory.ok((Object)new RestAutoMergeRestrictedSettings(restrictionState, newSettings)).build();
    }
}

