/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull.automerge;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeProcessingResult;
import com.atlassian.bitbucket.dmz.rest.v2.pull.automerge.RestAutoMergeRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.automerge.AutoMergeProcessingResult;
import com.atlassian.bitbucket.pull.automerge.AutoMergeService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/auto-merge")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class PullRequestAutoMergeResource
extends AbstractPullRequestResource {
    private final AutoMergeService autoMergeService;

    @Inject
    public PullRequestAutoMergeResource(AutoMergeService autoMergeService, I18nService i18nService, DmzPullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
        this.autoMergeService = autoMergeService;
    }

    @Operation(description="Cancels a request to auto-merge the pull request, if the pull request was not merged yet.\n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the repository that this pull request targets to call this resource.", summary="Cancel auto-merge for pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The auto-merge request was cancelled.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to modify the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The specified pull request is not open.", responseCode=409, restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cancelAutoMerge(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId) {
        this.autoMergeService.cancelAutoMerge(repositoryResolver.getRepository().getId(), pullRequestId, AutoMergeCancelledReason.USER_CANCELLED_REQUEST);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Returns an auto-merge request for the pull request, if requested.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that this pull request targets to call this resource.", summary="Get auto-merge request for pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The auto-merge request.", representation=RestAutoMergeRequest.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAutoMergeRequest(@BeanParam PullRequestResolver pullRequestResolver) {
        return this.autoMergeService.getAutoMergeRequest(pullRequestResolver.getPullRequest()).map(request -> ResponseFactory.ok((Object)new RestAutoMergeRequest(request)).build()).orElseGet(() -> ResponseFactory.notFound().build());
    }

    @Operation(description="Requests the system to try merging the pull request if auto-merge was requested on it.\n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the repository that this pull request targets to call this resource.", summary="Auto-merge pull request")
    @Parameters(value={@Parameter(name="pullRequestId", description="The ID of the pull request within the repository", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The result of trying to auto-merge the pull request.", representation=RestAutoMergeProcessingResult.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to modify the pull request.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or pull request does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="An auto-merge request was not submitted for this pull request.", responseCode=400, restError=true), @ResponseDoc(documentation="The auto-merge setting is not enabled for the repository that this pull request targets.", responseCode=403, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response tryAutoMerge(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="pullRequestId") long pullRequestId) {
        Repository repository = repositoryResolver.getRepository();
        AutoMergeProcessingResult autoMergeProcessingResult = this.autoMergeService.tryAutoMerge(repository.getId(), pullRequestId);
        return ResponseFactory.ok((Object)new RestAutoMergeProcessingResult(autoMergeProcessingResult)).build();
    }
}

