/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull.reviewer;

import com.atlassian.bitbucket.dmz.rest.v2.pull.reviewer.RestReviewerGroup;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupCreateRequest;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupService;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupUpdateRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractReviewerGroupResource {
    private final I18nService i18nService;
    private final ReviewerGroupService reviewerGroupService;
    private final UserService userService;

    protected AbstractReviewerGroupResource(I18nService i18nService, ReviewerGroupService reviewerGroupService, UserService userService) {
        this.i18nService = i18nService;
        this.reviewerGroupService = reviewerGroupService;
        this.userService = userService;
    }

    protected Response createReviewerGroup(@Nonnull RestReviewerGroup reviewerGroup, @Nonnull Scope scope, @Nonnull UriInfo uriInfo) {
        Objects.requireNonNull(reviewerGroup, "reviewerGroup");
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(uriInfo, "uriInfo");
        if (StringUtils.isBlank((CharSequence)reviewerGroup.getName())) {
            return ResponseFactory.badRequest((String)this.i18nService.createKeyedMessage("bitbucket.service.reviewergroup.namerequired", new Object[0]).getLocalisedMessage()).build();
        }
        ReviewerGroupCreateRequest request = new ReviewerGroupCreateRequest.Builder(reviewerGroup.getName(), scope).description(reviewerGroup.getDescription()).users(this.extractUsers(reviewerGroup.getUsers())).build();
        ReviewerGroup created = this.reviewerGroupService.create(request);
        return ResponseFactory.created((URI)uriInfo.getRequestUriBuilder().path(String.valueOf(created.getId())).build(new Object[0])).entity((Object)new RestReviewerGroup(created)).build();
    }

    protected Response deleteReviewerGroup(long id) {
        this.reviewerGroupService.delete(id);
        return ResponseFactory.noContent().build();
    }

    protected Response getReviewerGroup(long id) {
        RestReviewerGroup restReviewerGroup = new RestReviewerGroup(this.reviewerGroupService.getById(id));
        return ResponseFactory.ok((Object)restReviewerGroup).build();
    }

    protected Response getReviewerGroups(@Nonnull Scope scope, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Page page = this.reviewerGroupService.findByScope(scope, pageRequest);
        return ResponseFactory.ok((Object)new RestPage(page, RestReviewerGroup::new)).build();
    }

    protected Response updateReviewerGroup(long id, @Nonnull RestReviewerGroup reviewerGroup) {
        Objects.requireNonNull(reviewerGroup, "reviewerGroup");
        if (reviewerGroup.hasName() && StringUtils.isBlank((CharSequence)reviewerGroup.getName())) {
            return ResponseFactory.badRequest((String)this.i18nService.createKeyedMessage("bitbucket.service.reviewergroup.namerequired", new Object[0]).getLocalisedMessage()).build();
        }
        ReviewerGroup existing = this.reviewerGroupService.getById(id);
        ReviewerGroupUpdateRequest.Builder requestBuilder = new ReviewerGroupUpdateRequest.Builder(existing).users(this.extractUsers(reviewerGroup.getUsers()));
        if (reviewerGroup.hasDescription()) {
            requestBuilder.description(reviewerGroup.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)reviewerGroup.getName())) {
            requestBuilder.name(reviewerGroup.getName());
        }
        ReviewerGroup updated = this.reviewerGroupService.update(requestBuilder.build());
        return ResponseFactory.ok((Object)new RestReviewerGroup(updated)).build();
    }

    private Set<ApplicationUser> extractUsers(Set<ApplicationUser> users) {
        Set userIds = users.stream().map(ApplicationUser::getId).collect(Collectors.toSet());
        return this.userService.getUsersById(userIds);
    }
}

