/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull.reviewer;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.pull.reviewer.RestReviewerGroup;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupService;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.reviewer.AbstractReviewerGroupResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/settings/reviewer-groups")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class ReviewerGroupProjectResource
extends AbstractReviewerGroupResource {
    @Inject
    public ReviewerGroupProjectResource(I18nService i18nService, ReviewerGroupService reviewerGroupService, UserService userService) {
        super(i18nService, reviewerGroupService, userService);
    }

    @Operation(description="Create a reviewer group.\n\nThe authenticated user must have <b>PROJECT_ADMIN</b> permission for the specified project to call this resource.", summary="Create reviewer group")
    @RequestBody(description="The reviewer group to be create", content={@Content(schema=@Schema(implementation=RestReviewerGroup.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created reviewer group.", representation=RestReviewerGroup.class, responseCode=201), @ResponseDoc(documentation="The request is missing a reviewer group name.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The project scope supplied does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The new created name already exists.", responseCode=409, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response create(@Context UriInfo uriInfo, @BeanParam ScopeResolver scopeResolver, RestReviewerGroup reviewerGroup) {
        return this.createReviewerGroup(reviewerGroup, scopeResolver.getScope(), uriInfo);
    }

    @Operation(description="Deletes a reviewer group.\n\nThe authenticated user must have <b>PROJECT_ADMIN</b> permission for the specified project to call this resource.", summary="Delete reviewer group")
    @Parameter(name="id", description="The ID of the reviewer group to be deleted", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The operation was successful.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the reviewer group in this project.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied reviewer group ID.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@PathParam(value="id") long id) {
        return this.deleteReviewerGroup(id);
    }

    @Override
    @Operation(description="Retrieve a reviewer group.\n\nThe authenticated user must have <b>PROJECT_READ</b> permission for the specified project to call this resource.", summary="Get reviewer group")
    @Parameter(name="id", description="The ID of the reviewer group to be retrieved", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The reviewer group.", representation=RestReviewerGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The ID supplied does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getReviewerGroup(@PathParam(value="id") long id) {
        return super.getReviewerGroup(id);
    }

    @Operation(description="Retrieve a page of reviewer groups of a given scope.\n\nThe authenticated user must have <b>PROJECT_READ</b> permission for the specified project to call this resource.", summary="Get all reviewer groups")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of reviewer group(s) of the provided scope.", representation=RestReviewerGroup.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The project scope supplied does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getReviewerGroups(@BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        return super.getReviewerGroups(scopeResolver.getScope(), pageRequestResolver.getPageRequest());
    }

    @Operation(description="Update the attributes of a reviewer group.\n\nThe authenticated user must have <b>PROJECT_READ</b> permission for the specified project to call this resource.", summary="Update reviewer group attributes")
    @Parameters(value={@Parameter(name="id", description="The ID of the reviewer group to be updated", in=ParameterIn.PATH)})
    @RequestBody(description="The request containing the attributes of the reviewer group to be updated. Only the attributes to be updated need to be present in this object.", content={@Content(schema=@Schema(implementation=RestReviewerGroup.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of changes.", representation=RestReviewerGroup.class, responseCode=200), @ResponseDoc(documentation="The updated attribute does not meet the requirements. E.g. the name exceeds 50 characters, setting name to blank.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The project scope supplied does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The new updated name already exists.", responseCode=409, restError=true)})
    @PUT
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response update(@PathParam(value="id") long id, RestReviewerGroup reviewerGroup) {
        return this.updateReviewerGroup(id, reviewerGroup);
    }
}

