/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.ratelimit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounterOrder;
import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounterSearchRequest;
import com.atlassian.bitbucket.dmz.ratelimit.DmzAggregateRejectCounterSearchService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.ratelimit.RestAggregateRejectCounter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/rate-limit/history")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class RateLimitHistoryResource {
    private static final String INVALID_SORT = "bitbucket.rest.ratelimit.error.history.sort.invalid";
    private final I18nService i18nService;
    private final DmzAggregateRejectCounterSearchService rejectCounterSearchService;

    @Inject
    public RateLimitHistoryResource(I18nService i18nService, DmzAggregateRejectCounterSearchService rejectCounterSearchService) {
        this.i18nService = i18nService;
        this.rejectCounterSearchService = rejectCounterSearchService;
    }

    @Operation(description="Retrieves the recent rate limit history for the instance.\n\nThe authenticated user must have the <strong>ADMIN</strong> permission to call this resource.", summary="Get rate limit history")
    @Parameter(description="An optional sort category to arrange the results in descending order", name="order", in=ParameterIn.QUERY, schema=@Schema(allowableValues={"NEWEST", "FREQUENCY"}))
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing a page of aggregated counters for users who have been recently rate limited.", paged=true, representation=RestAggregateRejectCounter.class, responseCode=200), @ResponseDoc(documentation="The sort query parameter is invalid.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve rate limit history.", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getHistory(@QueryParam(value="order") String orderString, @BeanParam PageRequestResolver pageRequestResolver) {
        AggregateRejectCounterOrder order;
        try {
            order = AggregateRejectCounterOrder.fromString((String)orderString, (AggregateRejectCounterOrder)AggregateRejectCounterOrder.FREQUENCY);
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.error((Response.Status)Response.Status.BAD_REQUEST, (String)"order", (String)this.i18nService.getMessage(INVALID_SORT, new Object[]{String.join((CharSequence)", ", (Iterable)Arrays.stream(AggregateRejectCounterOrder.values()).map(Enum::name).collect(MoreCollectors.toImmutableList()))})).build();
        }
        AggregateRejectCounterSearchRequest searchRequest = new AggregateRejectCounterSearchRequest.Builder().sort(order).build();
        Page page = this.rejectCounterSearchService.getRejectCounters(searchRequest, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestAggregateRejectCounter::new)).build();
    }
}

