/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.ratelimit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.ratelimit.DmzRateLimitSettingsService;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestRateLimitSettings;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="admin/rate-limit/settings")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class RateLimitSettingsResource {
    private static final String I18N_PREFIX = "bitbucket.rest.ratelimit.error.settings.";
    @VisibleForTesting
    static final String EMPTY_REQUEST = "bitbucket.rest.ratelimit.error.settings.empty";
    @VisibleForTesting
    static final String INVALID_ENABLED_VALUE = "bitbucket.rest.ratelimit.error.settings.enabled.invalid";
    @VisibleForTesting
    static final String INVALID_TOKEN_BUCKET_SETTINGS_PROPERTY_VALUE = "bitbucket.rest.ratelimit.error.settings.token.bucket.property.invalid";
    @VisibleForTesting
    static final String MISSING_TOKEN_BUCKET_SETTINGS = "bitbucket.rest.ratelimit.error.settings.token.bucket.required";
    @VisibleForTesting
    static final String MISSING_TOKEN_BUCKET_SETTINGS_PROPERTY = "bitbucket.rest.ratelimit.error.settings.token.bucket.property.required";
    private final I18nService i18nService;
    private final DmzRateLimitSettingsService rateLimitSettingsService;

    @Inject
    public RateLimitSettingsResource(I18nService i18nService, DmzRateLimitSettingsService rateLimitSettingsService) {
        this.i18nService = i18nService;
        this.rateLimitSettingsService = rateLimitSettingsService;
    }

    @Operation(description="Retrieves the rate limit settings for the instance.\n\nThe user must be authenticated to call this resource.", summary="Get rate limit settings")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the rate limit plugin settings for the instance.", representation=RestRateLimitSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve rate limit settings.", representation=RestRateLimitSettings.class, responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSettings() {
        return ResponseFactory.ok().entity((Object)new RestRateLimitSettings(this.rateLimitSettingsService.isEnabled(), this.rateLimitSettingsService.getDefault())).build();
    }

    @Operation(description="Sets the rate limit settings for the instance.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", summary="Set rate limit")
    @RequestBody(description="Sets the rate limit settings for the instance.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", content={@Content(schema=@Schema(implementation=RestRateLimitSettings.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the updated rate limit plugin settings for the instance.", representation=RestRateLimitSettings.class, responseCode=200), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details):\n\n- The request is empty\n- The enabled field of the request is not a boolean\n- The defaultSettings field of the request does not contain both capacity and fillRate\n- The capacity and fillRate are not positive integers\n\n\n", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to set rate limit settings.", responseCode=401, restError=true)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setSettings(RestRateLimitSettings settings) {
        ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
        Boolean enabled = null;
        TokenBucketSettings.Builder builder = new TokenBucketSettings.Builder();
        if (!settings.hasEnabled() && !settings.hasDefaultSettings()) {
            errors.add(new RestErrorMessage(this.i18nService.getMessage(EMPTY_REQUEST, new Object[0])));
        } else {
            if (settings.hasEnabled()) {
                enabled = this.validateEnabled(settings.getEnabled(), errors);
            }
            if (settings.hasDefaultSettings()) {
                this.validateDefaultSettings(settings.getDefaultSettings(), builder, errors);
            }
        }
        if (!errors.isEmpty()) {
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(errors)).build();
        }
        if (enabled != null) {
            this.rateLimitSettingsService.setEnabled(enabled.booleanValue());
        }
        if (settings.hasDefaultSettings()) {
            this.rateLimitSettingsService.setDefault(builder.build());
        }
        RestRateLimitSettings newSettings = new RestRateLimitSettings(this.rateLimitSettingsService.isEnabled(), this.rateLimitSettingsService.getDefault());
        return ResponseFactory.ok().entity((Object)newSettings).build();
    }

    private void validateDefaultSettings(RestTokenBucketSettings tokenBucketSettings, TokenBucketSettings.Builder builder, List<RestErrorMessage> errors) {
        if (tokenBucketSettings == null) {
            errors.add(new RestErrorMessage("defaultSettings", this.i18nService.getMessage(MISSING_TOKEN_BUCKET_SETTINGS, new Object[0])));
            return;
        }
        boolean hasCapacity = tokenBucketSettings.hasCapacity();
        boolean hasFillRate = tokenBucketSettings.hasFillRate();
        if (hasCapacity && hasFillRate) {
            try {
                builder.capacity(tokenBucketSettings.getCapacity());
            }
            catch (IllegalArgumentException e) {
                errors.add(new RestErrorMessage("defaultSettings.capacity", this.i18nService.getMessage(INVALID_TOKEN_BUCKET_SETTINGS_PROPERTY_VALUE, new Object[]{"capacity", tokenBucketSettings.get((Object)"capacity")})));
            }
            try {
                builder.fillRate(tokenBucketSettings.getFillRate());
            }
            catch (IllegalArgumentException e) {
                errors.add(new RestErrorMessage("defaultSettings.fillRate", this.i18nService.getMessage(INVALID_TOKEN_BUCKET_SETTINGS_PROPERTY_VALUE, new Object[]{"fillRate", tokenBucketSettings.get((Object)"fillRate")})));
            }
        } else {
            if (!hasCapacity) {
                errors.add(new RestErrorMessage("defaultSettings.capacity", this.i18nService.getMessage(MISSING_TOKEN_BUCKET_SETTINGS_PROPERTY, new Object[]{"capacity"})));
            }
            if (!hasFillRate) {
                errors.add(new RestErrorMessage("defaultSettings.fillRate", this.i18nService.getMessage(MISSING_TOKEN_BUCKET_SETTINGS_PROPERTY, new Object[]{"fillRate"})));
            }
        }
    }

    private Boolean validateEnabled(Boolean enabled, List<RestErrorMessage> errors) {
        if (enabled == null) {
            errors.add(new RestErrorMessage("enabled", this.i18nService.getMessage(INVALID_ENABLED_VALUE, new Object[0])));
        }
        return enabled;
    }
}

