/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounter;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZoneOffset;
import java.util.Date;

@JsonSerialize
@JsonSurrogate(value=AggregateRejectCounter.class)
public class RestAggregateRejectCounter
extends RestMapEntity {
    private static String APPLICATION_USER = "user";
    private static String LAST_REJECT_TIME = "lastRejectTime";
    private static String REJECT_COUNT = "rejectCount";

    public RestAggregateRejectCounter() {
    }

    public RestAggregateRejectCounter(AggregateRejectCounter counter) {
        this(counter.getUser(), counter.getRejectCount(), Date.from(counter.getIntervalStart().atZone(ZoneOffset.UTC).toInstant()));
    }

    private RestAggregateRejectCounter(ApplicationUser user, long rejectCount, Date lastRejectTime) {
        this.put(APPLICATION_USER, new RestApplicationUser(user));
        this.put(REJECT_COUNT, rejectCount);
        this.put(LAST_REJECT_TIME, lastRejectTime);
    }

    @Schema(example="1630041546433", type="number")
    public Date getLastRejectTime() {
        return (Date)this.get(LAST_REJECT_TIME);
    }

    @Schema(example="5")
    public long getRejectCount() {
        return this.getLongProperty(REJECT_COUNT);
    }

    public RestApplicationUser getUser() {
        return (RestApplicationUser)this.get(APPLICATION_USER);
    }
}

