/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.ratelimit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.ratelimit.DmzRateLimitSettingsService;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsSearchRequest;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsUpdateRequest;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestBulkUserRateLimitSettingsUpdateRequest;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestBulkUserRateLimitSettingsUpdateResponse;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestUserRateLimitSettings;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestUserRateLimitSettingsUpdateRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.UserResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="admin/rate-limit/settings/users")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
public class UserRateLimitSettingsResource {
    private static final String I18N_PREFIX = "bitbucket.rest.ratelimit.error.settings.";
    @VisibleForTesting
    static final String INVALID_COMBINATION = "bitbucket.rest.ratelimit.error.settings.users.invalid.combination";
    @VisibleForTesting
    static final String INVALID_TOKEN_BUCKET_SETTINGS_PROPERTY_VALUE = "bitbucket.rest.ratelimit.error.settings.token.bucket.property.invalid";
    @VisibleForTesting
    static final String INVALID_USERNAME = "bitbucket.rest.ratelimit.error.settings.users.username.invalid";
    @VisibleForTesting
    static final String INVALID_USER = "bitbucket.rest.ratelimit.error.settings.users.user.invalid";
    @VisibleForTesting
    static final String MISSING_TOKEN_BUCKET_SETTINGS_PROPERTY = "bitbucket.rest.ratelimit.error.settings.token.bucket.property.required";
    @VisibleForTesting
    static final String USERNAMES_REQUIRED = "bitbucket.rest.ratelimit.error.settings.users.username.required";
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final DmzRateLimitSettingsService rateLimitSettingsService;
    private final UserService userService;
    private final WebSudoManager webSudoManager;

    @Inject
    public UserRateLimitSettingsResource(AuthenticationContext authenticationContext, I18nService i18nService, DmzRateLimitSettingsService rateLimitSettingsService, UserService userService, WebSudoManager webSudoManager) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.rateLimitSettingsService = rateLimitSettingsService;
        this.userService = userService;
        this.webSudoManager = webSudoManager;
    }

    @Operation(description="Deletes the user-specific rate limit settings for the given user.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", summary="Delete user specific rate limit settings")
    @Parameter(description="The user slug.", name="userSlug", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the user settings have been deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve rate limit settings.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist, or has no settings.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{userSlug}")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam UserResolver userResolver) {
        return this.rateLimitSettingsService.delete(userResolver.getUser()) ? ResponseFactory.noContent().build() : ResponseFactory.notFound().build();
    }

    @Operation(description="Retrieves the user-specific rate limit settings for the given user.\n\nTo call this resource, the user must be authenticated and either have <strong>ADMIN</strong> permission or be the same user as the one whose settings are requested. A user with <strong>ADMIN</strong> permission cannot get the settings of a user with <strong>SYS_ADMIN</strong> permission.", summary="Get user specific rate limit settings")
    @Parameter(description="The user slug.", name="userSlug", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the user-specific rate limit settings for the given user.", representation=RestUserRateLimitSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve rate limit settings.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist, or has no settings.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{userSlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam UserResolver userResolver, @Context HttpServletRequest request) {
        ApplicationUser user = userResolver.getUser();
        if (!user.equals((Object)this.authenticationContext.getCurrentUser())) {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
        return this.rateLimitSettingsService.get(user).map(us -> ResponseFactory.ok((Object)new RestUserRateLimitSettings(us)).build()).orElseGet(() -> ResponseFactory.notFound().build());
    }

    @Operation(description="Retrieves the user-specific rate limit settings for the given user.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", summary="Get rate limit settings for user")
    @Parameter(description="Optional filter", name="filter", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing all the user-specific rate limit settings filtered by the optional filter.", paged=true, representation=RestUserRateLimitSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve rate limit settings.", responseCode=401, restError=true)})
    @GET
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllRateLimitSettings(@QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.rateLimitSettingsService.search(new UserRateLimitSettingsSearchRequest(filter), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestUserRateLimitSettings::new)).build();
    }

    @Operation(description="Sets the given rate limit settings for the given user.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", summary="Set rate limit settings for user")
    @Parameter(description="The user slug.", name="userSlug", in=ParameterIn.PATH)
    @RequestBody(content={@Content(schema=@Schema(implementation=RestUserRateLimitSettingsUpdateRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the updated user settings", representation=RestUserRateLimitSettings.class, responseCode=200), @ResponseDoc(documentation="One of the following valid state error cases occurred (check the error message for more details):\n\n- The request is empty\n- Whitelisted is false or not provided, and no settings are provided either\n- Whitelisted is false or not provided, settings are provided,   but do not contain both capacity and fillRate\n- Whitelisted is false or not provided, settings are provided,   but capacity and fillRate are not positive integers\n- Whitelisted is true, and settings are provided (only one must be provided)\n\n\n", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to set user settings.", responseCode=401, restError=true)})
    @PUT
    @Path(value="/{userSlug}")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response set(@BeanParam UserResolver userResolver, RestUserRateLimitSettingsUpdateRequest request) {
        if (request.isWhitelisted() == request.hasSettings()) {
            return ResponseFactory.error((Response.Status)Response.Status.BAD_REQUEST, null, (String)this.i18nService.getMessage(INVALID_COMBINATION, new Object[0])).build();
        }
        UserRateLimitSettingsUpdateRequest.Builder requestBuilder = new UserRateLimitSettingsUpdateRequest.Builder();
        ApplicationUser user = userResolver.getUser();
        RestUserRateLimitSettings.Builder responseBuilder = new RestUserRateLimitSettings.Builder(user);
        if (request.isWhitelisted()) {
            requestBuilder.whitelisted();
            responseBuilder.whitelisted();
        } else {
            ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
            TokenBucketSettings tokenBucketSettings = this.validateSettings(request.getSettings(), errors);
            if (!errors.isEmpty()) {
                return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(errors)).build();
            }
            requestBuilder.withSettings(tokenBucketSettings);
            responseBuilder.withSettings(tokenBucketSettings);
        }
        this.rateLimitSettingsService.set(user, requestBuilder.build());
        return ResponseFactory.ok((Object)responseBuilder.build()).build();
    }

    @Operation(description="Sets the given rate limit settings for the given users.\n\nThe authenticated user must have <strong>ADMIN</strong> permission to call this resource.", summary="Set rate limit settings for users")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestBulkUserRateLimitSettingsUpdateRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the updated user settings.", representation=RestUserRateLimitSettings.class, responseCode=200), @ResponseDoc(documentation="One of the following valid state error cases occurred (check the error message for more details):\n\n- The request is empty\n- No users are provided in the request\n- One or more of the users are invalid\n- Whitelisted is false or not provided, and no settings are provided either\n- Whitelisted is false or not provided, settings are provided,   but do not contain both capacity and fillRate\n- Whitelisted is false or not provided, settings are provided,   but capacity and fillRate are not positive integers\n- Whitelisted is true, and settings are provided (only one must be provided)\n", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to set user settings.", responseCode=401, restError=true)})
    @POST
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response set(RestBulkUserRateLimitSettingsUpdateRequest request) {
        Set<Object> users;
        ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
        if (!request.getUsernames().isEmpty()) {
            Set usernames = request.getUsernames();
            Set validUsernames = (Set)usernames.stream().filter(StringUtils::isNotBlank).collect(MoreCollectors.toImmutableSet());
            if (validUsernames.size() != usernames.size()) {
                errors.add(new RestErrorMessage("users", this.i18nService.getMessage(INVALID_USERNAME, new Object[0])));
            }
            users = this.validateUsers(validUsernames, errors);
        } else {
            errors.add(new RestErrorMessage("users", this.i18nService.getMessage(USERNAMES_REQUIRED, new Object[0])));
            users = Collections.emptySet();
        }
        UserRateLimitSettingsUpdateRequest.Builder requestBuilder = new UserRateLimitSettingsUpdateRequest.Builder();
        RestBulkUserRateLimitSettingsUpdateResponse.Builder responseBuilder = new RestBulkUserRateLimitSettingsUpdateResponse.Builder(users);
        if (request.isWhitelisted() == request.hasSettings()) {
            errors.add(new RestErrorMessage(null, this.i18nService.getMessage(INVALID_COMBINATION, new Object[0])));
        } else if (request.isWhitelisted()) {
            requestBuilder.whitelisted();
            responseBuilder.whitelisted();
        } else {
            TokenBucketSettings tokenBucketSettings = this.validateSettings(request.getSettings(), errors);
            requestBuilder.withSettings(tokenBucketSettings);
            responseBuilder.withSettings(tokenBucketSettings);
        }
        if (!errors.isEmpty()) {
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(errors)).build();
        }
        this.rateLimitSettingsService.set(users, requestBuilder.build());
        return ResponseFactory.ok((Object)responseBuilder.build()).build();
    }

    private TokenBucketSettings validateSettings(RestTokenBucketSettings tokenBucketSettings, List<RestErrorMessage> errors) {
        TokenBucketSettings.Builder builder = new TokenBucketSettings.Builder();
        boolean hasCapacity = tokenBucketSettings.hasCapacity();
        boolean hasFillRate = tokenBucketSettings.hasFillRate();
        if (hasCapacity && hasFillRate) {
            try {
                builder.capacity(tokenBucketSettings.getCapacity());
            }
            catch (IllegalArgumentException e) {
                errors.add(new RestErrorMessage("settings.capacity", this.i18nService.getMessage(INVALID_TOKEN_BUCKET_SETTINGS_PROPERTY_VALUE, new Object[]{"capacity", tokenBucketSettings.get((Object)"capacity")})));
            }
            try {
                builder.fillRate(tokenBucketSettings.getFillRate());
            }
            catch (IllegalArgumentException e) {
                errors.add(new RestErrorMessage("settings.fillRate", this.i18nService.getMessage(INVALID_TOKEN_BUCKET_SETTINGS_PROPERTY_VALUE, new Object[]{"fillRate", tokenBucketSettings.get((Object)"fillRate")})));
            }
        } else {
            if (!hasCapacity) {
                errors.add(new RestErrorMessage("settings.capacity", this.i18nService.getMessage(MISSING_TOKEN_BUCKET_SETTINGS_PROPERTY, new Object[]{"capacity"})));
            }
            if (!hasFillRate) {
                errors.add(new RestErrorMessage("settings.fillRate", this.i18nService.getMessage(MISSING_TOKEN_BUCKET_SETTINGS_PROPERTY, new Object[]{"fillRate"})));
            }
        }
        return builder.build();
    }

    private Set<ApplicationUser> validateUsers(Set<String> usernames, List<RestErrorMessage> errors) {
        Set users = this.userService.getUsersByName(usernames);
        if (users.size() != usernames.size()) {
            Set foundUsernames = (Set)users.stream().map(Principal::getName).collect(MoreCollectors.toImmutableSet());
            usernames.stream().filter(username -> !foundUsernames.contains(username)).forEach(username -> errors.add(new RestErrorMessage("users", this.i18nService.getMessage(INVALID_USER, new Object[]{username}))));
        }
        return users;
    }
}

