/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.render;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.markup.RestMarkup;
import com.atlassian.bitbucket.internal.rest.enrich.MarkupRequestHelper;
import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderException;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@LicensedOnly
@Path(value="markup")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Markup")
public class MarkupResource {
    private final MarkupService markupService;
    private final PermissionValidationService permissionValidationService;

    @Inject
    public MarkupResource(MarkupService markupService, PermissionValidationService permissionValidationService) {
        this.markupService = markupService;
        this.permissionValidationService = permissionValidationService;
    }

    @Operation(description="Preview generated HTML for the given markdown content.\n\nOnly authenticated users may call this resource.", summary="Preview markdown render")
    @RequestBody(content={@Content(schema=@Schema(example="# Hello World!"))})
    @Parameters(value={@Parameter(description="(Optional) Whether the markup implementation should convert newlines to breaks. By default this is false which reflects the standard markdown specification.", in=ParameterIn.QUERY, name="hardwrap"), @Parameter(description="(Optional) true if headers should contain an ID based on the heading content.", in=ParameterIn.QUERY, name="includeHeadingId"), @Parameter(description="(Optional) The mode to use when building URLs. One of: ABSOLUTE, RELATIVE or, CONFIGURED. By default this is RELATIVE.", in=ParameterIn.QUERY, name="urlMode"), @Parameter(description="(Optional) true if HTML should be escaped in the input markup, false otherwise.", in=ParameterIn.QUERY, name="htmlEscape")})
    @ResponseDocs(value={@ResponseDoc(documentation="The rendered markdown.", representation=RestMarkup.class, responseCode=200), @ResponseDoc(documentation="The markdown was invalid.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions preview rendered markdown.", restError=true, responseCode=401)})
    @POST
    @Path(value="preview")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response preview(@Context UriInfo uriInfo, String content, @QueryParam(value="hardwrap") boolean hardwrap, @QueryParam(value="htmlEscape") boolean htmlEscape, @QueryParam(value="includeHeadingId") boolean includeHeadingId, @QueryParam(value="urlMode") String urlMode) {
        this.permissionValidationService.validateAuthenticated();
        try {
            return ResponseFactory.ok((Object)new RestMarkup(this.markupService.render(content, MarkupRequestHelper.makeRenderContext(uriInfo)))).build();
        }
        catch (RenderException e) {
            throw new BadRequestException(e.getLocalizedMessage());
        }
    }
}

