/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestMetadataMap;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.CreateBranchRequest;
import com.atlassian.bitbucket.repository.MetadataMap;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataRequest;
import com.atlassian.bitbucket.repository.RefOrder;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RepositoryBranchesRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.rest.v2.api.repository.RestBranch;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.json.marshal.JsonableMarshaller;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.repository.AbstractRepositoryRefResource;
import com.atlassian.stash.internal.rest.repository.RestCreateBranchRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/branches")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Singleton
@Tag(name="Repository")
public class BranchResource
extends AbstractRepositoryRefResource {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final I18nService i18nService;
    private final JsonableMarshaller jsonableMarshaller;
    private final RepositoryService repositoryService;

    @Inject
    public BranchResource(RefService refService, I18nService i18nService, JsonableMarshaller jsonableMarshaller, RepositoryService repositoryService) {
        super(refService);
        this.i18nService = i18nService;
        this.jsonableMarshaller = jsonableMarshaller;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Creates a branch using the information provided in the RestCreateBranchRequest request \n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the context repository to call this resource.", summary="Create branch")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestCreateBranchRequest.class))}, description="The request to create a branch containing a <strong>name</strong>, <strong>startPoint</strong>, and optionally a <strong>message</strong>")
    @ResponseDocs(value={@ResponseDoc(documentation="The created branch.", representation=RestBranch.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to write to the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createBranchForRepository(@BeanParam RepositoryResolver repositoryResolver, RestCreateBranchRequest restRequest) {
        if (StringUtils.isBlank((CharSequence)restRequest.getName())) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.rest.ref.name.blank", new Object[0])).build();
        }
        if (StringUtils.isBlank((CharSequence)restRequest.getStartPoint())) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.rest.ref.startPoint.blank", new Object[0])).build();
        }
        return this.process(repositoryResolver.getRepository(), (repository, refService) -> new RestBranch(refService.createBranch(((CreateBranchRequest.Builder)new CreateBranchRequest.Builder(repository, restRequest.getName(), restRequest.getStartPoint()).message(restRequest.getMessage())).build())));
    }

    @Operation(description="Retrieve the branches matching the supplied <strong>filterText</strong> param. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Find branches")
    @Parameters(value={@Parameter(description="Base branch or tag to compare each branch to (for the metadata providers that uses that information", in=ParameterIn.QUERY, name="base"), @Parameter(description="Whether to retrieve plugin-provided metadata about each branch", in=ParameterIn.QUERY, name="details", schema=@Schema(type="boolean")), @Parameter(description="The text to match on", in=ParameterIn.QUERY, name="filterText"), @Parameter(description="Ordering of refs either ALPHABETICAL (by name) or MODIFICATION (last updated)", in=ParameterIn.QUERY, name="orderBy", schema=@Schema(allowableValues={"ALPHABETICAL", "MODIFICATION"})), @Parameter(description="Controls whether exact and prefix matches will be boosted to the top", in=ParameterIn.QUERY, name="boostMatches", schema=@Schema(type="boolean"))})
    @ResponseDocs(value={@ResponseDoc(documentation="The branches matching the supplied <strong>filterText</strong>.", paged=true, representation=RestBranch.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getBranches(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="base") String baseRefId, @QueryParam(value="details") boolean details, @QueryParam(value="filterText") String filterText, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="boostMatches") boolean boostMatches, @QueryParam(value="context") String contextString, @Context ContainerRequestContext requestContext) {
        return this.process(repositoryResolver.getRepository(), (repository, refService) -> {
            RepositoryBranchesRequest request = ((RepositoryBranchesRequest.Builder)((RepositoryBranchesRequest.Builder)((RepositoryBranchesRequest.Builder)new RepositoryBranchesRequest.Builder(repository).boostMatches(boostMatches)).filterText(filterText)).order(RefOrder.fromValueOrNull((String)orderBy))).build();
            Page branches = refService.getBranches(request, pageRequestResolver.getPageRequest());
            Function<Branch, RestBranch> restTransformer = RestBranch.REST_TRANSFORM;
            if (details && branches.getSize() > 0) {
                Ref baseRef = refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(baseRefId).build());
                if (baseRef == null) {
                    throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.rest.branches.error.invalidBaseRef", new Object[]{baseRefId, repository.getName()}));
                }
                Map metadataByRef = refService.getMetadataByRefs(new RefMetadataRequest.Builder().baseRef(baseRef).context(this.extractContextFromString(contextString)).refs(branches.getValues()).repository(repository).build());
                restTransformer = this.toRestBranchWithMetadata(metadataByRef);
            }
            return new RestPage(branches, (Function)restTransformer);
        });
    }

    @Operation(deprecated=true, description="Retrieves the repository's default branch, if it has been created. If the repository is empty, 204 No Content will be returned. For non-empty repositories, if the configured default branch has not yet been created a 404 Not Found will be returned. \n\nThis URL is deprecated. Callers should use <code>GET /projects/{key}/repos/{slug}/default-branch</code> instead, which allows retrieving the <i>configured</i> default branch even if the ref has not been created yet. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get default branch")
    @ResponseDocs(value={@ResponseDoc(documentation="The configured default branch for the repository.", representation=RestBranch.class, responseCode=200), @ResponseDoc(documentation="The repository is empty, and has no default branch.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist, or its configured default branch does not exist.", responseCode=404, restError=true)})
    @Tag(name="Deprecated")
    @Deprecated
    @GET
    @Path(value="default")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDefaultBranch(@BeanParam RepositoryResolver repositoryResolver) {
        if (this.repositoryService.isEmpty(repositoryResolver.getRepository())) {
            return ResponseFactory.noContent().build();
        }
        return this.process(repositoryResolver.getRepository(), (repository, refService) -> {
            Branch defaultBranch = refService.getDefaultBranch(repository);
            return new RestBranch(defaultBranch);
        });
    }

    @Operation(deprecated=true, description="Update the default branch of a repository. \n\nThis URL is deprecated. Callers should use <code>PUT /projects/{key}/repos/{slug}/default-branch</code> instead. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Update default branch")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestBranch.class))}, description="The branch to set as default")
    @ResponseDocs(value={@ResponseDoc(documentation="The operation was successful.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @Tag(name="Deprecated")
    @Deprecated
    @PUT
    @Path(value="default")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setDefaultBranch(@BeanParam RepositoryResolver repositoryResolver, RestBranch branch) {
        return this.process(repositoryResolver.getRepository(), (repository, refService) -> {
            refService.setDefaultBranch(repository, branch.getId());
            return ResponseFactory.noContent();
        });
    }

    private Map<String, Object> extractContextFromString(String contextString) {
        if (contextString != null) {
            try {
                return (Map)OBJECT_MAPPER.readValue(contextString, Map.class);
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    private Function<Branch, RestBranch> toRestBranchWithMetadata(Map<Ref, MetadataMap> metadataByRef) {
        return branch -> {
            RestBranch restBranch = new RestBranch(branch);
            MetadataMap metadataMap = (MetadataMap)metadataByRef.get(branch);
            restBranch.put((Object)"metadata", (Object)(metadataMap != null ? new RestMetadataMap(metadataMap, this.jsonableMarshaller) : new RestMetadataMap()));
            return restBranch;
        };
    }
}

