/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.label.RestLabel;
import com.atlassian.bitbucket.label.ApplyLabelRequest;
import com.atlassian.bitbucket.label.Label;
import com.atlassian.bitbucket.label.LabelService;
import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.bitbucket.label.RemoveLabelRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.OptionalServiceRegistry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/labels")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositoryLabelResource {
    private final OptionalServiceRegistry serviceRegistry;

    @Inject
    public RepositoryLabelResource(OptionalServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Operation(description="Applies a label to the repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository.", summary="Add repository label")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestLabel.class))}, description="The label to apply")
    @ResponseDocs(value={@ResponseDoc(documentation="The applied label.", representation=RestLabel.class, responseCode=200), @ResponseDoc(documentation="A validation error prevented the label from being created or applied. Possible validation errors include: The name of the label contains uppercase characters, the name is smaller than 3 characters or longer than 50 characters, the label contains other characters than a-z 0-9 and - or the label is already applied to the given repository.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to apply a label.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addLabel(@BeanParam RepositoryResolver repositoryResolver, RestLabel label) {
        LabelService labelService = this.serviceRegistry.getLabelServiceOrThrow();
        return ResponseFactory.ok((Object)new RestLabel(RepositoryLabelResource.addLabelToRepository(labelService, repositoryResolver.getRepository(), label.getName()))).build();
    }

    @Operation(description="Get all labels applied to the given repository. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository.", summary="Get repository labels")
    @ResponseDocs(value={@ResponseDoc(documentation="The applied label.", representation=RestLabel.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the labels.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllLabelsForRepository(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        LabelService labelService = this.serviceRegistry.getLabelServiceOrThrow();
        return ResponseFactory.ok((Object)new RestPage(labelService.findByLabelable((Labelable)repositoryResolver.getRepository(), pageRequestResolver.getPageRequest()), RestLabel::new)).build();
    }

    @Operation(description="Remove label that is applied to the given repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository.", summary="Remove repository label")
    @Parameters(value={@Parameter(description="The label to remove", in=ParameterIn.PATH, name="labelName")})
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the label is no longer associated to the repository.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to remove the label.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{labelName}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response removeLabel(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="labelName") String labelName) {
        LabelService labelService = this.serviceRegistry.getLabelServiceOrThrow();
        labelService.findByName(labelName).ifPresent(label -> labelService.remove(((RemoveLabelRequest.Builder)((RemoveLabelRequest.Builder)new RemoveLabelRequest.Builder().labelable((Labelable)repositoryResolver.getRepository())).label(label)).build()));
        return Response.noContent().build();
    }

    private static Label addLabelToRepository(LabelService labelService, Repository repository, String labelName) {
        Label label = labelService.findByName(labelName).orElseGet(() -> labelService.create(labelName));
        return labelService.apply(((ApplyLabelRequest.Builder)((ApplyLabelRequest.Builder)new ApplyLabelRequest.Builder().labelable((Labelable)repository)).label(label)).build());
    }
}

