/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.repository.DmzRepositoryService;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivityBranchesRequest;
import com.atlassian.bitbucket.dmz.repository.RepositoryRefChangeActivitySearchRequest;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestRepositoryRefChangeActivity;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Path(value="projects/{projectKey}/repos/{repositorySlug}/ref-change-activities")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositoryRefChangeActivityResource {
    private final DmzRepositoryService repositoryService;

    @Inject
    public RepositoryRefChangeActivityResource(DmzRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Operation(description="Retrieve a page of branches with ref change activities for a specific repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission to call this resource.", summary="Get branches with ref change activities for repository")
    @Parameters(value={@Parameter(description="(optional) Partial match for a ref ID to filter minimal refs for", in=ParameterIn.QUERY, name="filterText")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of branches with ref change activities.", paged=true, representation=RestMinimalRef.class, responseCode=200), @ResponseDoc(documentation="The user is currently not authenticated or the user does not have REPO_ADMIN permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/branches")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findBranches(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="filterText") String filterText) {
        RepositoryRefChangeActivityBranchesRequest request = new RepositoryRefChangeActivityBranchesRequest.Builder(repositoryResolver.getRepository()).filterText(filterText).build();
        Page branches = this.repositoryService.findBranchesWithRefChangeActivities(request, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(branches, RestMinimalRef::new)).build();
    }

    @Operation(description="Retrieve a page of repository ref change activity. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission to call this resource.", summary="Get ref change activity")
    @Parameters(value={@Parameter(description="(optional) exact match for a ref ID to filter ref change activity for", in=ParameterIn.QUERY, name="ref")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of ref change activity.", paged=true, representation=RestRepositoryRefChangeActivity.class, responseCode=200), @ResponseDoc(documentation="The user is currently not authenticated or the user does not have REPO_ADMIN permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRefChangeActivity(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="ref") String refId) {
        RepositoryRefChangeActivitySearchRequest request = new RepositoryRefChangeActivitySearchRequest.Builder(repositoryResolver.getRepository()).refId(refId).build();
        Page refChangeActivities = this.repositoryService.searchRefChangeActivities(request, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(refChangeActivities, RestRepositoryRefChangeActivity::new)).build();
    }
}

