/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.enrich.MarkupRequestHelper;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositoryUpdateRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.repository.RestBranch;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scm.AvailableScm;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.RestContentHelper;
import com.atlassian.stash.internal.rest.content.StandardFile;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Project")
public class RepositoryResource {
    private static final String CONTENT_LOCATION = "Content-Location";
    private static final Pattern PATTERN_LOCATION = Pattern.compile("(.+projects/)([^/]+)(/repos/)(.+)$");
    private static final Logger log = LoggerFactory.getLogger(RepositoryResource.class);
    private final RestContentHelper contentHelper;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final ProjectService projectService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final ScmService scmService;

    @Inject
    public RepositoryResource(I18nService i18nService, RestContentHelper contentHelper, NavBuilder navBuilder, ProjectService projectService, RefService refService, RepositoryService repositoryService, ScmService scmService) {
        this.contentHelper = contentHelper;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.projectService = projectService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
    }

    @Operation(description="Create a new repository. Requires an existing project in which this repository will be created. The only parameters which will be used are name and scmId. \n\nThe authenticated user must have <strong>REPO_CREATE</strong> permission or higher, for the context project to call this resource.", summary="Create repository")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestRepository.class))}, description="The repository")
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created repository.", representation=RestRepository.class, responseCode=201), @ResponseDoc(documentation="The repository was not created due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a repository.", responseCode=401, restError=true), @ResponseDoc(documentation="A repository with same name already exists.", responseCode=409, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createRepository(@BeanParam ProjectResolver projectResolver, @Context UriInfo uriInfo, RestRepository restRepository) {
        String name = restRepository.getName();
        if (name == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.noreponame", new Object[0]));
        }
        String scmId = restRepository.getScmId();
        if (StringUtils.isBlank((CharSequence)scmId)) {
            Set scms = this.scmService.getAvailable();
            if (scms.size() == 1) {
                scmId = ((AvailableScm)Iterables.getOnlyElement((Iterable)scms)).getId();
                log.debug("{}: No SCM was supplied; defaulting to {}", (Object)name, (Object)scmId);
            } else {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.noscm", new Object[]{Iterables.toString((Iterable)Iterables.transform((Iterable)scms, AvailableScm::getId))}));
            }
        }
        RepositoryCreateRequest request = ((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().defaultBranch(restRepository.getDefaultBranch()).description(restRepository.getDescription())).forkable(restRepository.isForkable())).name(name)).project(projectResolver.getProject()).scmId(scmId).publiclyAccessible(restRepository.isPublic())).build();
        Repository repository = this.repositoryService.create(request);
        URI repoURI = uriInfo.getRequestUriBuilder().path(repository.getSlug()).build(new Object[0]);
        return ResponseFactory.created((URI)repoURI).entity((Object)this.transform(repository)).build();
    }

    @Operation(description="Schedule the repository matching the supplied <strong>projectKey</strong> and <strong>repositorySlug</strong> to be deleted. \n\nThe authenticated user must have sufficient permissions specified by the repository delete policy to call this resource. The default permission required is <strong>REPO_ADMIN</strong> permission.", summary="Delete repository")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository has been scheduled for deletion.", responseCode=202), @ResponseDoc(documentation="No repository matching the supplied <strong>projectKey</strong> and <strong>repositorySlug</strong> was found.", responseCode=204, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the repository.", responseCode=401, restError=true)})
    @DELETE
    @Path(value="{repositorySlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteRepository(@PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repositorySlug) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
        if (repository == null) {
            return ResponseFactory.noContent().build();
        }
        this.repositoryService.delete(repository);
        return ResponseFactory.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new RestErrorMessage(this.i18nService.getMessage("bitbucket.rest.repository.deletionscheduled", new Object[0]))).build();
    }

    @Operation(hidden=true)
    @HEAD
    @Path(value="{repositorySlug}/contributing")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findContributing(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo) {
        return this.findStandardFile(repositoryResolver.getRepository(), uriInfo, StandardFile.CONTRIBUTING_GUIDELINES);
    }

    @Operation(hidden=true)
    @HEAD
    @Path(value="{repositorySlug}/license")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findLicense(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo) {
        return this.findStandardFile(repositoryResolver.getRepository(), uriInfo, StandardFile.LICENSE);
    }

    @Operation(hidden=true)
    @HEAD
    @Path(value="{repositorySlug}/readme")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findReadme(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo) {
        return this.findStandardFile(repositoryResolver.getRepository(), uriInfo, StandardFile.README);
    }

    @Operation(description="Create a new repository forked from an existing repository. \n\nThe JSON body for this <code>POST</code> is not required to contain <i>any</i> properties. Even the name may be omitted. The following properties will be used, if provided: \n\n- <code>\"name\":\"Fork name\"</code> - Specifies the forked repository's name \n  - Defaults to the name of the origin repository if not specified\n- <code>\"defaultBranch\":\"main\"</code> - Specifies the forked repository's default branch\n  - Defaults to the origin repository's default branch if not specified\n- <code>\"project\":{\"key\":\"TARGET_KEY\"}</code> - Specifies the forked repository's target project by key\n  - Defaults to the current user's personal project if not specified\n\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository and <strong>PROJECT_ADMIN</strong> on the target project to call this resource. Note that users <i>always</i> have <b>PROJECT_ADMIN</b> permission on their personal projects.", summary="Fork repository")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestRepository.class))}, description="The rest fork.")
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created fork.", representation=RestRepository.class, responseCode=201), @ResponseDoc(documentation="A validation error prevented the fork from being created. Possible validation errors include: The name or slug for the fork collides with another repository in the target project; an SCM type was specified in the JSON body; a project was specified in the JSON body without a \"key\" property.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a fork.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist, or, if a target project was specified, the target project does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="{repositorySlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response forkRepository(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, RestRepository restFork) {
        String scmId = restFork.getScmId();
        if (scmId != null && !scmId.equals(repositoryResolver.getRepository().getScmId())) {
            String message = this.i18nService.getMessage("bitbucket.rest.repository.forkwithtype", new Object[0]);
            throw new BadRequestException(message);
        }
        RestProject project = restFork.getProject();
        if (project != null) {
            String projectKey = project.getKey();
            if (StringUtils.isBlank((CharSequence)projectKey)) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.fork.missingprojectkey", new Object[0]));
            }
            project = this.projectService.getByKey(projectKey);
            if (project == null) {
                throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.rest.repository.fork.nosuchproject", new Object[]{projectKey}));
            }
        }
        RepositoryForkRequest.Builder requestBuilder = ((RepositoryForkRequest.Builder)new RepositoryForkRequest.Builder(repositoryResolver.getRepository()).defaultBranch(restFork.getDefaultBranch()).forkable(restFork.isForkable())).project((Project)project);
        if (restFork.getName() != null) {
            requestBuilder.name(restFork.getName());
        }
        return this.created(this.repositoryService.fork(requestBuilder.build()), uriInfo);
    }

    @Operation(description="Retrieves the repository's <i>configured</i> default branch. \n\nEvery repository has a <i>configured</i> default branch, but that branch may not actually <i>exist</i> in the repository. For example, a newly-created repository will have a configured default branch even though no branches have been pushed yet. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get repository default branch")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @ResponseDocs(value={@ResponseDoc(documentation="The configured default branch for the repository.", representation=RestMinimalRef.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist, or its configured default branch does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{repositorySlug}/default-branch")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDefaultBranch(@BeanParam RepositoryResolver repositoryResolver) {
        MinimalRef defaultBranch = this.repositoryService.getDefaultBranch(repositoryResolver.getRepository());
        return ResponseFactory.ok(RestMinimalRef.REST_TRANSFORM.apply(defaultBranch)).build();
    }

    @Operation(description="Retrieve repositories which have been forked from this one. Unlike #getRelatedRepositories(Repository, PageRequest) related repositories, this only looks at a given repository's direct forks. If those forks have themselves been the origin of more forks, such \"grandchildren\" repositories will not be retrieved. \n\nOnly repositories to which the authenticated user has <b>REPO_READ</b> permission will be included, even if other repositories have been forked from this one.", summary="Get repository forks")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of repositories related to the request repository.", paged=true, representation=RestRepository.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the request repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The request repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{repositorySlug}/forks")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getForkedRepositories(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.repositoryService.findByOrigin(repositoryResolver.getRepository(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestRepository.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve repositories which are related to this one. Related repositories are from the same Repository#getHierarchyId() hierarchy as this repository. \n\nOnly repositories to which the authenticated user has <b>REPO_READ</b> permission will be included, even if more repositories are part of this repository's hierarchy.", summary="Get related repository")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of repositories related to the request repository.", paged=true, representation=RestRepository.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the request repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The request repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{repositorySlug}/related")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRelatedRepositories(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.repositoryService.findRelated(repositoryResolver.getRepository(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestRepository.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve repositories from the project corresponding to the supplied <strong>projectKey</strong>. \n\nThe authenticated user must have <strong>PROJECT_READ</strong> permission for the specified project to call this resource.", summary="Get repositories for project")
    @ResponseDocs(value={@ResponseDoc(documentation="The repositories matching the supplied <strong>projectKey</strong>.", paged=true, representation=RestRepository.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the specified project.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositories(@PathParam(value="projectKey") String projectKey, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.repositoryService.findByProjectKey(projectKey, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestRepository.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve the repository matching the supplied <strong>projectKey</strong> and <strong>repositorySlug</strong>. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get repository")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository which matches the supplied <strong>projectKey</strong> and <strong>repositorySlug</strong>.", representation=RestRepository.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{repositorySlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepository(@BeanParam RepositoryResolver repositoryResolver) {
        return ResponseFactory.ok((Object)this.transform(repositoryResolver.getRepository())).build();
    }

    @Operation(description="If a create or fork operation fails, calling this method will clean up the broken repository and try again. The repository must be in an INITIALISATION_FAILED state. \n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project to call this resource.", summary="Retry repository creation")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created repository.", representation=RestRepository.class, responseCode=200), @ResponseDoc(documentation="The repository was not created due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="{repositorySlug}/recreate")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response retryCreateRepository(@BeanParam RepositoryResolver repositoryResolver) {
        return ResponseFactory.ok((Object)this.transform(this.repositoryService.retryCreate(repositoryResolver.getRepository()))).build();
    }

    @Operation(description="Update the default branch of a repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Update default branch for repository")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestBranch.class))}, description="The branch to set as default")
    @ResponseDocs(value={@ResponseDoc(documentation="The default branch was updated.", responseCode=204), @ResponseDoc(documentation="The authenticated user does not have permission to modify the default branch.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="{repositorySlug}/default-branch")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setDefaultBranch(@BeanParam RepositoryResolver repositoryResolver, RestBranch branch) {
        this.refService.setDefaultBranch(repositoryResolver.getRepository(), branch.getId());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieves the contributing guidelines for the repository, if they've been defined. \n\nThis checks the repository for a CONTRIBUTING file, optionally with an md or txt extension, and, if found, streams it. By default, the <i>raw content</i> of the file is streamed. Appending <code>?markup</code> to the URL will stream an HTML-rendered version instead. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get repository contributing guidelines")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug"), @Parameter(description="A specific commit or ref to retrieve the guidelines at, or the default branch if not specified", in=ParameterIn.QUERY, name="at"), @Parameter(description="(Optional) Whether the markup implementation should convert newlines to breaks. If not specified, the value of the <code>markup.render.hardwrap</code> property, which is <code>true</code> by default, will be used", in=ParameterIn.QUERY, name="hardwrap"), @Parameter(description="(Optional) true if HTML should be escaped in the input markup, false otherwise. If not specified, the value of the <code>markup.render.html.escape</code> property, which is <code>true</code> by default, will be used", in=ParameterIn.QUERY, name="htmlEscape"), @Parameter(description="(Optional) true if headings should contain an ID based on the heading content. If not specified, the value of the <code>markup.render.headerids</code> property, which is false by default, will be used", in=ParameterIn.QUERY, name="includeHeadingId"), @Parameter(description="If present or <code>\"true\"</code>, triggers the raw content to be markup-rendered and returned as HTML; otherwise, if not specified, or any value other than <code>\"true\"</code>, the content is streamed without markup", in=ParameterIn.QUERY, name="markup")})
    @ResponseDocs(value={@ResponseDoc(documentation="The contributing guidelines for the repository.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{repositorySlug}/contributing")
    @Produces
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamContributing(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, @QueryParam(value="at") String at, @QueryParam(value="hardwrap") String hardwrap, @QueryParam(value="htmlEscape") String htmlEscape, @QueryParam(value="includeHeadingId") String includeHeadingId, @QueryParam(value="markup") String markup) {
        return this.streamStandardFile(repositoryResolver.getRepository(), uriInfo, StandardFile.CONTRIBUTING_GUIDELINES);
    }

    @Operation(description="Retrieves the license for the repository, if it's been defined. \n\nThis checks the repository for a <pre>LICENSE</pre> file, optionally with an <pre>md</pre> or <pre>txt</pre>extension, and, if found, streams it. By default, the <i>raw content</i> of the file is streamed. Appending <pre>?markup</pre> to the URL will stream an HTML-rendered version instead. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get repository license")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug"), @Parameter(description="A specific commit or ref to retrieve the guidelines at, or the default branch if not specified", in=ParameterIn.QUERY, name="at"), @Parameter(description="(Optional) Whether the markup implementation should convert newlines to breaks. If not specified, the value of the <code>markup.render.hardwrap</code> property, which is <code>true</code> by default, will be used", in=ParameterIn.QUERY, name="hardwrap"), @Parameter(description="(Optional) true if HTML should be escaped in the input markup, false otherwise. If not specified, the value of the <code>markup.render.html.escape</code> property, which is <code>true</code> by default, will be used", in=ParameterIn.QUERY, name="htmlEscape"), @Parameter(description="(Optional) true if headings should contain an ID based on the heading content. If not specified, the value of the <code>markup.render.headerids</code> property, which is false by default, will be used", in=ParameterIn.QUERY, name="includeHeadingId"), @Parameter(description="If present or <code>\"true\"</code>, triggers the raw content to be markup-rendered and returned as HTML; otherwise, if not specified, or any value other than <code>\"true\"</code>, the content is streamed without markup", in=ParameterIn.QUERY, name="markup")})
    @ResponseDocs(value={@ResponseDoc(documentation="The license for the repository.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{repositorySlug}/license")
    @Produces
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamLicense(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, @QueryParam(value="at") String at, @QueryParam(value="hardwrap") String hardwrap, @QueryParam(value="htmlEscape") String htmlEscape, @QueryParam(value="includeHeadingId") String includeHeadingId, @QueryParam(value="markup") String markup) {
        return this.streamStandardFile(repositoryResolver.getRepository(), uriInfo, StandardFile.LICENSE);
    }

    @Operation(description="Retrieves the README for the repository, if it's been defined. \n\nThis checks the repository for a <pre>README</pre> file, optionally with an <pre>md</pre> or <pre>txt</pre>extension, and, if found, streams it. By default, the <i>raw content</i> of the file is streamed. Appending <pre>?markup</pre> to the URL will stream an HTML-rendered version instead. Note that, when streaming HTML, relative URLs in the README will not work if applied relative to this URL. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get repository readme")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug"), @Parameter(description="A specific commit or ref to retrieve the guidelines at, or the default branch if not specified", in=ParameterIn.QUERY, name="at"), @Parameter(description="(Optional) Whether the markup implementation should convert newlines to breaks. If not specified, the value of the <code>markup.render.hardwrap</code> property, which is <code>true</code> by default, will be used", in=ParameterIn.QUERY, name="hardwrap"), @Parameter(description="(Optional) true if HTML should be escaped in the input markup, false otherwise. If not specified, the value of the <code>markup.render.html.escape</code> property, which is <code>true</code> by default, will be used", in=ParameterIn.QUERY, name="htmlEscape"), @Parameter(description="(Optional) true if headings should contain an ID based on the heading content. If not specified, the value of the <code>markup.render.headerids</code> property, which is false by default, will be used", in=ParameterIn.QUERY, name="includeHeadingId"), @Parameter(description="If present or <code>\"true\"</code>, triggers the raw content to be markup-rendered and returned as HTML; otherwise, if not specified, or any value other than <code>\"true\"</code>, the content is streamed without markup", in=ParameterIn.QUERY, name="markup")})
    @ResponseDocs(value={@ResponseDoc(documentation="The README for the repository.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{repositorySlug}/readme")
    @Produces
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamReadme(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, @QueryParam(value="at") String at, @QueryParam(value="hardwrap") String hardwrap, @QueryParam(value="htmlEscape") String htmlEscape, @QueryParam(value="includeHeadingId") String includeHeadingId, @QueryParam(value="markup") String markup) {
        return this.streamStandardFile(repositoryResolver.getRepository(), uriInfo, StandardFile.README);
    }

    @Operation(description="Update the repository matching the <strong>repositorySlug</strong> supplied in the resource path. \n\nThe repository's slug is derived from its name. If the name changes the slug may also change. \n\nThis resource can be used to change the repository's default branch by specifying a new default branch in the request. For example: <code>\"defaultBranch\":\"main\"</code>\n\nThis resource can be used to move the repository to a different project by specifying a new project in the request. For example: <code>\"project\":{\"key\":\"NEW_KEY\"}</code>\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Update repository")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestRepository.class))}, description="The updated repository.")
    @ResponseDocs(value={@ResponseDoc(documentation="The updated repository.", representation=RestRepository.class, responseCode=201), @ResponseDoc(documentation="The repository was not updated due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update a repository.", responseCode=401, restError=true), @ResponseDoc(documentation="Cannot archive repository because it has open pull requests.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="A repository with the same name as the target already exists, or the repository is archived.", responseCode=409, restError=true)})
    @PUT
    @Path(value="{repositorySlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateRepository(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, RestRepository restRepository) {
        Repository repository = repositoryResolver.getRepository();
        if (restRepository.getScmId() != null && !restRepository.getScmId().equals(repository.getScmId())) {
            String message = this.i18nService.getMessage("bitbucket.rest.repository.nochangetype", new Object[0]);
            throw new BadRequestException("scmId", message);
        }
        String slug = repository.getSlug();
        String projectKey = repository.getProject().getKey();
        RepositoryUpdateRequest.Builder builder = new RepositoryUpdateRequest.Builder(repository);
        if (StringUtils.isNotBlank((CharSequence)restRepository.getName())) {
            builder = (RepositoryUpdateRequest.Builder)builder.name(restRepository.getName());
        }
        if (restRepository.hasArchived()) {
            builder = builder.archived(restRepository.isArchived());
        }
        if (restRepository.hasDefaultBranch()) {
            builder = builder.defaultBranch(restRepository.getDefaultBranch());
        }
        if (restRepository.hasDescription()) {
            builder = (RepositoryUpdateRequest.Builder)builder.description(restRepository.getDescription());
        }
        if (restRepository.hasForkable()) {
            builder = (RepositoryUpdateRequest.Builder)builder.forkable(restRepository.isForkable());
        }
        if (restRepository.hasPublic()) {
            builder = (RepositoryUpdateRequest.Builder)builder.publiclyAccessible(restRepository.isPublic());
        }
        if (restRepository.hasProject()) {
            builder = builder.project(this.projectService.getByKey(restRepository.getProject().getKey()));
        }
        if (slug.equals((repository = this.repositoryService.update(builder.build())).getSlug()) && projectKey.equals(repository.getProject().getKey())) {
            return ResponseFactory.ok((Object)this.transform(repository)).build();
        }
        return this.created(repository, uriInfo);
    }

    private String buildRawUrl(Repository repository, UriInfo uriInfo, String path) {
        UriBuilder builder = UriBuilder.fromPath((String)this.navBuilder.rest().buildAbsolute()).path("projects/{projectKey}/repos/{repositorySlug}").path("raw/{path}");
        uriInfo.getQueryParameters().forEach((key, values) -> builder.queryParam(key, values.toArray()));
        return builder.build(new Object[]{repository.getProject().getKey(), repository.getSlug(), path}).toASCIIString();
    }

    private Response created(Repository repository, UriInfo uriInfo) {
        String requestPath = uriInfo.getRequestUri().getPath();
        Matcher matcher = PATTERN_LOCATION.matcher(requestPath);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The request path, " + requestPath + ", is not understood");
        }
        String location = matcher.group(1) + repository.getProject().getKey() + matcher.group(3) + repository.getSlug();
        return ResponseFactory.created((URI)uriInfo.getRequestUriBuilder().replacePath(location).build(new Object[0])).entity((Object)this.transform(repository)).build();
    }

    private Response findStandardFile(Repository repository, UriInfo uriInfo, StandardFile file) {
        String at = this.getRevision(repository, uriInfo, file.getName());
        String path = this.contentHelper.searchFiles(repository, at, file);
        return ResponseFactory.ok().header(CONTENT_LOCATION, (Object)this.buildRawUrl(repository, uriInfo, path)).build();
    }

    private String getRevision(Repository repository, UriInfo uriInfo, String path) {
        return this.contentHelper.getRevision(repository, (String)uriInfo.getQueryParameters().getFirst((Object)"at"), path);
    }

    private Response streamStandardFile(Repository repository, UriInfo uriInfo, StandardFile file) {
        String at = this.getRevision(repository, uriInfo, file.getName());
        String path = this.contentHelper.searchFiles(repository, at, file);
        String markup = (String)uriInfo.getQueryParameters().getFirst((Object)"markup");
        Response.ResponseBuilder builder = "".equals(markup) || "true".equalsIgnoreCase(markup) ? this.contentHelper.streamMarkup(repository, at, path, MarkupRequestHelper.makeRenderContext(uriInfo)) : this.contentHelper.streamBytes(repository, at, path);
        return builder.header(CONTENT_LOCATION, (Object)this.buildRawUrl(repository, uriInfo, path)).build();
    }

    private RestRepository transform(Repository repository) {
        return new RestRepository(repository, true);
    }
}

