/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.util.RestPermissionUtils;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="repos")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositorySearchResource {
    private final I18nService i18nService;
    private final RepositoryService repositoryService;

    @Inject
    public RepositorySearchResource(@Nonnull I18nService i18nService, @Nonnull RepositoryService repositoryService) {
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.repositoryService = Objects.requireNonNull(repositoryService, "repositoryService");
    }

    @Operation(description="Retrieve a page of repositories based on query parameters that control the search. See the documentation of the parameters for more details. \n\nThis resource is anonymously accessible, if anonymous access is enabled. \n\n<b>Note on permissions.</b> In absence of the <code>permission</code> query parameter the implicit 'read' permission is assumed. Please note that this permission is lower than the <tt>REPO_READ</tt> permission rather than being equal to it. The implicit 'read' permission for a given repository is assigned to any user that has any of the higher permissions, such as <tt>REPO_READ</tt>, as well as to anonymous users if the repository is marked as public. The important implication of the above is that an anonymous request to this resource with a permission level <tt>REPO_READ</tt> is guaranteed to receive an empty list of repositories as a result. For anonymous requests it is therefore recommended to not specify the <tt>permission</tt> parameter at all.", summary="Search for repositories")
    @Parameters(value={@Parameter(description="(optional) if specified, this will limit the resulting repository list to ones whose are <tt>ACTIVE</tt>, <tt>ARCHIVED</tt> or <tt>ALL</tt> for both. The match performed is case-insensitive. This filter defaults to <tt>ACTIVE</tt> when not set. <em>Available since 8.0</em>", in=ParameterIn.QUERY, name="archived"), @Parameter(description="(optional) if specified, this will limit the resulting repository list to ones whose name matches this parameter's value. The match performed is case-insensitive and any leading and/or trailing whitespace characters on the <code>name</code> parameter will be stripped.", in=ParameterIn.QUERY, name="name"), @Parameter(description="(optional) if specified, this will limit the resulting repository list to ones whose project's key matches this parameter's value. The match performed is case-insensitive and any leading  and/or trailing whitespace characters on the <code>projectKey</code> parameter will be stripped. <em>Available since 8.0</em>", in=ParameterIn.QUERY, name="projectkey"), @Parameter(description="(optional) if specified, this will limit the resulting repository list to ones whose project's name matches this parameter's value. The match performed is case-insensitive and any leading and/or trailing whitespace characters on the <code>projectname</code> parameter will be stripped.", in=ParameterIn.QUERY, name="projectname"), @Parameter(description="(optional) if specified, it must be a valid repository permission level name and will limit the resulting repository list to ones that the requesting user has the specified permission level to. If not specified, the default implicit 'read' permission level will be assumed. The currently supported explicit permission values are <tt>REPO_READ</tt>, <tt>REPO_WRITE</tt> and <tt>REPO_ADMIN</tt>.", in=ParameterIn.QUERY, name="permission", schema=@Schema(allowableValues={"REPO_READ", "REPO_WRITE", "REPO_ADMIN"})), @Parameter(description="(optional) if specified, it must be a valid repository state name and will limit the resulting repository list to ones that are in the specified state. The currently supported explicit state values are <tt>AVAILABLE</tt>, <tt>INITIALISING</tt> and <tt>INITIALISATION_FAILED</tt>. Filtering by <tt>OFFLINE</tt> repositories is not supported.<br><em>Available since 5.13</em>", in=ParameterIn.QUERY, name="state", schema=@Schema(allowableValues={"AVAILABLE", "INITIALISING", "INITIALISATION_FAILED"})), @Parameter(description="(optional) if specified, this will limit the resulting repository list based on the repositories visibility. Valid values are <em>public</em> or <em>private</em>.", in=ParameterIn.QUERY, name="visibility", schema=@Schema(allowableValues={"public", "private"}))})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of repositories.", paged=true, representation=RestRepository.class, responseCode=200), @ResponseDoc(documentation="The <code>permission</code> level is unknown or not related to repository.", responseCode=400, restError=true), @ResponseDoc(documentation="The <code>visibility</code> parameter contains an invalid value.", responseCode=400, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositories(@DefaultValue(value="ACTIVE") @QueryParam(value="archived") String archived, @QueryParam(value="name") String name, @QueryParam(value="projectname") String projectname, @QueryParam(value="projectkey") String projectKey, @QueryParam(value="permission") String permission, @QueryParam(value="state") String state, @QueryParam(value="visibility") String visibility, @BeanParam PageRequestResolver pageRequestResolver) {
        Repository.State parsedState = this.parseState(state);
        if (parsedState == Repository.State.OFFLINE) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.state.offline", new Object[]{RepositorySearchResource.validStates()}));
        }
        RepositorySearchRequest.Builder builder = new RepositorySearchRequest.Builder().archived(this.checkArchiveFilter(archived.toUpperCase())).name(name).permission(RestPermissionUtils.parsePermission((I18nService)this.i18nService, (String)permission, Repository.class)).projectName(projectname).projectKey(projectKey).state(parsedState);
        if (StringUtils.isNotBlank((CharSequence)visibility)) {
            try {
                builder.visibility(RepositoryVisibility.valueOf((String)visibility.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException e) {
                return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestErrors(this.i18nService.getMessage("bitbucket.rest.repository.search.nosuchvisibility", new Object[]{visibility}))).build();
            }
        }
        Page page = this.repositoryService.search(builder.build(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestRepository.REST_TRANSFORM)).build();
    }

    private RepositoryArchiveFilter checkArchiveFilter(String value) {
        try {
            return RepositoryArchiveFilter.fromString((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.search.invalidarchivefilter", new Object[]{value, Arrays.stream(RepositoryArchiveFilter.values()).map(Enum::name).collect(Collectors.joining(", "))}));
        }
    }

    private Repository.State parseState(String state) {
        if (state == null) {
            return null;
        }
        try {
            return Repository.State.valueOf((String)state.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.state.invalid", new Object[]{RepositorySearchResource.validStates()}));
        }
    }

    private static String validStates() {
        return Arrays.stream(Repository.State.values()).filter(value -> value != Repository.State.OFFLINE).map(Enum::name).collect(Collectors.joining(", "));
    }
}

