/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.pull.PullRequestMergeConfigRestrictionEnricher;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeConfig;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeStrategy;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestRepositoryPullRequestSettings;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.DeletePullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.GetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.SetPullRequestMergeConfigRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.fragment.DefaultRestFragmentContext;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragments;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentsFactory;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.pull.RestRestrictedPullRequestMergeConfig;
import com.atlassian.stash.internal.rest.util.RestMergeConfigUtils;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/settings")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositorySettingsResource {
    private static final String PULL_REQUEST_SETTINGS_KEY = "bitbucket.repository.settings.pullRequests";
    private static final String MERGE_CONFIG = "mergeConfig";
    private final RestFragmentsFactory fragmentsFactory;
    private final I18nService i18nService;
    private final PullRequestMergeConfigRestrictionEnricher mergeConfigEnricher;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestService pullRequestService;

    @Inject
    public RepositorySettingsResource(I18nService i18nService, RestFragmentsFactory fragmentsFactory, PullRequestMergeConfigRestrictionEnricher mergeConfigEnricher, PermissionValidationService permissionValidationService, PullRequestService pullRequestService) {
        this.fragmentsFactory = fragmentsFactory;
        this.i18nService = i18nService;
        this.mergeConfigEnricher = mergeConfigEnricher;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestService = pullRequestService;
    }

    @Operation(description="Retrieve the pull request settings for the context repository. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the context repository to call this resource. \n\nThis resource will call all RestFragments that are registered with the key <strong>bitbucket.repository.settings.pullRequests</strong>. If any fragment fails validations by returning a non-empty Map of errors, then no fragments will execute. \n\nThe property keys for the settings that are bundled with the application are \n\n- mergeConfig - the merge strategy configuration for pull requests\n- requiredApprovers - (Deprecated, please use com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook instead) the number of approvals required on a pull request for it to be mergeable, or 0 if the merge check is disabled\n- com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook - the merge check configuration for required approvers\n- requiredAllApprovers - whether or not all approvers must approve a pull request for it to be mergeable\n- requiredAllTasksComplete - whether or not all tasks on a pull request need to be completed for it to be mergeable\n- requiredSuccessfulBuilds - (Deprecated, please use com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck instead) the number of successful builds on a pull request for it to be mergeable, or 0 if the merge check is disabled\n- com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck - the merge check configuration for required builds\n\n\n", summary="Get pull request settings")
    @Parameters(value={@Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY)", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository pull request settings for the context repository.", representation=RestRepositoryPullRequestSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/pull-requests")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequestSettings(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, @QueryParam(value="enrich") boolean enrich) {
        return this.loadPullRequestSettings(repositoryResolver.getRepository(), "GET", uriInfo, null, enrich);
    }

    @Operation(description="Update the pull request settings for the context repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the context repository to call this resource. \n\nThis resource will call all RestFragments that are registered with the key <strong>bitbucket.repository.settings.pullRequests</strong>. If any fragment fails validations by returning a non-empty Map of errors, then no fragments will execute. \n\nOnly the settings that should be updated need to be included in the request. \n\nThe property keys for the settings that are bundled with the application are \n\n- mergeConfig - the merge strategy configuration for pull requests\n- requiredApprovers - (Deprecated, please use com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook instead) the number of approvals required on a pull request for it to be mergeable, or 0 to disable the merge check\n- com.atlassian.bitbucket.server.bundled-hooks.requiredApproversMergeHook - a json map containing the keys 'enabled' (a boolean to enable or disable this merge check) and 'count' (an integer to set the number of required approvals)\n- requiredAllApprovers - whether or not all approvers must approve a pull request for it to be mergeable\n- requiredAllTasksComplete - whether or not all tasks on a pull request need to be completed for it to be mergeable\n- requiredSuccessfulBuilds - (Deprecated, please use com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck instead) the number of successful builds on a pull request for it to be mergeable, or 0 to disable the merge check\n- com.atlassian.bitbucket.server.bitbucket-build.requiredBuildsMergeCheck - a json map containing the keys 'enabled' (a boolean to enable or disable this merge check) and 'count' (an integer to set the number of required builds)\n\n\n<strong>Merge strategy configuration deletion:</strong>\n\nAn explicitly set pull request merge strategy configuration can be deleted by POSTing a document with an empty \"mergeConfig\" attribute. i.e: \n\n\n```{ \n    \"mergeConfig\": { \n    } \n} \n```\n\nUpon completion of this request, the effective configuration will be: \n\n- The configuration set for this repository's SCM type as set at the project level, if present, otherwise\n- the configuration set for this repository's SCM type as set at the instance level, if present, otherwise\n- the default configuration for this repository's SCM type\n\n\n", summary="Update pull request settings")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestRepositoryPullRequestSettings.class))}, description="The updated settings.")
    @Parameters(value={@Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY)", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository pull request settings for the context repository.", representation=RestRepositoryPullRequestSettings.class, responseCode=200), @ResponseDoc(documentation="The repository pull request settings were not updated due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="/pull-requests")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updatePullRequestSettings(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, RestRepositoryPullRequestSettings settings, @QueryParam(value="enrich") boolean enrich) {
        RestPullRequestMergeConfig mergeConfig = settings.getMergeConfig();
        if (mergeConfig == null) {
            this.permissionValidationService.validateForRepository(repositoryResolver.getRepository(), Permission.REPO_ADMIN);
        } else {
            this.setPullRequestMergeConfig(repositoryResolver.getRepository(), mergeConfig);
        }
        return this.loadPullRequestSettings(repositoryResolver.getRepository(), "POST", uriInfo, settings, enrich);
    }

    private Response loadPullRequestSettings(Repository repository, String httpMethod, UriInfo uriInfo, RestRepositoryPullRequestSettings settings, boolean enrich) {
        settings = settings != null ? settings : new RestRepositoryPullRequestSettings();
        try {
            settings.put((Object)MERGE_CONFIG, (Object)this.getPullRequestMergeConfig(repository, enrich));
        }
        catch (FeatureUnsupportedScmException featureUnsupportedScmException) {
            // empty catch block
        }
        ArrayList errors = new ArrayList();
        if (this.fragmentsFactory.existsForKey(PULL_REQUEST_SETTINGS_KEY)) {
            RestFragments fragments = this.fragmentsFactory.forKey(PULL_REQUEST_SETTINGS_KEY, (Map)ImmutableMap.of((Object)"repository", (Object)repository));
            DefaultRestFragmentContext context = new DefaultRestFragmentContext((Map)settings, httpMethod, uriInfo);
            errors.addAll(fragments.validate((RestFragmentContext)context));
            if (errors.isEmpty()) {
                settings.putAll(fragments.execute((RestFragmentContext)context));
            }
        }
        if (!errors.isEmpty()) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"errors", errors)).build();
        }
        if (settings.isEmpty()) {
            return ResponseFactory.noContent().build();
        }
        return ResponseFactory.ok((Object)settings).build();
    }

    private RestPullRequestMergeConfig getPullRequestMergeConfig(Repository repository, boolean enrich) {
        PullRequestMergeConfig mergeConfig = this.pullRequestService.getMergeConfig(new GetPullRequestMergeConfigRequest.Builder(repository).build());
        if (enrich) {
            return new RestRestrictedPullRequestMergeConfig(this.mergeConfigEnricher.enrich(mergeConfig, repository.getProject()));
        }
        return new RestPullRequestMergeConfig(mergeConfig);
    }

    private void setPullRequestMergeConfig(Repository repository, RestPullRequestMergeConfig config) {
        if (config.isEmpty()) {
            this.pullRequestService.deleteMergeConfig(new DeletePullRequestMergeConfigRequest.Builder(repository).build());
        } else {
            RestPullRequestMergeStrategy defaultStrategy = RestMergeConfigUtils.verifyDefaultStrategy(config, this.i18nService);
            Set<String> mergeStrategyIds = RestMergeConfigUtils.getMergeStrategyIds(config.getStrategies());
            RestPullRequestCommitMessageTemplate template = RestMergeConfigUtils.verifyCommitMessageTemplate(config, this.i18nService);
            SetPullRequestMergeConfigRequest.Builder builder = new SetPullRequestMergeConfigRequest.Builder(repository).commitSummaries(config.getCommitSummaries()).defaultStrategyId(defaultStrategy.getId()).enabledStrategyIds(mergeStrategyIds);
            if (template != null) {
                if (template.isEmpty()) {
                    builder.commitMessageTemplate(null);
                } else {
                    builder.commitMessageTemplate((PullRequestCommitMessageTemplate)template);
                }
            }
            this.pullRequestService.setMergeConfig(builder.build());
        }
    }
}

