/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.watcher.UnwatchRequest;
import com.atlassian.bitbucket.watcher.WatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/watch")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositoryWatchResource {
    private final WatcherService watcherService;

    @Inject
    public RepositoryWatchResource(WatcherService watcherService) {
        this.watcherService = watcherService;
    }

    @Operation(description="Remove the authenticated user as a watcher for the specified repository. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository to call this resource.", summary="Stop watching repository")
    @ResponseDocs(value={@ResponseDoc(documentation="The user is no longer watching the repository.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response unwatch(@BeanParam RepositoryResolver repositoryResolver) {
        this.watcherService.unwatch(new UnwatchRequest.Builder((Watchable)repositoryResolver.getRepository()).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Add the authenticated user as a watcher for the specified repository. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository to call this resource.", summary="Watch repository")
    @Parameters(value={@Parameter(description="The repository slug.", in=ParameterIn.PATH, name="repositorySlug")})
    @RequestBody(description="The repository to watch.", content={@Content(schema=@Schema(implementation=RestRepository.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The user is now watching the repository.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response watch(@BeanParam RepositoryResolver repositoryResolver) {
        this.watcherService.watch(new WatchRequest.Builder((Watchable)repositoryResolver.getRepository()).build());
        return ResponseFactory.noContent().build();
    }
}

