/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.webhook.WebhookScopeAdapter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.stash.internal.rest.OptionalServiceRegistry;
import com.atlassian.stash.internal.rest.webhook.RestWebhooksResourceHelper;
import com.atlassian.stash.internal.rest.webhook.SimpleWebhooksResponseBuilder;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.internal.rest.RestWebhook;
import com.atlassian.webhooks.internal.rest.RestWebhookCredentials;
import com.atlassian.webhooks.internal.rest.RestWebhookRequestResponse;
import com.atlassian.webhooks.internal.rest.WebhooksResourceHelper;
import com.atlassian.webhooks.internal.rest.history.RestDetailedInvocation;
import com.atlassian.webhooks.internal.rest.history.RestInvocationHistory;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/webhooks")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositoryWebhooksResource {
    private final RestWebhooksResourceHelper restWebhooksResourceHelper;
    private final WebhooksResourceHelper webhookResourceHelper;

    @Inject
    public RepositoryWebhooksResource(I18nResolver i18nResolver, OptionalServiceRegistry optionalServiceRegistry, RestWebhooksResourceHelper restWebhooksResourceHelper) {
        this.restWebhooksResourceHelper = restWebhooksResourceHelper;
        this.webhookResourceHelper = new WebhooksResourceHelper(i18nResolver, new SimpleWebhooksResponseBuilder(), optionalServiceRegistry::getInvocationHistoryServiceOrThrow, optionalServiceRegistry::getWebhookServiceOrThrow, restWebhooksResourceHelper::validateScopeAdmin);
    }

    @Operation(description="Create a webhook for the repository specified via the URL. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Create webhook")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestWebhook.class))}, description="The webhook to be created for this repository.")
    @ResponseDocs(value={@ResponseDoc(documentation="A created webhook.", representation=RestWebhook.class, responseCode=200), @ResponseDoc(documentation="The webhook parameters were invalid or not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create webhooks in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createWebhook(@Context UriInfo uriInfo, @BeanParam ScopeResolver scopeResolver, RestWebhook webhook) {
        String webhookUrl = webhook.getUrl();
        if (webhookUrl != null) {
            this.restWebhooksResourceHelper.validateWebhookUrl(webhook.getEvents(), webhookUrl);
        }
        return this.webhookResourceHelper.createWebhook(uriInfo, WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), webhook);
    }

    @Operation(description="Delete a webhook for the repository specified via the URL. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Delete webhook")
    @Parameters(value={@Parameter(description="The ID of the webhook to be deleted.", in=ParameterIn.PATH, name="webhookId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The webhook for the repository has been deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete webhooks in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist, or webhook does not exist in this repository.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{webhookId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteWebhook(@BeanParam ScopeResolver scopeResolver, @PathParam(value="webhookId") int webhookId) {
        return this.webhookResourceHelper.deleteWebhook(WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), webhookId);
    }

    @Operation(description="Find webhooks in this repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Find webhooks")
    @Parameters(value={@Parameter(description="List of <code>com.atlassian.webhooks.WebhookEvent</code> IDs to filter for", in=ParameterIn.QUERY, name="event"), @Parameter(description="<code>true</code> if statistics should be provided for all found webhooks", in=ParameterIn.QUERY, name="statistics", schema=@Schema(type="boolean"))})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of webhooks.", paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to find webhooks in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findWebhooks(@Context UriInfo uriInfo, @BeanParam ScopeResolver scopeResolver, @QueryParam(value="event") List<String> events, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.webhookResourceHelper.findWebhooks(uriInfo, WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), events, statistics, pageRequestResolver.getPageRequest().getStart(), pageRequestResolver.getPageRequest().getLimit());
    }

    @Operation(description="Get the latest invocations for a specific webhook. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Get last webhook invocation details")
    @Parameters(value={@Parameter(description="ID of the webhook", in=ParameterIn.PATH, name="webhookId"), @Parameter(description="The string ID of a specific event to retrieve the last invocation for.", in=ParameterIn.QUERY, name="event"), @Parameter(description="The outcome to filter for. Can be SUCCESS, FAILURE, ERROR. None specified means that the all will be considered", in=ParameterIn.QUERY, name="outcome")})
    @ResponseDocs(value={@ResponseDoc(documentation="A webhook invocation dataset.", representation=RestDetailedInvocation.class, responseCode=200), @ResponseDoc(documentation="No webhook invocations exist.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to get webhook invocations in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist, or the webhook does not exist in the repository.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}/latest")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getLatestInvocation(@BeanParam ScopeResolver scopeResolver, @PathParam(value="webhookId") int webhookId, @QueryParam(value="event") String eventId, @QueryParam(value="outcome") Set<String> outcomes) {
        return this.webhookResourceHelper.getLatestInvocation(WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), webhookId, eventId, outcomes);
    }

    @Operation(description="Get the statistics for a specific webhook. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Get webhook statistics")
    @Parameters(value={@Parameter(description="ID of the webhook", in=ParameterIn.PATH, name="webhookId"), @Parameter(description="The string ID of a specific event to retrieve the last invocation for. May be empty, in which case all events are considered", in=ParameterIn.QUERY, name="event")})
    @ResponseDocs(value={@ResponseDoc(documentation="A webhook invocation dataset.", representation=RestInvocationHistory.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to get webhook statistics in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist, or the webhook does not exist in the repository.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}/statistics")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getStatistics(@BeanParam ScopeResolver scopeResolver, @PathParam(value="webhookId") int webhookId, @QueryParam(value="event") String eventId) {
        return this.webhookResourceHelper.getStatistics(WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), webhookId, eventId);
    }

    @Operation(description="Get the statistics summary for a specific webhook. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Get webhook statistics summary")
    @Parameters(value={@Parameter(description="ID of the webhook", in=ParameterIn.PATH, name="webhookId")})
    @ResponseDocs(value={@ResponseDoc(documentation="A webhook invocation dataset.", representation=RestInvocationHistory.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to get webhook statistics summary in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist, or the webhook does not exist in the repository.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}/statistics/summary")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getStatisticsSummary(@BeanParam ScopeResolver scopeResolver, @PathParam(value="webhookId") int webhookId) {
        return this.webhookResourceHelper.getStatisticsSummary(WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), webhookId);
    }

    @Operation(description="Get a webhook by ID. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Get webhook")
    @Parameters(value={@Parameter(description="ID of the webhook", in=ParameterIn.PATH, name="webhookId"), @Parameter(description="<code>true</code> if statistics should be provided for the webhook", in=ParameterIn.QUERY, name="statistics")})
    @ResponseDocs(value={@ResponseDoc(documentation="A webhook.", representation=RestWebhook.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to get a webhook in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist, or the webhook does not exist in the repository.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getWebhook(@BeanParam ScopeResolver scopeResolver, @PathParam(value="webhookId") int webhookId, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics) {
        return this.webhookResourceHelper.getWebhook(WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), webhookId, statistics);
    }

    @Operation(description="Search webhooks in this repository and parent project. This endpoint returns a superset of the results returned by the /webhooks endpoint because it allows filtering by project scope too, not just repository webhooks.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Search webhooks")
    @Parameters(value={@Parameter(description="List of <code>com.atlassian.webhooks.WebhookEvent</code> ids to filter for", in=ParameterIn.QUERY, name="event"), @Parameter(description="Scopes to filter by. This parameter can be specified once e.g. \"scopeType=repository\", or twice e.g. \"scopeType=repository&scopeType=project\", to filter by more than one scope level. ", in=ParameterIn.QUERY, name="scopeType"), @Parameter(description="<code>true</code> if statistics should be provided for all found webhooks", in=ParameterIn.QUERY, name="statistics", schema=@Schema(type="boolean"))})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of webhooks.", paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to find webhooks in the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="search")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchWebhooks(@Context UriInfo uriInfo, @BeanParam ScopeResolver scopeResolver, @QueryParam(value="event") List<String> events, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics, @QueryParam(value="scopeType") List<String> scopeTypes, @BeanParam PageRequestResolver pageRequestResolver) {
        this.restWebhooksResourceHelper.validateScopeTypes(scopeTypes);
        WebhookScope repositoryWebhookScope = WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope());
        WebhookScopeAdapter repositoryWebhookScopeAdapter = (WebhookScopeAdapter)WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope());
        List inheritedScopes = repositoryWebhookScopeAdapter.getInheritedWebhookScopes();
        ImmutableList.Builder webhookScopesBuilder = ImmutableList.builder();
        if (scopeTypes.isEmpty()) {
            webhookScopesBuilder.add((Object)repositoryWebhookScope).addAll((Iterable)inheritedScopes);
        } else {
            if (scopeTypes.contains(repositoryWebhookScope.getType())) {
                webhookScopesBuilder.add((Object)repositoryWebhookScope);
            }
            webhookScopesBuilder.addAll((Iterable)inheritedScopes.stream().filter(webhookScope -> scopeTypes.contains(webhookScope.getType())).collect(Collectors.toList()));
        }
        return this.webhookResourceHelper.findWebhooks(uriInfo, repositoryWebhookScope, (List<WebhookScope>)webhookScopesBuilder.build(), events, statistics, pageRequestResolver.getPageRequest().getStart(), pageRequestResolver.getPageRequest().getLimit());
    }

    @Operation(description="Test connectivity to a specific endpoint. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Test webhook")
    @Parameters(value={@Parameter(description="The url in which to connect to", in=ParameterIn.QUERY, name="url"), @Parameter(description="Whether SSL verification is required for the specified webhook URL. Default value is  <code>true</code>.", in=ParameterIn.QUERY, name="sslVerificationRequired")})
    @RequestBody(description="Basic authentication credentials, if required.", content={@Content(schema=@Schema(implementation=RestWebhookCredentials.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="A webhook.", representation=RestWebhookRequestResponse.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to test a connection.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="/test")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response testWebhook(@BeanParam ScopeResolver scopeResolver, @QueryParam(value="url") String url, @QueryParam(value="sslVerificationRequired") @DefaultValue(value="true") boolean sslVerificationRequired, @QueryParam(value="webhookId") Integer webhookId, RestWebhookCredentials credentials) {
        return this.webhookResourceHelper.testWebhook(WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), url, sslVerificationRequired, webhookId, credentials.getUsername(), credentials.getPassword());
    }

    @Operation(description="Update an existing webhook. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Update webhook")
    @Parameters(value={@Parameter(description="Id of the existing webhook", in=ParameterIn.PATH, name="webhookId")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestWebhook.class))}, description="The representation of the updated values for the webhook")
    @ResponseDocs(value={@ResponseDoc(documentation="A webhook.", representation=RestWebhook.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update a webhook in this repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist, or the webhook does not exist in the repository.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{webhookId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateWebhook(@BeanParam ScopeResolver scopeResolver, @PathParam(value="webhookId") int webhookId, RestWebhook webhook) {
        String webhookUrl = webhook.getUrl();
        if (webhookUrl != null) {
            this.restWebhooksResourceHelper.validateWebhookUrl(webhook.getEvents(), webhookUrl);
        }
        return this.webhookResourceHelper.update(WebhookScopeAdapter.adapt((Scope)scopeResolver.getScope()), webhookId, webhook);
    }
}

