/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.repository.CreateTagRequest;
import com.atlassian.bitbucket.repository.RefOrder;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.RepositoryTagsRequest;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.v2.api.repository.RestTag;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.repository.AbstractRepositoryRefResource;
import com.atlassian.stash.internal.rest.repository.RestCreateTagRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/tags")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Singleton
@Tag(name="Repository")
public class TagResource
extends AbstractRepositoryRefResource {
    @Inject
    public TagResource(RefService refService) {
        super(refService);
    }

    @Operation(description="Retrieve the tags matching the supplied <strong>filterText</strong> param. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the context repository to call this resource.", summary="Find tag")
    @Parameters(value={@Parameter(description="The text to match on.", in=ParameterIn.QUERY, name="filterText"), @Parameter(description="Ordering of refs either ALPHABETICAL (by name) or MODIFICATION (last updated)", in=ParameterIn.QUERY, name="orderBy")})
    @ResponseDocs(value={@ResponseDoc(documentation="The tags matching the supplied <strong>filterText</strong>.", paged=true, representation=RestTag.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getTags(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="filterText") String filterText, @QueryParam(value="orderBy") String orderBy) {
        return this.process(repositoryResolver.getRepository(), (repository, refService) -> {
            Page tags = refService.getTags(((RepositoryTagsRequest.Builder)((RepositoryTagsRequest.Builder)new RepositoryTagsRequest.Builder(repository).filterText(filterText)).order(RefOrder.fromValueOrNull((String)orderBy))).build(), pageRequestResolver.getPageRequest());
            return new RestPage(tags, RestMinimalRef.REST_TRANSFORM);
        });
    }

    @Operation(description="Retrieve a tag in the specified repository. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the context repository to call this resource.", summary="Get tag")
    @Parameters(value={@Parameter(description="The name of the tag to be retrieved.", in=ParameterIn.PATH, name="name")})
    @ResponseDocs(value={@ResponseDoc(documentation="The tag which matches the supplied <strong>name</strong>.", representation=RestTag.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to read the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified tag does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{name:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getTag(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="name") String name) {
        return this.process(repositoryResolver.getRepository(), (repository, refService) -> {
            ResolveRefRequest request = new ResolveRefRequest.Builder(repository).refId(name).type((RefType)StandardRefType.TAG).build();
            return RestMinimalRef.REST_TRANSFORM.apply(refService.resolveRef(request));
        });
    }

    @Operation(description="Creates a tag using the information provided in the RestCreateTagRequest request \n\nThe authenticated user must have <strong>REPO_WRITE</strong> permission for the context repository to call this resource.", summary="Create tag")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestCreateTagRequest.class))}, description="The request to create a tag containing a <strong>name</strong>, <strong>startPoint</strong>, and optionally a <strong>message</strong>")
    @ResponseDocs(value={@ResponseDoc(documentation="The created tag.", representation=RestTag.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to write to the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createTagForRepository(@BeanParam RepositoryResolver repositoryResolver, RestCreateTagRequest restRequest) {
        return this.process(repositoryResolver.getRepository(), (repo, refService) -> new RestTag(refService.createTag(((CreateTagRequest.Builder)new CreateTagRequest.Builder(repo, restRequest.getName(), restRequest.getStartPoint()).message(restRequest.getMessage())).build())));
    }
}

