/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.secretscanning;

import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningAllowlistRule;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningAllowlistRuleSetRequest;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningRule;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRule;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRuleService;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningAllowlistRuleSearchRequest;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningAllowlistSetRequest;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningRuleOrder;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.NotFoundException;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSecretScanningAllowlistRuleResource {
    protected static final String PARAM_FILTER = "filter";
    protected static final String PARAM_ID = "id";
    protected static final String PARAM_ORDER = "order";
    protected static final String PATH_ID = "{id}";
    private final I18nService i18nService;
    private final DmzSecretScanningAllowlistRuleService secretScanningAllowlistService;

    public AbstractSecretScanningAllowlistRuleResource(I18nService i18nService, DmzSecretScanningAllowlistRuleService secretScanningAllowlistService) {
        this.i18nService = i18nService;
        this.secretScanningAllowlistService = secretScanningAllowlistService;
    }

    public Response createAllowlist(RestSecretScanningAllowlistRuleSetRequest request, Scope scope) {
        SecretScanningAllowlistSetRequest createRequest = new SecretScanningAllowlistSetRequest.Builder().name(request.getName()).lineRegex(request.getLineRegex()).pathRegex(request.getPathRegex()).build();
        DmzSecretScanningAllowlistRule result = this.secretScanningAllowlistService.create(createRequest, scope);
        return ResponseFactory.ok((Object)new RestSecretScanningRule((DmzSecretScanningRule)result)).build();
    }

    public Response deleteBy(long id, Scope scope) {
        this.secretScanningAllowlistService.deleteRuleById(id, scope);
        return ResponseFactory.noContent().build();
    }

    public Response editAllowlistRule(long id, RestSecretScanningAllowlistRuleSetRequest request, Scope scope) {
        DmzSecretScanningAllowlistRule result = this.secretScanningAllowlistService.update(new SecretScanningAllowlistSetRequest.Builder().id(Long.valueOf(id)).name(request.getName()).lineRegex(request.getLineRegex()).pathRegex(request.getPathRegex()).build(), scope);
        return ResponseFactory.ok((Object)new RestSecretScanningAllowlistRule((DmzSecretScanningRule)result)).build();
    }

    public Response getAllowlistRuleById(long id, Scope scope) {
        RestSecretScanningAllowlistRule rule = this.secretScanningAllowlistService.getRuleById(id, scope).map(RestSecretScanningAllowlistRule::new).orElseThrow(() -> new NotFoundException(this.i18nService.getMessage("bitbucket.rest.secretscanning.error.rulenotfound", new Object[]{String.valueOf(id)})));
        return ResponseFactory.ok((Object)rule).build();
    }

    public Response search(String filter, String order, Scope scope, PageRequest pageRequest) {
        SecretScanningAllowlistRuleSearchRequest searchRequest = new SecretScanningAllowlistRuleSearchRequest.Builder().order(this.resolveOrder(order)).filterText(filter).build();
        Page rules = this.secretScanningAllowlistService.search(pageRequest, scope, searchRequest);
        return ResponseFactory.ok((Object)new RestPage(rules, RestSecretScanningRule::new)).build();
    }

    @Nullable
    private SecretScanningRuleOrder resolveOrder(String order) {
        if (StringUtils.isBlank((CharSequence)order)) {
            return null;
        }
        return (SecretScanningRuleOrder)SecretScanningRuleOrder.fromLabel((String)order).orElseThrow(() -> new BadRequestException(PARAM_ORDER, this.i18nService.getMessage("bitbucket.rest.secretscanning.error.invalidorder", new Object[]{Arrays.asList(SecretScanningRuleOrder.values())})));
    }
}

