/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.secretscanning;

import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningRule;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningRuleSetRequest;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRuleService;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningRuleOrder;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningRuleSearchRequest;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningRuleSetRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.NotFoundException;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSecretScanningRulesResource {
    protected static final String PARAM_FILTER = "filter";
    protected static final String PARAM_ID = "id";
    protected static final String PARAM_ORDER = "order";
    protected static final String PATH_ID = "{id}";
    private final I18nService i18nService;
    private final DmzSecretScanningRuleService secretScanningRuleService;

    public AbstractSecretScanningRulesResource(I18nService i18nService, DmzSecretScanningRuleService secretScanningRuleService) {
        this.i18nService = i18nService;
        this.secretScanningRuleService = secretScanningRuleService;
    }

    public Response createRule(RestSecretScanningRuleSetRequest request, Scope scope) {
        SecretScanningRuleSetRequest createRequest = new SecretScanningRuleSetRequest.Builder().name(request.getName()).lineRegex(request.getLineRegex()).pathRegex(request.getPathRegex()).build();
        DmzSecretScanningRule result = this.secretScanningRuleService.create(createRequest, scope);
        return ResponseFactory.ok((Object)new RestSecretScanningRule(result)).build();
    }

    public Response deleteBy(long id, Scope scope) {
        this.secretScanningRuleService.deleteRuleById(id, scope);
        return ResponseFactory.noContent().build();
    }

    public Response editRule(long id, RestSecretScanningRuleSetRequest request, Scope scope) {
        DmzSecretScanningRule result = this.secretScanningRuleService.update(new SecretScanningRuleSetRequest.Builder().id(Long.valueOf(id)).name(request.getName()).lineRegex(request.getLineRegex()).pathRegex(request.getPathRegex()).build(), scope);
        return ResponseFactory.ok((Object)new RestSecretScanningRule(result)).build();
    }

    public Response getRuleById(long id, Scope scope) {
        RestSecretScanningRule rule = this.secretScanningRuleService.getRuleById(id, scope).map(RestSecretScanningRule::new).orElseThrow(() -> new NotFoundException(this.i18nService.getMessage("bitbucket.rest.secretscanning.error.rulenotfound", new Object[]{String.valueOf(id)})));
        return ResponseFactory.ok((Object)rule).build();
    }

    public Response search(String filter, String order, Scope scope, PageRequest pageRequest) {
        SecretScanningRuleSearchRequest searchRequest = new SecretScanningRuleSearchRequest.Builder().order(this.resolveOrder(order)).filterText(filter).build();
        Page rules = this.secretScanningRuleService.search(pageRequest, scope, searchRequest);
        return ResponseFactory.ok((Object)new RestPage(rules, RestSecretScanningRule::new)).build();
    }

    @Nullable
    private SecretScanningRuleOrder resolveOrder(String order) {
        if (StringUtils.isBlank((CharSequence)order)) {
            return null;
        }
        return (SecretScanningRuleOrder)SecretScanningRuleOrder.fromLabel((String)order).orElseThrow(() -> new BadRequestException(PARAM_ORDER, this.i18nService.getMessage("bitbucket.rest.secretscanning.error.invalidorder", new Object[]{Arrays.asList(SecretScanningRuleOrder.values())})));
    }
}

