/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.secretscanning;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestRepositorySelector;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningExemptRepositoryOrder;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.secretscanning.RestSecretScanningExemptRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Path(value="projects/{projectKey}/secret-scanning/exempt")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Security")
public class ProjectExemptRepositoryResource {
    private final DmzSecretScanningExemptRepositoryService exemptRepositoryService;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;

    @Inject
    public ProjectExemptRepositoryResource(DmzSecretScanningExemptRepositoryService exemptRepositoryService, I18nService i18nService, RepositoryService repositoryService) {
        this.exemptRepositoryService = exemptRepositoryService;
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Bulk exempt a  list of repositories from being scanned for secrets. User must be have **PROJECT ADMIN** permissions.", summary="Bulk exempt repos from secret scanning")
    @ResponseDocs(value={@ResponseDoc(documentation="All requested repositories were made exempt", responseCode=204), @ResponseDoc(documentation="The authenticated user is not permitted to exempt a repository from secret scanning. No repositories were made exempt.", restError=true, responseCode=401)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response bulkAddExemptRepositories(@BeanParam ProjectResolver projectResolver, Set<RestRepositorySelector> selectors) {
        List repositories = selectors.stream().map(selector -> this.repositoryService.getBySlug(selector.getProjectKey(), selector.getSlug())).collect(Collectors.toList());
        this.exemptRepositoryService.add(repositories, (Scope)Scopes.project((Project)projectResolver.getProject()));
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Find repositories exempt from secret scanning in a project", summary="Find repos exempt from secret scanning for a project")
    @Parameters(value={@Parameter(description="Order by project name followed by repository name either ascending or descending, defaults to ascending.", in=ParameterIn.QUERY, name="order", schema=@Schema(implementation=SecretScanningExemptRepositoryOrder.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Page of repositories", representation=RestRepository.class, paged=true, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to search exempt repositories for this project", restError=true, responseCode=401)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findExemptReposByProject(@BeanParam ProjectResolver projectResolver, @QueryParam(value="order") String order, @BeanParam PageRequestResolver pageRequestResolver) {
        Page exemptRepos = this.exemptRepositoryService.findByScope((Scope)Scopes.project((Project)projectResolver.getProject()), this.resolveOrder(order), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(exemptRepos, RestSecretScanningExemptRepository::new)).build();
    }

    private SecretScanningExemptRepositoryOrder resolveOrder(String order) {
        if (StringUtils.isBlank((CharSequence)order)) {
            return SecretScanningExemptRepositoryOrder.NAME_ASC;
        }
        return (SecretScanningExemptRepositoryOrder)SecretScanningExemptRepositoryOrder.fromLabel((String)order).orElseThrow(() -> new BadRequestException("order", this.i18nService.getMessage("bitbucket.rest.secretscanning.error.invalidorder", new Object[]{Arrays.asList(SecretScanningExemptRepositoryOrder.values())})));
    }
}

