/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.secretscanning;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningAllowlistRule;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningAllowlistRuleSetRequest;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRuleService;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningRuleOrder;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.secretscanning.AbstractSecretScanningAllowlistRuleResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Path(value="projects/{projectKey}/secret-scanning/allowlist")
@Produces(value={"application/json;charset=UTF-8"})
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key.")})
@Singleton
@Tag(name="Security")
public class ProjectSecretScanningAllowlistRuleResource
extends AbstractSecretScanningAllowlistRuleResource {
    @Inject
    public ProjectSecretScanningAllowlistRuleResource(I18nService i18nService, DmzSecretScanningAllowlistRuleService secretScanningAllowlistService) {
        super(i18nService, secretScanningAllowlistService);
    }

    @Operation(description="Create a new project level secret scanning allowlist rule. Project allowlist rules are used when scanning all non exempt repositories in the provided project.\n\nProject **Admin** is required", summary="Create project secret scanning allowlist rule")
    @RequestBody(description="Allowlist rule to create, either the line regular expression or the path regular expression must be present", content={@Content(schema=@Schema(implementation=RestSecretScanningAllowlistRuleSetRequest.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The created allowlist rule", representation=RestSecretScanningAllowlistRule.class, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to create project allowlist rules.", restError=true, responseCode=401), @ResponseDoc(documentation="The request did not contain a correctly formed allowlist rule. See returned error for more details", restError=true, responseCode=400)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createAllowlistRule(@BeanParam ProjectResolver projectResolver, RestSecretScanningAllowlistRuleSetRequest request) {
        return this.createAllowlist(request, (Scope)Scopes.project((Project)projectResolver.getProject()));
    }

    @Operation(description="Delete a project secret scanning allowlist rule with the provided ID.\n\nProject **Admin** is required", summary="Delete a project secret scanning allowlist rule")
    @Parameters(value={@Parameter(description="The allowlist rule id.", in=ParameterIn.PATH, name="id", example="7")})
    @ResponseDocs(value={@ResponseDoc(documentation="Empty response indicating that the rule was deleted, or not found at this location", responseCode=204), @ResponseDoc(documentation="The authenticated user is not permitted to delete project rules", restError=true, responseCode=401)})
    @DELETE
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteAllowlistRule(@BeanParam ProjectResolver projectResolver, @PathParam(value="id") long id) {
        return this.deleteBy(id, (Scope)Scopes.project((Project)projectResolver.getProject()));
    }

    @Operation(description="Edit a project secret scanning allowlist rule.\n\nProject **Admin** is required", summary="Edit an existing project secret scanning allowlist rule")
    @Parameters(value={@Parameter(description="The allowlist rule id.", in=ParameterIn.PATH, name="id", example="7")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestSecretScanningAllowlistRuleSetRequest.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The updated allowlist rule", representation=RestSecretScanningAllowlistRule.class, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to modify project allowlist rules", restError=true, responseCode=401), @ResponseDoc(documentation="The request did not contain a correctly formed allowlist rule. See returned error for more details", restError=true, responseCode=400)})
    @PUT
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response editAllowlistRule(@BeanParam ProjectResolver projectResolver, @PathParam(value="id") long id, RestSecretScanningAllowlistRuleSetRequest request) {
        return this.editAllowlistRule(id, request, (Scope)Scopes.project((Project)projectResolver.getProject()));
    }

    @Operation(description="Get a project secret scanning allowlist rule by ID.\n\nProject **Admin** is required", summary="Get a project secret scanning allowlist rule")
    @Parameters(value={@Parameter(description="The allowlist rule id.", in=ParameterIn.PATH, name="id", example="7")})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested allowlist rule", representation=RestSecretScanningAllowlistRule.class, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to view project allowlist rules", restError=true, responseCode=401), @ResponseDoc(documentation="The requested allowlist rules was not found", restError=true, responseCode=404)})
    @GET
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllowlistRule(@BeanParam ProjectResolver projectResolver, @PathParam(value="id") long id) {
        return this.getAllowlistRuleById(id, (Scope)Scopes.project((Project)projectResolver.getProject()));
    }

    @Operation(description="Find project secret scanning allowlist rules by filtering.\n\nProject **Admin** is required", summary="Find project secret scanning allowlist rules")
    @Parameters(value={@Parameter(description="Filter names by the provided text", in=ParameterIn.QUERY, name="filter", example="Access"), @Parameter(description="Order by", in=ParameterIn.QUERY, name="order", schema=@Schema(implementation=SecretScanningRuleOrder.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Page of allowlist rules", representation=RestSecretScanningAllowlistRule.class, paged=true, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to view project allowlist rules", restError=true, responseCode=401), @ResponseDoc(documentation="The request was not correctly formed allowlist rule. See returned error for more details", restError=true, responseCode=400)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchAllowlistRule(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filter") String filter, @QueryParam(value="order") String order, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.search(filter, order, (Scope)Scopes.project((Project)projectResolver.getProject()), pageRequestResolver.getPageRequest());
    }
}

