/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.secretscanning;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepository;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepositoryService;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningExemptRepositoryOrder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Path(value="projects/{projectKey}/repos/{repositorySlug}/secret-scanning/exempt")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Security")
public class RepositoryExemptRepositoryResource {
    public final DmzSecretScanningExemptRepositoryService exemptRepositoryService;
    private final WebSudoManager webSudoManager;

    @Inject
    public RepositoryExemptRepositoryResource(DmzSecretScanningExemptRepositoryService exemptRepositoryService, WebSudoManager webSudoManager) {
        this.exemptRepositoryService = exemptRepositoryService;
        this.webSudoManager = webSudoManager;
    }

    @Deprecated
    @Operation(description="Exempt a repository from being scanned for secrets \n\n<strong>Deprecated since 8.6</strong>. Exemptions are now managed by scope. \nUse POST /rest/api/1.0/secret-scanning/exempt for global scope \nUse POST /rest/api/1.0/projects/{projectKey}/secret-scanning/exempt for the project scope", deprecated=true, summary="Exempt a repo from secret scanning")
    @ResponseDocs(value={@ResponseDoc(documentation="An exempt repo was added", responseCode=204), @ResponseDoc(documentation="The authenticated user is not permitted to exempt a repository from secret scanning", restError=true, responseCode=401), @ResponseDoc(documentation="At least one of specified repositories have already been previously made exempt.", restError=true, responseCode=409)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addExemptRepo(@BeanParam RepositoryResolver repositoryResolver) {
        Repository repository = repositoryResolver.getRepository();
        this.exemptRepositoryService.add(repository, (Scope)Scopes.project((Project)repository.getProject()));
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Remove a repository from being exempt from secret scanning", summary="Delete an exempt repository")
    @ResponseDocs(value={@ResponseDoc(documentation="Empty response indicating that the exempt repository was deleted", responseCode=204), @ResponseDoc(documentation="The authenticated user is not permitted to delete an exempt repository", restError=true, responseCode=401)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteExemptRepo(@BeanParam RepositoryResolver repositoryResolver, @Context HttpServletRequest request) {
        Repository repository = repositoryResolver.getRepository();
        this.enforceWebSudoForGlobalScopedExemption(repository, request);
        this.exemptRepositoryService.delete(repository);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Check whether a repository is exempt from secret scanning", summary="Get whether a repository is exempt")
    @ResponseDocs(value={@ResponseDoc(documentation="True if the repository is exempt from secret scanning, false otherwise", responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to check whether a repository is exempt from secret scanning", restError=true, responseCode=401)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response isRepoExempt(@BeanParam RepositoryResolver repositoryResolver) {
        ImmutableMap isExempt = ImmutableMap.of((Object)"isExempt", (Object)this.exemptRepositoryService.isExempt(repositoryResolver.getRepository()));
        return ResponseFactory.ok((Object)isExempt).build();
    }

    private void enforceWebSudoForGlobalScopedExemption(Repository repository, final HttpServletRequest request) {
        PageUtils.toStream(pageRequest -> this.exemptRepositoryService.findByScope((Scope)Scopes.repository((Repository)repository), SecretScanningExemptRepositoryOrder.NAME_ASC, pageRequest), (int)1).findFirst().map(DmzSecretScanningExemptRepository::getScope).ifPresent(scope -> scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope scope) {
                RepositoryExemptRepositoryResource.this.webSudoManager.willExecuteWebSudoRequest(request);
                return null;
            }
        }));
    }
}

