/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.secretscanning;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningRule;
import com.atlassian.bitbucket.dmz.rest.v2.secretscanning.RestSecretScanningRuleSetRequest;
import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRuleService;
import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningRuleOrder;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.secretscanning.AbstractSecretScanningRulesResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Path(value="secret-scanning/rules")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Security")
@WebSudoRequired
public class SecretScanningRulesResource
extends AbstractSecretScanningRulesResource {
    @Inject
    public SecretScanningRulesResource(I18nService i18nService, DmzSecretScanningRuleService secretScanningRuleService) {
        super(i18nService, secretScanningRuleService);
    }

    @Operation(description="Create a new global secret scanning rule. Global rules are used when scanning all non exempt repositories.", summary="Create global secret scanning rule")
    @RequestBody(description="Rule to create, either the line regular expression or the path regular expression must be present", content={@Content(schema=@Schema(implementation=RestSecretScanningRuleSetRequest.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The created rule", representation=RestSecretScanningRule.class, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to create global rules", restError=true, responseCode=401), @ResponseDoc(documentation="The request did not contain a correctly formed rule. See returned error for more details", restError=true, responseCode=400)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createRule(RestSecretScanningRuleSetRequest request) {
        return this.createRule(request, (Scope)Scopes.global());
    }

    @Operation(description="Delete a global secret scanning rule with the provided ID", summary="Delete a global secret scanning rule")
    @Parameters(value={@Parameter(description="The rule id.", in=ParameterIn.PATH, name="id", example="7")})
    @ResponseDocs(value={@ResponseDoc(documentation="Empty response indicating that the rule was deleted", responseCode=204), @ResponseDoc(documentation="The authenticated user is not permitted to delete global rules", restError=true, responseCode=401)})
    @DELETE
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteRule(@PathParam(value="id") long id) {
        return this.deleteBy(id, (Scope)Scopes.global());
    }

    @Operation(description="Edit an existing global secret scanning rule", summary="Edit a global secret scanning rule.")
    @Parameters(value={@Parameter(description="The rule id.", in=ParameterIn.PATH, name="id", example="7")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestSecretScanningRuleSetRequest.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The updated rule", representation=RestSecretScanningRule.class, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to update global rules", restError=true, responseCode=401), @ResponseDoc(documentation="The request did not contain a correctly formed rule. See returned error for more details", restError=true, responseCode=400)})
    @PUT
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response editRule(@PathParam(value="id") long id, RestSecretScanningRuleSetRequest request) {
        return super.editRule(id, request, (Scope)Scopes.global());
    }

    @Operation(description="Get a global secret scanning rule by ID.", summary="Get a global secret scanning rule")
    @Parameters(value={@Parameter(description="The rule id.", in=ParameterIn.PATH, name="id", example="7")})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested rule", representation=RestSecretScanningRule.class, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to get global rules", restError=true, responseCode=401), @ResponseDoc(documentation="The requested rule was not found", restError=true, responseCode=404)})
    @GET
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRule(@PathParam(value="id") long id) {
        return this.getRuleById(id, (Scope)Scopes.global());
    }

    @Operation(description="Find global secret scanning rules by filtering.", summary="Find global secret scanning rules")
    @Parameters(value={@Parameter(description="Filter by rule name", in=ParameterIn.QUERY, name="filter", example="Access"), @Parameter(description="Order by", in=ParameterIn.QUERY, name="order", schema=@Schema(implementation=SecretScanningRuleOrder.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Page of rules", representation=RestSecretScanningRule.class, paged=true, responseCode=200), @ResponseDoc(documentation="The authenticated user is not permitted to search global rules", restError=true, responseCode=401), @ResponseDoc(documentation="The request did not contain a correctly formed search request, see returned error for more details.", restError=true, responseCode=400)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response search(@QueryParam(value="filter") String filter, @QueryParam(value="order") String order, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.search(filter, order, (Scope)Scopes.global(), pageRequestResolver.getPageRequest());
    }
}

