/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.settingsrestriction;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.settingsrestriction.RestProjectSettingsRestriction;
import com.atlassian.bitbucket.dmz.rest.v2.settingsrestriction.RestProjectSettingsRestrictionRequest;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionCreateRequest;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.settingsrestriction.UnsupportedPersonalProjectException;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import java.util.stream.Collectors;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key.")})
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/settings-restriction")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Project")
public class ProjectSettingsRestrictionResource {
    private final I18nService i18nService;
    private final ProjectSettingsRestrictionService service;
    private final Validator validator;

    @Inject
    public ProjectSettingsRestrictionResource(I18nService i18nService, ProjectSettingsRestrictionService service, Validator validator) {
        this.i18nService = i18nService;
        this.service = service;
        this.validator = validator;
    }

    @Operation(description="Create a new project settings restriction for the given project.\n\nThe authenticated user must have **PROJECT_ADMIN** permission for the target project to create a settings restriction.", summary="Enforce project restriction")
    @RequestBody(description="The project settings restriction to create", content={@Content(schema=@Schema(implementation=RestProjectSettingsRestrictionRequest.class))}, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The settings restriction was successfully created", representation=RestProjectSettingsRestriction.class, responseCode=200), @ResponseDoc(documentation="The settings restriction was not created because the request was invalid. Possible issues include:\n\n- The namespace was not provided, or longer than 255 characters\n- The featureKey was not provided, or longer than 255 characters\n- The provided componentKey was fewer than 2 characters, or longer than 255 characters", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a settings restriction", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist", restError=true, responseCode=404), @ResponseDoc(documentation="A settings restriction with the same namespace, featureKey and componentKey already exists on this project", restError=true, responseCode=409)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response create(@BeanParam ProjectResolver projectResolver, RestProjectSettingsRestrictionRequest restRequest) {
        ValidationUtils.validate((Validator)this.validator, (Object)restRequest, (Class[])new Class[0]);
        try {
            ProjectSettingsRestrictionCreateRequest createRequest = new ProjectSettingsRestrictionCreateRequest.Builder(projectResolver.getProject(), ProjectSettingsRestrictionResource.getSettingsKey(restRequest)).build();
            return Response.ok((Object)new RestProjectSettingsRestriction(this.service.create(createRequest))).build();
        }
        catch (UnsupportedPersonalProjectException e) {
            KeyedMessage message = this.i18nService.getKeyedText(new I18nKey("bitbucket.service.settingsrestriction.personalproject.blocked", new Object[0]));
            throw new ArgumentValidationException(message, (Throwable)e);
        }
    }

    @Operation(description="Delete a specified project settings restriction.\n\nIf a restriction does not exist for the specified project, namespace, featureKey, and componentKey, the request will be ignored and a 204 response will be returned.\n\nThe authenticated user must have **PROJECT_ADMIN** permission for the target project to delete a settings restriction.", summary="Stop enforcing project restriction")
    @Parameters(value={@Parameter(description="A namespace used to identify the provider of the feature", in=ParameterIn.QUERY, name="namespace", required=true), @Parameter(description="A key to uniquely identify the feature within the provided namespace", in=ParameterIn.QUERY, name="featureKey", required=true), @Parameter(description="A key to uniquely identify individually restrictable subcomponents of a feature within the provided feature key and namespace", in=ParameterIn.QUERY, name="componentKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The specified settings restriction was successfully deleted or there were no existing restrictions that match the specified criteria.", responseCode=204), @ResponseDoc(documentation="The settings restriction was not deleted because the request was invalid. Possible issues include:\n\n- The namespace was not provided, or longer than 255 characters\n- The featureKey was not provided, or longer than 255 characters\n- The provided componentKey was fewer than 2 characters, or longer than 255 characters", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete a settings restriction", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist", restError=true, responseCode=404)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam ProjectResolver projectResolver, @QueryParam(value="namespace") String namespace, @QueryParam(value="featureKey") String featureKey, @QueryParam(value="componentKey") String componentKey) {
        RestProjectSettingsRestrictionRequest request = new RestProjectSettingsRestrictionRequest(namespace, featureKey, componentKey);
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        this.service.delete(projectResolver.getProject(), ProjectSettingsRestrictionResource.getSettingsKey(request));
        return Response.noContent().build();
    }

    @Operation(description="Get a specified project settings restriction for the given namespace, feature key and component key.\nNote that not providing the component key will **not** return restrictions for the namespace and feature key with a component key set.\n\nThe authenticated user must have **PROJECT_VIEW** permission for the target project to retrieve a settings restriction.", summary="Get enforcing project setting")
    @Parameters(value={@Parameter(description="The namespace used to identify the provider of the feature", in=ParameterIn.QUERY, name="namespace", required=true), @Parameter(description="The feature key to uniquely identify the feature within the provided namespace", in=ParameterIn.QUERY, name="featureKey", required=true), @Parameter(description="The component key to uniquely identify individually restrictable subcomponents of a feature within the provided feature key and namespace", in=ParameterIn.QUERY, name="componentKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The settings restriction associated with the provided namespace and feature key", representation=RestProjectSettingsRestriction.class, responseCode=200), @ResponseDoc(documentation="The settings restriction could not be retrieved because the provided parameters were invalid. Possible issues include:\n\n- The namespace was not provided, or longer than 255 characters\n- The featureKey was not provided, or longer than 255 characters\n- The provided componentKey was fewer than 2 characters, or longer than 255 characters", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve a settings restriction", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project, or settings restriction does not exist", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam ProjectResolver projectResolver, @QueryParam(value="namespace") String namespace, @QueryParam(value="featureKey") String featureKey, @QueryParam(value="componentKey") String componentKey) {
        RestProjectSettingsRestrictionRequest request = new RestProjectSettingsRestrictionRequest(namespace, featureKey, componentKey);
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        return this.service.get(projectResolver.getProject(), ProjectSettingsRestrictionResource.getSettingsKey(request)).map(restriction -> Response.ok((Object)new RestProjectSettingsRestriction(restriction)).build()).orElse(ResponseFactory.notFound().build());
    }

    @GET
    @Path(value="all")
    @Operation(description="Get all project settings restrictions for the given namespace and feature key, including those with a component key set.\n\nThe authenticated user must have **PROJECT_VIEW** permission for the target project to retrieve a settings restrictions.", summary="Get all enforcing project settings")
    @Parameters(value={@Parameter(description="A key to uniquely identify the feature within the provided namespace", in=ParameterIn.QUERY, name="featureKey", required=true), @Parameter(description="A namespace used to identify the provider of the feature", in=ParameterIn.QUERY, name="namespace", required=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of settings restrictions associated with the provided namespace and feature key", representation=RestProjectSettingsRestriction.class, paged=true, responseCode=200), @ResponseDoc(documentation="The settings restrictions could not be retrieved because the provided parameters were invalid. Possible issues include:\n\n- The namespace was not provided, or longer than 255 characters\n- The featureKey was not provided, or longer than 255 characters", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve project settings restrictions", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist", restError=true, responseCode=404)})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAll(@BeanParam ProjectResolver projectResolver, @QueryParam(value="namespace") String namespace, @QueryParam(value="featureKey") String featureKey) {
        RestProjectSettingsRestrictionRequest request = new RestProjectSettingsRestrictionRequest(namespace, featureKey);
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        Set all = this.service.getAll(projectResolver.getProject(), namespace, featureKey);
        RestPage page = new RestPage(0, all.size(), all.size(), true, (Iterable)all.stream().map(RestProjectSettingsRestriction::new).collect(Collectors.toSet()), null);
        return Response.ok((Object)page).build();
    }

    private static SettingsKey getSettingsKey(RestProjectSettingsRestrictionRequest request) {
        return new SettingsKey.Builder(request.getNamespace(), request.getFeatureKey()).componentKey(request.getComponentKey()).build();
    }
}

