/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.systemsigning;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.systemsigning.DmzSystemSigningService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.systemsigning.RestSystemSigningConfiguration;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="system-signing")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Security")
public class SystemSigningResource {
    private final I18nService i18nService;
    private final DmzSystemSigningService systemSigningService;

    @Inject
    public SystemSigningResource(I18nService i18nService, DmzSystemSigningService systemSigningService) {
        this.i18nService = i18nService;
        this.systemSigningService = systemSigningService;
    }

    @Operation(description="Gets the configuration details for system signing Git objects.", summary="Get system signing configuration")
    @ResponseDocs(value={@ResponseDoc(documentation="The configuration details for system signing Git objects", representation=RestSystemSigningConfiguration.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the configuration details for system signing Git objects.", restError=true, responseCode=401)})
    @GET
    @Path(value="configuration")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSystemSigningConfiguration() {
        RestSystemSigningConfiguration configuration = new RestSystemSigningConfiguration(this.systemSigningService.isSystemSignedGitObjectsEnabled());
        return Response.ok((Object)((Object)configuration)).build();
    }

    @Operation(description="Updates the configuration for system signing Git objects.", summary="Update system signing configuration")
    @ResponseDocs(value={@ResponseDoc(documentation="The updated configuration details for system signing Git objects", representation=RestSystemSigningConfiguration.class, responseCode=200), @ResponseDoc(documentation="The configuration details could not be updated because the provided request was invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the configuration details for system signing Git objects.", restError=true, responseCode=401)})
    @POST
    @Path(value="configuration")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateSystemSigningConfiguration(RestSystemSigningConfiguration configuration) {
        if (configuration.isEnabled() == null) {
            RestErrorMessage errorMessage = new RestErrorMessage("enabled", this.i18nService.getMessage("bitbucket.rest.systemsigning.configuration.invalidfield.enabled", new Object[0]));
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(Collections.singletonList(errorMessage))).build();
        }
        this.systemSigningService.setSystemSignedGitObjectsEnabled(Boolean.TRUE.equals(configuration.isEnabled()));
        RestSystemSigningConfiguration updatedConfiguration = new RestSystemSigningConfiguration(this.systemSigningService.isSystemSignedGitObjectsEnabled());
        return Response.ok((Object)((Object)updatedConfiguration)).build();
    }
}

