/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.dmz.user.PrincipalType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.NotFoundException;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPermissionResource {
    protected final I18nService i18nService;
    protected final DmzPermissionAdminService permissionAdminService;
    protected final UserService userService;

    public AbstractPermissionResource(I18nService i18nService, DmzPermissionAdminService permissionAdminService, UserService userService) {
        this.i18nService = i18nService;
        this.permissionAdminService = permissionAdminService;
        this.userService = userService;
    }

    protected Permission validatePermission(String permissionName, Class<?> resourceClass) {
        Permission permission;
        if (permissionName == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.missingpermission", new Object[0]);
            throw new BadRequestException(message);
        }
        try {
            permission = Permission.valueOf((String)permissionName.toUpperCase().replace('-', '_'));
        }
        catch (IllegalArgumentException e) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.invalidpermission", new Object[]{permissionName});
            throw new BadRequestException(message);
        }
        if (resourceClass != null && !permission.isResource(resourceClass)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.notapplicablewithresource", new Object[]{permission.name(), resourceClass});
            throw new BadRequestException(message);
        }
        if (resourceClass == null && !permission.isGlobal()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.notapplicablewithoutresource", new Object[]{permission.name()});
            throw new BadRequestException(message);
        }
        if (!permission.isGrantable()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.ungrantablepermission", new Object[]{permission.name()});
            throw new BadRequestException(message);
        }
        return permission;
    }

    protected String validateGroup(String groupName, boolean allowNonExistent) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.invalidgroup", new Object[0]);
            throw new BadRequestException(message);
        }
        if (!allowNonExistent && !this.userService.existsGroup(groupName)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.nosuchgroup", new Object[]{groupName});
            throw new NotFoundException(message);
        }
        return groupName;
    }

    protected Set<String> validateGroups(Set<String> groupNames) {
        return this.validateGroups(groupNames, false, false);
    }

    protected Set<String> validateGroups(Set<String> groupNames, boolean allowEmpty, boolean returnDeleted) {
        if (groupNames == null || groupNames.isEmpty()) {
            if (allowEmpty) {
                return Collections.emptySet();
            }
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.permission.no.groups", new Object[0]));
        }
        HashSet<String> groups = new HashSet<String>(groupNames.size());
        ArrayList<String> missing = new ArrayList<String>();
        for (String groupName : groupNames) {
            try {
                groups.add(this.validateGroup(groupName, returnDeleted));
            }
            catch (NotFoundException e) {
                missing.add(groupName);
            }
        }
        if (!missing.isEmpty()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.nosuchgroups", new Object[]{StringUtils.join(missing, (String)", ")});
            throw new NotFoundException(message);
        }
        return ImmutableSet.copyOf(groups);
    }

    protected Set<String> validateGroupsForRevocation(Set<String> groupNames) {
        return this.validateGroups(groupNames, true, true);
    }

    protected ApplicationUser validateUser(String username, boolean returnDeleted) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.invaliduser", new Object[0]);
            throw new BadRequestException(message);
        }
        ApplicationUser user = this.userService.getUserByName(username, returnDeleted);
        if (user == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.nosuchuser", new Object[]{username});
            throw new NotFoundException(message);
        }
        return user;
    }

    protected Set<ApplicationUser> validateUsers(Set<String> usernames) {
        return this.validateUsers(usernames, false, false);
    }

    protected Set<ApplicationUser> validateUsers(Set<String> usernames, boolean allowEmpty, boolean returnDeleted) {
        if (usernames == null || usernames.isEmpty()) {
            if (allowEmpty) {
                return Collections.emptySet();
            }
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.permission.no.users", new Object[0]));
        }
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>(usernames.size());
        ArrayList<String> missing = new ArrayList<String>();
        for (String username : usernames) {
            try {
                users.add(this.validateUser(username, returnDeleted));
            }
            catch (NotFoundException e) {
                missing.add(username);
            }
        }
        if (!missing.isEmpty()) {
            throw new NotFoundException(this.i18nService.getMessage("bitbucket.rest.permission.nosuchusers", new Object[]{StringUtils.join(missing, (String)", ")}));
        }
        return ImmutableSet.copyOf(users);
    }

    protected Set<ApplicationUser> validateUsersForRevocation(Set<String> usernames) {
        return this.validateUsers(usernames, true, true);
    }

    protected Set<Permission> parsePermissions(Set<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return Collections.emptySet();
        }
        return permissions.stream().map(this::parsePermission).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected PrincipalType parseType(String type) {
        String result = StringUtils.trimToNull((String)type);
        if (result == null) {
            return null;
        }
        try {
            return PrincipalType.valueOf((String)result.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.permission.invalidtype", new Object[]{type}));
        }
    }

    private Permission parsePermission(String permission) {
        String result = StringUtils.trimToNull((String)permission);
        if (result == null) {
            return null;
        }
        try {
            return Permission.valueOf((String)result.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.permission.invalid", new Object[]{permission}));
        }
    }
}

