/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestDetailedGroup;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedGroup;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedUser;
import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.user.AbstractPermissionResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@Path(value="admin/permissions")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@LicensedOnly
@Tag(name="Permission Management")
@WebSudoRequired
public class GlobalPermissionResource
extends AbstractPermissionResource {
    @Inject
    public GlobalPermissionResource(DmzPermissionAdminService permissionAdminService, UserService userService, I18nService i18nService) {
        super(i18nService, permissionAdminService, userService);
    }

    @Operation(description="Retrieve a page of groups that have been granted at least one global permission.\n\n\nThe authenticated user must have <strong>ADMIN</strong> permission or higher to call this resource.", summary="Get groups with a global permission")
    @Parameter(name="filter", description="If specified only group names containing the supplied string will be returned", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups and their highest global permissions.", paged=true, representation=RestPermittedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not an administrator.", responseCode=401, restError=true)})
    @GET
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroupsWithAnyPermission(@QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findGroupsWithGlobalPermission(filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestPermittedGroup.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of users that have been granted at least one global permission.\n\n\nThe authenticated user must have <strong>ADMIN</strong> permission or higher to call this resource.", summary="Get users with a global permission")
    @Parameter(name="filter", description="If specified only user names containing the supplied string will be returned", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users and their highest global permissions.", paged=true, representation=RestPermittedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not an administrator.", responseCode=401, restError=true)})
    @GET
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsersWithAnyPermission(@QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findUsersWithGlobalPermission(filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestPermittedUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of groups that have no granted global permissions.\n\n\nThe authenticated user must have <strong>ADMIN</strong> permission or higher to call this resource.", summary="Get groups with no global permission")
    @Parameter(name="filter", description="If specified only user names containing the supplied string will be returned", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups that have not been granted any global permissions.", paged=true, representation=RestDetailedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not an administrator.", responseCode=401, restError=true)})
    @GET
    @Path(value="groups/none")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroupsWithoutAnyPermission(@QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findGroupsWithoutGlobalPermission(filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedGroup.NAME_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of users that have no granted global permissions.\n\n\nThe authenticated user must have <strong>ADMIN</strong> permission or higher to call this resource.", summary="Get users with no global permission")
    @Parameter(name="filter", description="If specified only user names containing the supplied string will be returned", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users that have not been granted any global permissions.", paged=true, representation=RestApplicationUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not an administrator.", responseCode=401, restError=true)})
    @GET
    @Path(value="users/none")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsersWithoutAnyPermission(@QueryParam(value="filter") @DefaultValue(value="") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findUsersWithoutGlobalPermission(filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestApplicationUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Promote or demote a group's global permission level. Available global permissions are:\n\n\n- LICENSED_USER\n- PROJECT_CREATE\n- ADMIN\n- SYS_ADMIN\n\nSee the <a href=\"https://confluence.atlassian.com/display/BitbucketServer/Global+permissions\">Bitbucket Data Center documentation</a> for a detailed explanation of what each permission entails.\n\n\nThe authenticated user must have:\n\n\n- <strong>ADMIN</strong> permission or higher; and\n- the permission they are attempting to grant or higher; and\n- greater or equal permissions than the current permission level of the group (a user may not demote the     permission level of a group with higher permissions than them)\n\n\nto call this resource. In addition, a user may not demote a group's permission level if their own permission\nlevel would be reduced as a result.", summary="Update global permission for group")
    @Parameters(value={@Parameter(name="permission", description="The permission to grant", in=ParameterIn.QUERY, required=true, schema=@Schema(allowableValues={"LICENSED_USER", "PROJECT_CREATE", "ADMIN", "SYS_ADMIN"})), @Parameter(name="name", description="The names of the groups", in=ParameterIn.QUERY, required=true, array=@ArraySchema(schema=@Schema(type="string")))})
    @ResponseDocs(value={@ResponseDoc(documentation="The specified permission was granted to the specified user.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not an administrator or doesn't have the\nspecified permission they are attempting to grant.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would exceed the server's license limits.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified group does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's\npermission level or the currently authenticated user has a lower permission\nlevel than the group they are attempting to modify.", responseCode=409, restError=true)})
    @PUT
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPermissionForGroups(@QueryParam(value="permission") String permissionName, @QueryParam(value="name") Set<String> groupNames) {
        Permission permission = this.validatePermission(permissionName, null);
        Set<String> groups = this.validateGroups(groupNames);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().globalPermission(permission).groups(groups).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Promote or demote the global permission level of a user. Available global permissions are:\n\n\n- LICENSED_USER\n- PROJECT_CREATE\n- ADMIN\n- SYS_ADMIN\n\n\nSee the <a href=\"https://confluence.atlassian.com/display/BitbucketServer/Global+permissions\">Bitbucket Data Center documentation</a> for a detailed explanation of what each permission entails.\n\n\nThe authenticated user must have:\n\n\n- <strong>ADMIN</strong> permission or higher; and\n- the permission they are attempting to grant; and\n- greater or equal permissions than the current permission level of the user (a user may not demote the     permission level of a user with higher permissions than them)\n\n\nto call this resource. In addition, a user may not demote their own permission level.", summary="Update global permission for user")
    @Parameters(value={@Parameter(name="permission", description="The permission to grant", in=ParameterIn.QUERY, required=true, schema=@Schema(allowableValues={"LICENSED_USER", "PROJECT_CREATE", "ADMIN", "SYS_ADMIN"})), @Parameter(name="name", description="The names of the users", in=ParameterIn.QUERY, required=true, array=@ArraySchema(schema=@Schema(type="string")))})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested permission was granted.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not an administrator or doesn't have the\nspecified permission they are attempting to grant.", responseCode=401, restError=true), @ResponseDoc(documentation="The action was disallowed as it would exceed the server's license limits.", responseCode=403, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's\npermission level or the currently authenticated user has a lower permission\nlevel than the user they are attempting to modify.", responseCode=409, restError=true)})
    @PUT
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPermissionForUsers(@QueryParam(value="name") Set<String> usernames, @QueryParam(value="permission") String permissionName) {
        Permission permission = this.validatePermission(permissionName, null);
        Set<ApplicationUser> users = this.validateUsers(usernames);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().globalPermission(permission).users(users).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Revoke all global permissions for a group.\n\n\n\nThe authenticated user must have:\n\n\n- <strong>ADMIN</strong> permission or higher; and\n- greater or equal permissions than the current permission level of the group (a user may not demote the     permission level of a group with higher permissions than them)\n\n\nto call this resource. In addition, a user may not revoke a group's permissions if their own permission level\nwould be reduced as a result.", summary="Revoke all global permissions for group")
    @Parameter(name="name", description="The name of the group", in=ParameterIn.QUERY, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="All global permissions were revoked from the group.", responseCode=204), @ResponseDoc(documentation="TThe currently authenticated user is not an administrator.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified group does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's\npermission level or the currently authenticated user has a lower permission\nlevel than the group they are attempting to modify.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissionsForGroup(@QueryParam(value="name") String groupName) {
        groupName = this.validateGroup(groupName, true);
        this.permissionAdminService.revokeAllGlobalPermissions(groupName);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Revoke all global permissions for a user.\n\n\nThe authenticated user must have:\n\n\n- <strong>ADMIN</strong> permission or higher; and\n- greater or equal permissions than the current permission level of the user (a user may not demote the     permission level of a user with higher permissions than them)\n\n\nto call this resource. In addition, a user may not demote their own permission level.", summary="Revoke all global permissions for user")
    @Parameter(name="name", description="The name of the user", in=ParameterIn.QUERY, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="All global permissions were revoked from the user.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not an administrator.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user's\npermission level or the currently authenticated user has a lower permission\nlevel than the user they are attempting to modify.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissionsForUser(@QueryParam(value="name") String username) {
        ApplicationUser user = this.validateUser(username, true);
        this.permissionAdminService.revokeAllGlobalPermissions(user);
        return ResponseFactory.noContent().build();
    }
}

