/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="groups")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Permission Management")
public class GroupResource {
    private final UserService userService;

    @Inject
    public GroupResource(UserService userService) {
        this.userService = userService;
    }

    @Operation(description="Retrieve a page of group names.\n\nThe authenticated user must have <strong>LICENSED_USER</strong> permission or higher to call this resource.", summary="Get group names")
    @Parameter(description="If specified only group names containing the supplied string will be returned")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of group names.", paged=true, representation=String.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a project administrator.", restError=true, responseCode=401)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroups(@QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page groups = this.userService.findGroupsByName(filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(groups)).build();
    }
}

