/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.permission.RestPermitted;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestDetailedGroup;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedGroup;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedPrincipal;
import com.atlassian.bitbucket.dmz.rest.v2.user.RestPermittedUser;
import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalSearchRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.user.AbstractPermissionResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@Path(value="projects/{projectKey}/permissions")
@PathParamDoc(documentation="The project key", name="projectKey")
@Tag(name="Project")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@LicensedOnly
public class ProjectPermissionResource
extends AbstractPermissionResource {
    @Inject
    public ProjectPermissionResource(DmzPermissionAdminService permissionAdminService, UserService userService, I18nService i18nService) {
        super(i18nService, permissionAdminService, userService);
    }

    @Operation(description="Retrieve a page of groups that have been granted at least one permission for the specified project.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.", summary="Get groups with permission to project")
    @Parameter(description="If specified only group names containing the supplied string will be returned", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups and their highest permissions for the specified project.", paged=true, representation=RestPermittedGroup.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a project administrator for the specified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroupsWithAnyPermission(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findGroupsWithProjectPermission(projectResolver.getProject(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestPermittedGroup.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of groups that have no granted permissions for the specified project.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher", summary="Get groups without project permission")
    @Parameter(description="If specified only group names containing the supplied string will be returned", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of groups that have not been granted any permissions for the specifiedproject.", paged=true, representation=RestDetailedGroup.class, responseCode=202), @ResponseDoc(documentation="The currently authenticated user is not a project administrator for thespecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="groups/none")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getGroupsWithoutAnyPermission(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findGroupsWithoutProjectPermission(projectResolver.getProject(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestDetailedGroup.NAME_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of users that have been granted at least one permission for the specified project.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.", summary="Get users with permission to project")
    @Parameter(description="If specified only user names containing the supplied string will be returned", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users and their highest permissions for the specified project.", paged=true, representation=RestPermittedUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a project administrator for thespecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsersWithAnyPermission(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findUsersWithProjectPermission(projectResolver.getProject(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestPermittedUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieve a page of <i>licensed</i> users that have no granted permissions for the specified project.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.", summary="Get users without project permission")
    @Parameter(description="If specified only user names containing the supplied string will be returned", in=ParameterIn.QUERY, name="filter")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of users that have not been granted any permissions for the specified project", paged=true, representation=RestApplicationUser.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not a project administrator for thespecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="users/none")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUsersWithoutPermission(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.permissionAdminService.findLicensedUsersWithoutProjectPermission(projectResolver.getProject(), filter, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestApplicationUser.REST_TRANSFORM)).build();
    }

    @Operation(description="Promote or demote a group's permission level for the specified project.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource. In addition, a user may not demote a group's permission level if theirown permission level would be reduced as a result.", summary="Update group project permission")
    @Parameters(value={@Parameter(description="The names of the groups", in=ParameterIn.QUERY, name="name"), @Parameter(description="The permission to grant.See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+project+permissions)for a detailed explanation of what each permission entails. Available project permissions are:\n\n- PROJECT_READ\n- PROJECT_WRITE\n- PROJECT_ADMIN\n\n\n", in=ParameterIn.QUERY, name="permission")})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested permission was granted.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specifiedspecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user'spermission level.", restError=true, responseCode=403)})
    @PUT
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPermissionForGroups(@BeanParam ProjectResolver projectResolver, @QueryParam(value="permission") String permissionName, @QueryParam(value="name") Set<String> groupNames) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        Set<String> groups = this.validateGroups(groupNames);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().projectPermission(permission, projectResolver.getProject()).groups(groups).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Promote or demote a user's permission level for the specified project.\n\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource. In addition, a user may not reduce their own permission level unless they have a global permission that already implies that permission.", summary="Update user project permission")
    @Parameters(value={@Parameter(description="The names of the users", in=ParameterIn.QUERY, name="name"), @Parameter(description="The permission to grant.See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+project+permissions)for a detailed explanation of what each permission entails. Available project permissions are:\n\n- PROJECT_READ\n- PROJECT_WRITE\n- PROJECT_ADMIN\n\n\n", in=ParameterIn.QUERY, name="permission")})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested permission was granted.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specifiedspecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user'spermission level.", restError=true, responseCode=403)})
    @PUT
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPermissionForUsers(@BeanParam ProjectResolver projectResolver, @QueryParam(value="name") Set<String> usernames, @QueryParam(value="permission") String permissionName) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        Set<ApplicationUser> users = this.validateUsers(usernames);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().projectPermission(permission, projectResolver.getProject()).users(users).build());
        return ResponseFactory.noContent().build();
    }

    @Operation(description=" Revoke all permissions for the specified project for a group.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.\n\nIn addition, a user may not revoke a group's permissions if it will reduce their own permission level.", summary="Revoke group project permission")
    @Parameter(description="The name of the group", in=ParameterIn.QUERY, name="name")
    @ResponseDocs(value={@ResponseDoc(documentation="All project permissions were revoked from the group for the specified project.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specifiedspecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation=" The action was disallowed as it would reduce the currently authenticated user'spermission level.", restError=true, responseCode=409)})
    @DELETE
    @Path(value="groups")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissionsForGroup(@BeanParam ProjectResolver projectResolver, @QueryParam(value="name") String groupName) {
        groupName = this.validateGroup(groupName, true);
        this.permissionAdminService.revokeAllProjectPermissions(projectResolver.getProject(), groupName);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Revoke all permissions for the specified project for a user.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.\n\nIn addition, a user may not revoke their own project permissions if they do not have a higher global permission.", summary="Revoke user project permission")
    @Parameter(description="The name of the user", in=ParameterIn.QUERY, name="name")
    @ResponseDocs(value={@ResponseDoc(documentation="All project permissions were revoked from the user for the specified project.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specifiedspecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation=" The action was disallowed as it would reduce the currently authenticated user'spermission level.", restError=true, responseCode=409)})
    @DELETE
    @Path(value="users")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissionsForUser(@BeanParam ProjectResolver projectResolver, @QueryParam(value="name") String username) {
        ApplicationUser user = this.validateUser(username, true);
        this.permissionAdminService.revokeAllProjectPermissions(projectResolver.getProject(), user);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Revoke all permissions for the specified project for the given groups and users.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.\n\nIn addition, a user may not revoke a group's permission if their own permission would be revoked as a result, nor may they revoke their own permission unless they have a global permission that already implies that permission.", summary="Revoke project permissions")
    @Parameters(value={@Parameter(description="The names of the groups", in=ParameterIn.QUERY, name="group"), @Parameter(description="The names of the users", in=ParameterIn.QUERY, name="user")})
    @ResponseDocs(value={@ResponseDoc(documentation="All project permissions were revoked from the users and groups for the specified project.", responseCode=204), @ResponseDoc(documentation="No permissions were revoked because the request was invalid. No users or groups were provided.", responseCode=400), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specifiedspecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist, or one or more of the users or groups provided does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The action was disallowed as it would revoke the currently authenticated user's permission on the project.", restError=true, responseCode=409)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response revokePermissions(@BeanParam ProjectResolver projectResolver, @QueryParam(value="group") Set<String> groupNames, @QueryParam(value="user") Set<String> usernames) {
        Set<String> groups = this.validateGroupsForRevocation(groupNames);
        Set<ApplicationUser> users = this.validateUsersForRevocation(usernames);
        if (groups.isEmpty() && users.isEmpty()) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.permission.no.principals", new Object[0]));
        }
        this.permissionAdminService.revokeAllProjectPermissions(projectResolver.getProject(), groups, users);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Check whether the specified permission is the default permission (granted to all users) for a project.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.", summary="Check default project permission")
    @Parameter(description="The permission to grant. Available project permissions are:\n\n- PROJECT_READ\n- PROJECT_WRITE\n- PROJECT_ADMIN\n\n\n", in=ParameterIn.PATH, name="permission")
    @ResponseDocs(value={@ResponseDoc(documentation="A simple entity indicating whether the specified permission is the defaultpermission for this project.", representation=RestPermitted.class, responseCode=200), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specifiedspecified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The action was disallowed as it would reduce the currently authenticated user'spermission level.", restError=true, responseCode=403)})
    @GET
    @Path(value="{permission}/all")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response hasAllUserPermission(@BeanParam ProjectResolver projectResolver, @PathParam(value="permission") String permissionName) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        return ResponseFactory.ok((Object)new RestPermitted(this.permissionAdminService.hasAllProjectPermission(permission, projectResolver.getProject()))).build();
    }

    @Operation(description="Grant or revoke a project permission to all users, i.e. set the default permission.\n\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher\nglobal permission to call this resource.", summary="Grant project permission")
    @Parameters(value={@Parameter(description="<em>true</em> to grant the specified permission to all users, or <em>false</em> to revoke it", in=ParameterIn.QUERY, name="allow"), @Parameter(description="The permission to grant. Available project permissions are:\n\n- PROJECT_READ\n- PROJECT_WRITE\n- PROJECT_ADMIN\n\n\n", in=ParameterIn.PATH, name="permission")})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested permission was successfully granted or revoked.", responseCode=204), @ResponseDoc(documentation="The request was malformed or the specified permission does not exist.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user is not an administrator for the specified project.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist.", restError=true, responseCode=404)})
    @POST
    @Path(value="{permission}/all")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response modifyAllUserPermission(@BeanParam ProjectResolver projectResolver, @PathParam(value="permission") String permissionName, @QueryParam(value="allow") Boolean allow) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        if (allow == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.invalidallow", new Object[0]);
            throw new BadRequestException(message);
        }
        if (allow.booleanValue()) {
            this.permissionAdminService.grantAllProjectPermission(permission, projectResolver.getProject());
        } else {
            this.permissionAdminService.revokeAllProjectPermission(permission, projectResolver.getProject());
        }
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Search direct and implied permissions of principals (users and groups). This endpoint returns a superset of the results returned by the /users and /groups endpoints because it allows filtering by global permissions too.\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project or a higher global permission to call this resource.", summary="Search project permissions")
    @Parameters(value={@Parameter(description="Name of the user or group to filter the name of", in=ParameterIn.QUERY, name="filterText"), @Parameter(description="Type of entity (user or group)Valid entity types are:\n\n- USER- GROUP", in=ParameterIn.QUERY, name="type"), @Parameter(description="Permissions to filter by. See the [permissions documentation](https://confluence.atlassian.com/display/BitbucketServer/Using+project+permissions)for a detailed explanation of what each permission entails. This parameter can be specified multiple times to filter by more than one permission, and can contain global and project permissions.\n\n", in=ParameterIn.QUERY, name="permission")})
    @GET
    @Path(value="search")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchPermissions(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filterText") String filterText, @QueryParam(value="type") String type, @QueryParam(value="permission") Set<String> permissions, @BeanParam PageRequestResolver pageRequestResolver) {
        Set<Permission> parsedPermissions = this.parsePermissions(permissions);
        for (Permission permission : parsedPermissions) {
            if (!permission.isResource(Repository.class)) continue;
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.permission.invalidresource", new Object[]{permission, ScopeType.PROJECT.name()}));
        }
        Page principals = this.permissionAdminService.searchPrincipals((PermittedPrincipalSearchRequest)new PermittedPrincipalProjectSearchRequest(projectResolver.getProject(), StringUtils.trimToNull((String)filterText), this.parseType(type), parsedPermissions), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(principals, RestPermittedPrincipal.REST_TRANSFORM)).build();
    }
}

