/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.util.RestPermissionUtils;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.util.PageHelper;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.RecentlyAccessedRepositoriesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="profile/recent/repos")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RecentlyAccessedRepositoriesResource {
    private static final int DEFAULT_RECENT_REPOS_LIMIT = 15;
    private final I18nService i18nService;
    private final RecentlyAccessedRepositoriesService recentRepositoriesService;

    @Inject
    public RecentlyAccessedRepositoriesResource(I18nService i18nService, RecentlyAccessedRepositoriesService recentRepositoriesService) {
        this.i18nService = i18nService;
        this.recentRepositoriesService = recentRepositoriesService;
    }

    @Operation(description="Retrieve a page of recently accessed repositories for the currently authenticated user. \n\nRepositories are ordered from most recently to least recently accessed. <p>Only authenticated users may call this resource.", summary="Get recently accessed repositories")
    @Parameter(description="(optional) If specified, it must be a valid repository permission level name and will limit the resulting repository list to ones that the requesting user has the specified permission level to. If not specified, the default <code>REPO_READ</code> permission level will be assumed.", in=ParameterIn.QUERY, name="permission", schema=@Schema(defaultValue="REPO_READ"))
    @ResponseDocs(value={@ResponseDoc(documentation="A page of recently accessed repositories.", paged=true, representation=RestRepository.class, responseCode=200), @ResponseDoc(documentation="The permission level is unknown or not related to repository.", restError=true, responseCode=400), @ResponseDoc(documentation="The request is unauthenticated.", restError=true, responseCode=401)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoriesRecentlyAccessed(@Context UriInfo uriInfo, @QueryParam(value="permission") String permission) {
        PageRequest pageRequest = PageHelper.createPageRequest((I18nService)this.i18nService, (UriInfo)uriInfo, (int)15);
        Permission stashPermission = RestPermissionUtils.parsePermission((I18nService)this.i18nService, (String)permission, Repository.class, (Permission)Permission.REPO_READ, (String)"permission");
        Page page = this.recentRepositoriesService.findByCurrentUser(stashPermission, pageRequest);
        return ResponseFactory.ok((Object)new RestPage(page, RestRepository.REST_TRANSFORM)).build();
    }
}

